use ExtUtils::MakeMaker;

########################################################################
#
# In this script, we control the SWIG autogeneration of C (XS) and
# Perl wrappers for the native code in this module. This is set up to
# run prior to the generation of the "Makefile". (Note that the
# "MANIFEST" file already contains entries for the autogenerated
# files, since any correct use of the "MANIFEST" will be only after an
# autogeneration.) The autogeneration will only run if the generated
# files are out of date. The desired effect is --
#
# 1. Running "perl Makefile.PL" with a clean CVS checkout of the
#    source tree will do the autogeneration. This requires that SWIG
#    be installed;
#
# 2. Subsequently, running "make dist" will put the autogenerated
#    wrappers in the distribution tarball;
#
# 3. Running "perl Makefile.PL" from the contents of the distribution
#    tarball will find up-to-date wrappers, so nothing will happen
#    and, most importantly, SWIG will not be required to compile; but
#
# 4. Someone who gets the distribution tarball and, for compatibility
#    reasons, wishes to rebuild the wrappers using a different version
#    of Perl and/or SWIG, can still do so.
#
########################################################################

my $manifestFile      = "MANIFEST";
my $swigInterfaceFile = "native/Native.i";
my $swigWrapperFile   = "native/Native_wrap.cxx";
my $swigPerlDir       = "lib/GO/TermFinder";
my $swigPerlFile      = $swigPerlDir . "/Native.pm";

########################################################################

sub runSwigAutogeneration{

  print "Autogenerating wrappers from SWIG interface " . $swigInterfaceFile . "\n";

  mkdir $swigPerlDir || die "Cannot create $swigPerlDir directory : $!";

  my $command = "swig -perl -c++ -Icpp -outdir " . $swigPerlDir . " " . $swigInterfaceFile;

  system($command);

  if ($?){

      print "An error occurred when generating the wrappers from the SWIG interface :\n$!\n";

      print "The command that was run was:\n\n$command\n\n";

      print "GO::TermFinder cannot be built.  Please contact the authors.\n";

      exit;

  }

}

########################################################################

sub existsAndUpToDate{

  my ($sourceFile, $destFile) = @_;

  if (!(-e $destFile)) { return 0; }

  my $sourceMtime = (stat $sourceFile)[9];
  my $destMtime = (stat $destFile)[9];

  return $destMtime >= $sourceMtime;
}

########################################################################

runSwigAutogeneration() unless
  existsAndUpToDate($swigInterfaceFile, $swigWrapperFile) &&
  existsAndUpToDate($swigInterfaceFile, $swigPerlFile);

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

WriteMakefile(
	      'NAME'		=> 'GO-TermFinder',
	      'VERSION_FROM'	=> 'VERSION', # finds $VERSION
	      'PREREQ_PM'	=> { Storable   => '1.0.1.12',
				     GD         => 0, # comment this out if you don't want to use GO::View 
				     GraphViz   => 0, # comment this out if you don't want to use GO::View 
				     CGI        => 0,  # needed for GO::TermFinderReport::Html
				     Test::More => 0
				 },
	      'NO_META'         => 1,
	      ($] >= 5.005 ?    ## Add these new keywords supported since 5.005
	       (ABSTRACT        => 'A collection of modules for working with gene ontologies',
		AUTHOR          => 'Gavin Sherlock <sherlock@genome.stanford.edu>') : ()),
	      );
