
use strict;
use warnings;

use Module::Build 0.3601;


my %module_build_args = (
  "build_requires" => {
    "Module::Build" => "0.3601"
  },
  "configure_requires" => {
    "Module::Build" => "0.3601"
  },
  "dist_abstract" => "Install all modules authored by SHARYANTO on CPAN",
  "dist_author" => [
    "Steven Haryanto <stevenharyanto\@gmail.com>"
  ],
  "dist_name" => "Task-BeLike-SHARYANTO-Authored",
  "dist_version" => "0.12",
  "license" => "perl",
  "module_name" => "Task::BeLike::SHARYANTO::Authored",
  "recommends" => {},
  "recursive_test_files" => 1,
  "requires" => {
    "Acme::CPANAuthors::Indonesian" => 0,
    "Alt::Base" => 0,
    "Alt::Log::Any::App::FWR" => 0,
    "Any::Renderer::Pretty::Console" => 0,
    "Any::Renderer::Pretty::HTML" => 0,
    "App::HTMLCalendarMonth::Indonesia" => 0,
    "App::HasPrereqs" => 0,
    "App::LintPrereqs" => 0,
    "App::ListPrereqs" => 0,
    "App::OrgUtils" => 0,
    "App::ParseCPANChanges" => 0,
    "App::SerializeUtils" => 0,
    "App::UniqFiles" => 0,
    "App::cal::id" => 0,
    "App::cpanlists" => 0,
    "App::cpanlists::Server" => 0,
    "App::dux" => 0,
    "App::perlmv" => 0,
    "App::smtpstatus" => 0,
    "Array::Find" => 0,
    "Array::Functions::Undoable" => 0,
    "Array::Iterator" => 0,
    "Bench" => 0,
    "Builtin::Logged" => 0,
    "Business::BankCard" => 0,
    "Business::BankCard::Indonesia" => 0,
    "Business::BankList" => 0,
    "Business::BankList::Indonesia" => 0,
    "Business::ID::BCA" => 0,
    "Business::ID::Mandiri" => 0,
    "Business::ID::NIK" => 0,
    "Business::ID::NOPPBB" => 0,
    "Business::ID::NPWP" => 0,
    "Business::ID::SIM" => 0,
    "CPAN::Critic::Module::Abstract" => 0,
    "Calendar::Indonesia::Holiday" => 0,
    "Carp::Always::Dump" => 0,
    "Carp::Always::SyntaxHighlightSource" => 0,
    "Color::ANSI::Util" => 0,
    "Config::IOD" => 0,
    "Crypt::Password::Util" => 0,
    "Data::Clean::JSON" => 0,
    "Data::Dump::Ala::SHARYANTO" => 0,
    "Data::Dump::Color" => 0,
    "Data::Dump::OneLine" => 0,
    "Data::Dump::PHP" => 0,
    "Data::Dump::Partial" => 0,
    "Data::Dump::Ruby" => 0,
    "Data::Format::Pretty" => 0,
    "Data::Format::Pretty::Console" => 0,
    "Data::Format::Pretty::HTML" => 0,
    "Data::Format::Pretty::JSON" => 0,
    "Data::Format::Pretty::PHP" => 0,
    "Data::Format::Pretty::PHPSerialization" => 0,
    "Data::Format::Pretty::Perl" => 0,
    "Data::Format::Pretty::Ruby" => 0,
    "Data::Format::Pretty::YAML" => 0,
    "Data::ModeMerge" => 0,
    "Data::Sah" => 0,
    "Data::Sah::Util" => 0,
    "Data::Unixish" => 0,
    "Data::Unixish::ansi" => 0,
    "DateTime::Format::Indonesian" => 0,
    "DefHash" => 0,
    "Devel::EndStats" => 0,
    "Dist::Create::TaskBeLikeFavorited" => 0,
    "Dist::Zilla::Plugin::Extras" => 0,
    "Dist::Zilla::Plugin::Rinci::Validate" => 0,
    "Dist::Zilla::Plugin::Test::Rinci" => 0,
    "Dist::Zilla::PluginBundle::SHARYANTO" => 0,
    "File::Append::Undoable" => 0,
    "File::Copy::Undoable" => 0,
    "File::Move::Undoable" => 0,
    "File::Patch::Undoable" => 0,
    "File::Prepend::Undoable" => 0,
    "File::RsyBak" => 0,
    "File::Slurp::Shortcuts" => 0,
    "File::Trash::FreeDesktop" => 0,
    "File::Trash::Undoable" => 0,
    "File::Truncate::Undoable" => 0,
    "File::Write::Rotate" => 0,
    "Finance::Bank::ID::BCA" => 0,
    "Finance::Bank::ID::BPRKS" => 0,
    "Finance::Bank::ID::Mandiri" => 0,
    "Finance::Currency::Convert::KlikBCA" => 0,
    "Gepok" => 0,
    "Git::Bunch" => 0,
    "HTTP::Daemon::Patch::IPv6" => 0,
    "HTTP::Daemon::UNIX" => 0,
    "HTTP::Headers::Patch::DontUseStorable" => 0,
    "HTTP::Tiny::Patch::LogAny" => 0,
    "Hash::DefHash" => 0,
    "IOD" => 0,
    "JSON::Color" => 0,
    "LWP::Protocol::http::SocketUnixAlt" => 0,
    "LWP::UserAgent::Patch::HTTPSHardTimeout" => 0,
    "LWP::UserAgent::Patch::LogRequestContent" => 0,
    "LWP::UserAgent::Patch::LogResponse" => 0,
    "Language::Expr" => 0,
    "Ledger::Parser" => 0,
    "Lingua::EN::Number::Format::MixWithWords" => 0,
    "Lingua::ID::Number::Format::MixWithWords" => 0,
    "Lingua::ID::Nums2Words" => 0,
    "Lingua::ID::Words2Nums" => 0,
    "Lingua::SU::Nums2Words" => 0,
    "Lingua::ZH::PinyinConvert::ID" => 0,
    "Locale::ID::GuessGender::FromFirstName" => 0,
    "Locale::ID::Locality" => 0,
    "Locale::ID::Province" => 0,
    "Log::Any::Adapter::Callback" => 0,
    "Log::Any::Adapter::Core::Patch::SetDumperIndent" => 0,
    "Log::Any::Adapter::Core::Patch::UseDataDump" => 0,
    "Log::Any::Adapter::Core::Patch::UseDataDumperPerltidy" => 0,
    "Log::Any::Adapter::ScreenColoredLevel" => 0,
    "Log::Any::App" => 0,
    "Log::Any::For::Class" => 0,
    "Log::Any::For::DBI" => 0,
    "Log::Any::For::HTTP::Tiny" => 0,
    "Log::Any::For::LWP" => 0,
    "Log::Any::For::STDERR" => 0,
    "Log::Dispatch::Dir" => 0,
    "Log::Dispatch::FileWriteRotate" => 0,
    "Module::Patch" => 0,
    "Monkey::Patch::Action" => 0,
    "Net::HTTP::Methods::Patch::LogRequest" => 0,
    "Number::Closest::NonOO" => 0,
    "Object::BlankStr" => 0,
    "Object::NulStr" => 0,
    "Object::SpaceBackStr" => 0,
    "Org::Parser" => 0,
    "Org::To::HTML" => 0,
    "Org::To::Pod" => 0,
    "Org::To::Text" => 0,
    "Parse::Netstat" => 0,
    "Parse::Number::EN" => 0,
    "Parse::Number::ID" => 0,
    "Parse::PhoneNumber::ID" => 0,
    "Parse::VarName" => 0,
    "Passwd::Unix::Alt" => 0,
    "Perinci" => 0,
    "Perinci::Access" => 0,
    "Perinci::Access::Base" => 0,
    "Perinci::Access::HTTP::Client" => 0,
    "Perinci::Access::HTTP::Server" => 0,
    "Perinci::Access::InProcess" => 0,
    "Perinci::Access::Simple::Client" => 0,
    "Perinci::Access::Simple::Server" => 0,
    "Perinci::BashComplete" => 0,
    "Perinci::CmdLine" => 0,
    "Perinci::Easy" => 0,
    "Perinci::Examples" => 0,
    "Perinci::Examples::Bin" => 0,
    "Perinci::Exporter" => 0,
    "Perinci::Gen::ForModule" => 0,
    "Perinci::Object" => 0,
    "Perinci::Result::Format" => 0,
    "Perinci::Sub::ConvertArgs::Array" => 0,
    "Perinci::Sub::Dep::pm" => 0,
    "Perinci::Sub::DepChecker" => 0,
    "Perinci::Sub::DepUtil" => 0,
    "Perinci::Sub::FeatureUtil" => 0,
    "Perinci::Sub::Gen" => 0,
    "Perinci::Sub::Gen::AccessTable" => 0,
    "Perinci::Sub::Gen::AccessTable::DBI" => 0,
    "Perinci::Sub::GetArgs::Argv" => 0,
    "Perinci::Sub::GetArgs::Array" => 0,
    "Perinci::Sub::Property::curry" => 0,
    "Perinci::Sub::Property::dies_on_error" => 0,
    "Perinci::Sub::Property::drops_privilege" => 0,
    "Perinci::Sub::Property::result_postfilter" => 0,
    "Perinci::Sub::Property::retry" => 0,
    "Perinci::Sub::Property::timeout" => 0,
    "Perinci::Sub::PropertyUtil" => 0,
    "Perinci::Sub::To::POD" => 0,
    "Perinci::Sub::To::ReForm" => 0,
    "Perinci::Sub::To::Text" => 0,
    "Perinci::Sub::Wrapper" => 0,
    "Perinci::To::HTML" => 0,
    "Perinci::To::POD" => 0,
    "Perinci::To::Text" => 0,
    "Perinci::Tx::Manager" => 0,
    "Perinci::Use" => 0,
    "Perinci::Util" => 0,
    "Perinci::Web" => 0,
    "Perl::Stripper" => 0,
    "Pod::Weaver::Plugin::Eval" => 0,
    "Pod::Weaver::Plugin::Perinci" => 0,
    "Pod::Weaver::PluginBundle::SHARYANTO" => 0,
    "Pod::Weaver::Section::Changes" => 0,
    "Process::Govern" => 0,
    "Process::KillTree" => 0,
    "Progress::Any" => 0,
    "Progress::Any::Output" => 0,
    "Progress::Any::Output::Callback" => 0,
    "Progress::Any::Output::LogAny" => 0,
    "Progress::Any::Output::TermMessage" => 0,
    "Progress::Any::Output::TermProgressBar" => 0,
    "Progress::Any::Output::TermProgressBarColor" => 0,
    "RSS::From::Forum::vBulletin" => 0,
    "Riap" => 0,
    "Rinci" => 0,
    "Rinci::Schema" => 0,
    "SHARYANTO" => 0,
    "SHARYANTO::SQL::Schema" => 0,
    "SHARYANTO::String::Util" => 0,
    "SHARYANTO::Utils" => 0,
    "Sah" => 0,
    "Serabi" => 0,
    "Setup" => 0,
    "Setup::File" => 0,
    "Setup::File::Symlink" => 0,
    "Setup::File::TextFragment" => 0,
    "Setup::Unix::User" => 0,
    "Software::Catalog" => 0,
    "Software::Release::Watch" => 0,
    "Software::Release::Watch::sw::wordpress" => 0,
    "Syntax::Feature::EachOnArray" => 0,
    "SyntaxHighlight::Any" => 0,
    "Term::Detect" => 0,
    "Term::ProgressBar::Color" => 0,
    "Test::Rinci" => 0,
    "Test::Sah" => 0,
    "Text::ANSI::Util" => 0,
    "Text::ANSITable" => 0,
    "Text::ANSITable::BorderStyle::Extra" => 0,
    "Text::ANSITable::ColorTheme::Extra" => 0,
    "Text::Fragment" => 0,
    "Text::WideChar::Util" => 0,
    "Text::sprintfn" => 0,
    "Tie::Diamond" => 0,
    "Tie::Handle::FileWriteRotate" => 0,
    "Time::Duration::Patch::Millisecond" => 0,
    "Time::Duration::id" => 0,
    "UUID::Random::Patch::UseMRS" => 0,
    "Unix::Passwd::File" => 0,
    "Unixish" => 0,
    "WWW::GudangAPI" => 0,
    "Web::Detect" => 0,
    "YAML::Tiny::Color" => 0,
    "tainting" => 0
  },
  "script_files" => [],
  "test_requires" => {
    "Capture::Tiny" => 0,
    "Test::More" => "0.88",
    "blib" => 0
  }
);


unless ( eval { Module::Build->VERSION(0.4004) } ) {
  my $tr = delete $module_build_args{test_requires};
  my $br = $module_build_args{build_requires};
  for my $mod ( keys %$tr ) {
    if ( exists $br->{$mod} ) {
      $br->{$mod} = $tr->{$mod} if $tr->{$mod} > $br->{$mod};
    }
    else {
      $br->{$mod} = $tr->{$mod};
    }
  }
}

my $build = Module::Build->new(%module_build_args);

$build->create_build_script;
