#!/usr/bin/perl
#
use strict ;
use POSIX qw(strftime);

use App::Framework ;

	# Create application and run it
	App::Framework->new()->go() ;



#=================================================================================
# SUBROUTINES EXECUTED BY APP
#=================================================================================

#----------------------------------------------------------------------
# Main execution
#
sub run
{
	my ($app) = @_ ;
	
	# options
	my %opts = $app->options() ;


	# Set up database
	my %sql_vars ;
	$app->set(
		'sql' => {
			'database'	=> $opts{'database'},
			'table'		=> $opts{'table'},
			'user'		=> $opts{'user'},
			'password'	=> $opts{'password'},
			
			'trace'		=> $opts{'debug'},
#			'trace'		=> 4,
			'trace_file'=> 'logsql.log',
#'debug' => 2,
			
			'prepare'	=> {
				'insert'	=> {
					'vars'	=> [qw/pid channel title date start duration episode num_episodes repeat text genre chan_type/],
					'vals'	=> \%sql_vars,
				}, 

				# Update type, list a var names, where to get values (HASH ref or ARRAY ref), where clause, where names, where to get values, optional table name
				'update'	=> {
					'vars'	=> [qw/title date start duration text episode num_episodes repeat text genre chan_type/],
					'vals'	=> \%sql_vars,
					'where'	=> {
						'vars'	=> [qw/pid channel/],
						'vals'	=> \%sql_vars
					}, 
					'limit'	=> 1,
				}, 

				# select type, 
				'check'		=> {
					'limit'	=> 1,
					'where'	=> {
						'vars'	=> [qw/pid channel/],
						'vals'	=> \%sql_vars
					}, 
				}, # 'check'

				# get channels 
				'select_channels'		=> {
					'table'	=> 'channels',
				},

				'delete'		=> {
					'where'	=> "`start` >= ? AND `date` >= ? AND `start` < ? AND `date` < ?", 
				}, # 'delete'

			}, # 'prepare'
		}, #'sql'
	) ;

	# load in channel information
	my %dvb_pr = read_dvb_pr($opts{'dir'}) ;

#$app->prt_data("dvb-ts:", \%dvb_ts, "dvb-pr:", \%dvb_pr) ;
	
	# Read in epg
	my ($epg_href, $dates_href) = read_epg($app, $opts{'epg'}, \%dvb_pr) ;
	%dvb_pr = () ;
	my %epg = %$epg_href ;
	my %dates = %$dates_href ;
	
$app->prt_data("EPG:", \%epg) if $opts{'debug'}>2;
$app->prt_data("DATES:", \%dates) if $opts{'debug'}>1;

	return if $opts{'skip_mysql'} ;


	### Update database ###
	print "\nUpdating database:\n" ;

	# Add data to database	
	foreach my $chan (sort keys %epg)
	{
#TODO: Ensure channel list is up to date
		print "  $chan...\n" ;
		next unless $chan ;

		# Remove any information covered by the current epg data
#		$app->sql_query("delete", $dates{$chan}[qw/start start_date end end_date/]) ;
		my $del_query = "DELETE FROM $opts{table} WHERE ".
			"`channel`='$chan' AND (".
			"(`date` = '$dates{$chan}{start_date}' AND `start` >= '$dates{$chan}{start}') ".
			"OR (`date` > '$dates{$chan}{start_date}' AND `date` <= '$dates{$chan}{end_date}') ".
			")" ;
#			"OR (`date` > '$dates{$chan}{start_date}' AND `date` < '$dates{$chan}{end_date}') ".
#			"OR (`date` = '$dates{$chan}{end_date}' AND `start` < '$dates{$chan}{end}') " ;
		
		$app->sql->query($del_query) ;
print "$chan : $del_query\n" 
	if ($opts{'debug'});


		# do each program
		foreach my $pid (keys %{$epg{$chan}})
		{
			next unless $pid ;
	
			#              date => 18-09-2008,
			#              start => 23:15,
			#              end => 03:20,
			#              duration => 04:05,
			#
			#              title => Personal Services,
			#              synopsis => This is a gently witty, if curiously coy, attempt by director
			#              genre => Film,

			my $episode;
			my $num_episodes ;
			my $repeat ;
			
			if (exists($epg{$chan}{$pid}{'episode'}))
			{
				$episode = int($epg{$chan}{$pid}{'episode'}) ;
				$num_episodes = int($epg{$chan}{$pid}{'num_episodes'}) ;
			}

			my $episode_str = $episode ? "$episode / $num_episodes" : "" ;

			# Copy variables ready for sql ops
			$app->sql_prepare_vals($epg{$chan}{$pid}, \%sql_vars) ;
			
#			$sql_vars{'pid'} = $pid ; 
#			$sql_vars{'channel'} = $chan ; 
#			$sql_vars{'text'} = $epg{$chan}{$pid}{'synopsis'} ; 
#			$sql_vars{'date'} = $app->sql->datestr_to_sqldate($sql_vars{'date'}) ; 

$sql_vars{'text'} .= $sql_vars{'etext'} ;
$sql_vars{'text'} ||= '' ;

$sql_vars{'title'} ||= '(no program)' ;


# TODO: Get channel type
$sql_vars{'chan_type'} = 'tv' ;

			# First check to see if we already have an entry
			if (my $href = $app->sql_query('check')->next('check'))
			{
				# got it already - do update
				
				# do some checking
				my $changed = 1;
			#	my $changed = $episode cmp $href->{'episode'} ;
			#	$changed ||= $num_episodes cmp $href->{'num_episodes'} ;
			#	$changed ||= $repeat cmp $href->{'repeat'} ;
			#	foreach my $field (qw/title date time duration text/)
			#	{
			#		$changed ||= $epg{$chan}{$pid}{$field} cmp $href->{$field} ;
			#	}

				if ($changed)
				{
print "    Update: $epg{$chan}{$pid}{'title'} @ $epg{$chan}{$pid}{'start'} on $epg{$chan}{$pid}{'date'}  $episode_str $repeat\n" ;

					$app->sql_query('update') ;
				}
			}
			else
			{
				# new
print "    New: [$pid] $epg{$chan}{$pid}{'title'} @ $epg{$chan}{$pid}{'start'} on $epg{$chan}{$pid}{'date'}  $episode_str $repeat\n" ;

				$app->sql_query('insert') ;
			}
			
		}
	}
	


}


#=================================================================================
# LOCAL SUBROUTINES
#=================================================================================



#=================================================================================
# SETUP
#=================================================================================
__DATA__
[VERSION]

1.002

[HISTORY]

30-Sep-08   SDP		New

[SUMMARY]

Convert xawtv4 epg file into hash 

[SYNOPSIS]

$name [options]

[OPTIONS]

-d|'dir'=s			TV files directory	[default=~/.tv]

Specify the directory to read the xawtv files from

-epg=s				EPG file [default=~/.tv/epg]

Specify the epg file to read

-db|'database'=s		Database [default=tvguide]

Specify database name

-tbl|'table'=s		Table [default=listings]

Specify database table name

-u|'user'=s		User [default=steve]

Specify Mysql user name

-p|'password'=s		Password

Specify Mysql user password

-skip|'skip_mysql'	Skip database update

Debug: Do not add listings information to database

-dump_channels	Show channel information

Debug: Print out channel information


[DESCRIPTION]

Reads the dvb-pr file generated by xawtv4 channel scan (or alexplore) and parses the epg file (created by dvbrowse)
and outputs channel lists with program dates


along withand writes out the information in channels.conf
(see http://www.linuxtv.org/vdrwiki/index.php/Syntax_of_channels.conf)

