#!/usr/bin/perl
#
use strict ;

use App::Framework qw/Filter/ ;

# VERSION
our $VERSION = '1.000' ;

#dumpvar('App::Framework') ;

	my $o2 = App::Framework->new()->go() ;
#	my $o3 = App::Framework::Base::Object::Logged->new() ;
	
	
	print "Done\n" ;

###################################
sub dumpvar 
{
no strict "vars" ;
no strict "refs" ;

    my ($packageName) = @_;
    local (*alias);             # a local typeglob
    # We want to get access to the stash corresponding to the package
    # name
    *stash = *{"${packageName}::"};  # Now %stash is the symbol table
    $, = " ";                        # Output separator for print
    # Iterate through the symbol table, which contains glob values
    # indexed by symbol names.
    while (($varName, $globValue) = each %stash) {
        print "$varName ============================= \n";
        *alias = $globValue;
        if (defined ($alias)) {
            print "\t \$$varName $alias \n";
        } 
        if (defined (@alias)) {
            print "\t \@$varName @alias \n";
        } 
        if (defined (%alias)) {
            print "\t \%$varName ",%alias," \n";
        }
        if (defined (&alias)) {
            print "\t \&$varName \n";
        } 
     }
}


#=================================================================================
# SUBROUTINES EXECUTED BY APP
#=================================================================================

#----------------------------------------------------------------------
# Main execution
#
sub run
{
	my ($app) = @_ ;
	
	# Get source/dest dirs
	my ($src_dir, $backup_dir) = @{$app->arglist()};
	
		my $x=File::Spec->catfile('a', 'b', 'c');
		print "cat: $x\n" ;
	
}


#=================================================================================
# LOCAL SUBROUTINES
#=================================================================================

#=================================================================================
# SETUP
#=================================================================================
__DATA__


[HISTORY]

28-May-08    SDP        New

[SUMMARY]

Back up rip convert control files

[NAMEARGS]

src_dir:id backup_dir:id

[DESCRIPTION]

B<$name> scans through a directory (and it's subdirectories) looking for rip control files. Stores
any files it finds in a replica of the directory structure, but located under the backup directory.


