#! /usr/local/bin/perl -w


#################################################################################
#										#
#  										#
#   Newsletter v.1.9							       	#
#   Copyright (C) 2003-2004 - Steven Schubiger <steven@accognoscere.org>	#
#   Last changes: 14th November 2004						#
#										#
#   This program is free software; you can redistribute it and/or modify	#
#   it under the terms of the GNU General Public License as published by	#
#   the Free Software Foundation; either version 2 of the License, or		#
#   (at your option) any later version.						#
#										#
#   This program is distributed in the hope that it will be useful,		#
#   but WITHOUT ANY WARRANTY; without even the implied warranty of		#
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		#
#   GNU General Public License for more details.				#
#										#
#   You should have received a copy of the GNU General Public License		#
#   along with this program; if not, write to the Free Software			#
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	#
#										#
#										#
#################################################################################




# Include the configuration file
require 'newsletter.cfg';

# Parse the CGI environment
use CGI;
use CGI::Carp ('fatalsToBrowser');

my $query = new CGI;
my $action = $query->param ('action');
my $mail_submit = $query->param ('mail_submit');
my $name_submit = $query->param ('name_submit');
my $sessionid = $query->param ('sessionid');
my $remove_subscriber = $query->param ('remove_subscriber');
my $newsletter_mail_subject = $query->param ('newsletter_mail_subject');
my $newsletter_mail_message = $query->param ('newsletter_mail_message');
my $password_submit = $query->param ('password_submit');
my $password_submit_2 = $query->param ('password_submit_2');
my $user_submit = $query->param ('user_submit');
my $id = $query->param ('id');
my $admin_user_submit = $query->param ('admin_user_submit');
my $admin_password_submit = $query->param ('admin_password_submit');
my $admin_change_user_settings_active = $query->param ('admin_change_user_settings_active');
my $admin_change_user_password_active = $query->param ('admin_change_user_password_active');
my $admin_delete_user_active = $query->param ('admin_delete_user_active');
my $admin_create_new_user_active = $query->param ('admin_create_new_user_active');
my $email_submit = $query->param ('email_submit');
my $time_out_submit = $query->param ('time_out_submit');
my $admin_sessionid = $query->param ('admin_sessionid');
my $newsletter_archive_logfile_submit = $query->param ('newsletter_archive_logfile_submit');
my $user_view_newsletter_archive_active = $query->param ('user_view_newsletter_archive_active');
my $user_download_newsletter_archive_active = $query->param ('user_download_newsletter_archive_active');


&initialize_paths();



# Launch the main functions
unless ($action) { &subscription_newsletter_form() }

elsif ($action eq 'check_subscriber_entries') {
   &check_subscriber_submit();
   &check_subscriber_entries();
}

elsif ($action eq 'send_newsletter_interface_login') { send_newsletter_interface_login() }
elsif ($action eq 'check_send_newsletter_interface_login') { &check_send_newsletter_interface_login() }
elsif ($action eq 'check_send_newsletter_mail') { &check_send_newsletter_mail() }
elsif ($action eq 'send_newsletter_interface_show_subscribers') { &send_newsletter_interface_show_subscribers() }
elsif ($action eq 'send_newsletter_interface_remove_subscriber') { &send_newsletter_interface_remove_subscriber() }
elsif ($action eq 'send_newsletter_interface_show_newsletter_archive') { &send_newsletter_interface_show_newsletter_archive() }
elsif ($action eq 'send_newsletter_interface_newsletter_archive_perform_action') { &send_newsletter_interface_newsletter_archive_perform_action() }
elsif ($action eq 'send_newsletter_user_faq') { &send_newsletter_user_faq() }
elsif ($action eq 'send_newsletter_interface_logout_user') { &send_newsletter_interface_logout_user() }
elsif ($action eq 'confirm_subscription') { &confirm_subscription() }
elsif ($action eq 'remove_subscription') { &remove_subscription() }
elsif ($action eq 'admin_interface_login') { &admin_interface_login() }
elsif ($action eq 'check_admin_interface_login') { &check_admin_interface_login() }
elsif ($action eq 'print_admin_interface') { &print_admin_interface() }
elsif ($action eq 'admin_perform_user_changes') { &admin_perform_user_changes() }
elsif ($action eq 'admin_user_changes') { &admin_user_changes() }
elsif ($action eq 'admin_interface_logout') { &admin_interface_logout() }


sub initialize_paths {
    unless ($data_dir =~ /\/$/) { $data_dir .= '/' }
    unless ($template_dir =~ /\/$/) { $template_dir .= '/' }
    unless ($$newsletter_archive_dir =~ /\/$/) { $$newsletter_archive_dir .= '/' }
}



# Parse the subscription form HTML & print the HTML
sub subscription_newsletter_form {
    my @status_msg = @_;

    foreach my $error (@status_msg) {
        push (@status_msg_new, $error . '<br>');
    }
    @status_msg = @status_msg_new;

    my $subscription_newsletter_form_html = &parse_template ($subscription_newsletter_form_template);

    $subscription_newsletter_form_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;

    unless ( defined ($name_submit) ) {
        $subscription_newsletter_form_html =~ s/\$NAME_SUBMIT//;
    } else {
        $subscription_newsletter_form_html =~ s/\$NAME_SUBMIT/$name_submit/;
    }

    unless ( defined ($mail_submit) ) {
        $subscription_newsletter_form_html =~ s/\$MAIL_SUBMIT//;
    } else {
        $subscription_newsletter_form_html =~ s/\$MAIL_SUBMIT/$mail_submit/;
    }

    if ( defined (@status_msg) ) {
        $subscription_newsletter_form_html =~ s/\$STATUS_MSG/<br>@status_msg<br><br>/;
    } else {
        $subscription_newsletter_form_html =~ s/\$STATUS_MSG//;
    }

    print "Content-type: text/html\n\n";
    print $subscription_newsletter_form_html;
    exit (0);
}


# Parse whether the input submitted by the user passes our filters or not (if not, output error msg)
sub check_subscriber_submit {
    my @error_submit;

    unless ($name_submit =~ /\w+/) {
        push (@error_submit, "$subscription_newsletter_form_name_missing_msg");
    }
    unless ($mail_submit =~ /\w+\@\w+\.\w{2,3}/) {
        push (@error_submit, "$subscription_newsletter_form_mail_invalid_msg");
    }

    if ( defined (@error_submit) ) {
        &subscription_newsletter_form (@error_submit);
    }
}


# Either add or remove the current subscriber (depends upon the check whether he was subscribed or not)
sub check_subscriber_entries {
    open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    my @subscribers = <SUBSCRIBERS>;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    for (my $i = 0; $i < @subscribers; $i++) {
        ($mail_subscriber, $name_subscriber, $subscriber_signed_up, $timestamp_saved, $id_saved) = split (/:/, $subscribers[$i]);

        if ($mail_submit eq $mail_subscriber) {
            &parse_newsletter_mail_msg ($remove_subscription_mail_msg_file);

            open (SENDMAIL, "| $sendmailpath -t") or die "Could not open pipe to $sendmailpath: $!\n";
            select (SENDMAIL);
            print <<"SENDMAIL";
From: $removal_confirmation_email_from
To: $mail_submit
Subject: $removal_confirmation_email_subject

$mail_msg_part_1
$script_url?action=remove_subscription&id=$id_saved

$mail_msg_part_2
SENDMAIL

            close (SENDMAIL) or die "Could not close pipe to $sendmailpath: $!\n";

	    select (STDOUT);

            &subscription_newsletter_form ($subscription_removing_mail_msg);
        }
    }

    my ($sec, $min, $hour, $day, $month, $year) = localtime (time);
    $month++;
    $year += 1900;

    if ( length ($day) < 2 ) { $day = "0$day" }
    if ( length ($month) < 2 ) { $month = "0$month" }

    my $id = int (rand($random_digit) * rand($random_digit) + 10);
    my $mode = 0;

    my $timestamp = time;

    unshift (@subscribers, "$mail_submit:$name_submit:$day.$month.$year:$timestamp:$id:$mode\n");

    open (SUBSCRIBERS, ">$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    print SUBSCRIBERS @subscribers;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    &parse_newsletter_mail_msg ($confirm_subscription_mail_msg_file);

    open (SENDMAIL, "| $sendmailpath -t") or die "Could not pipe to $sendmailpath: $!\n";

    select (SENDMAIL);

    print <<"SENDMAIL";
From: $subscription_confirmation_email_from
To: $mail_submit
Subject: $subscription_confirmation_email_subject

$mail_msg_part_1
$script_url?action=confirm_subscription&id=$id

$mail_msg_part_2
SENDMAIL

    select (STDOUT);

    close (SENDMAIL) or die "Could not close pipe to $sendmailpath: $!\n";

    &subscription_newsletter_form ($subscription_activating_mail_msg);
}


# Parse the sendnews login HTML & print the HTML
sub send_newsletter_interface_login {
    my $status_msg = shift (@_);

    my $send_newsletter_interface_login_html = &parse_template ($send_newsletter_interface_login_template);

    $send_newsletter_interface_login_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;

    if ( defined ($user_submit) ) {
        $send_newsletter_interface_login_html =~ s/\$USER_SUBMIT_INVISIBLE/$user_submit/;
    } else {
        $send_newsletter_interface_login_html =~ s/\$USER_SUBMIT_INVISIBLE//;
    }

    if ( defined ($status_msg) ) {
        $send_newsletter_interface_login_html =~ s/\$STATUS_MSG/<br>$status_msg<br><br>/;
    } else {
        $send_newsletter_interface_login_html =~ s/\$STATUS_MSG//;
    }

    print "Content-Type: text/html\n\n";
    print $send_newsletter_interface_login_html;
    exit (0);
}


sub check_send_newsletter_interface_login {
    my $send_newsletter_interface_access_allowed = 0;
    my $send_newsletter_interface_password_check_char_failed;

    open (SENDNEWS_USERS_AUTH, "<$data_dir$sendnews_users_auth_file") or die "Could not open $data_dir$sendnews_users_auth_file: $!\n";
    my @sendnews_users = <SENDNEWS_USERS_AUTH>;
    close (SENDNEWS_USERS_AUTH) or die "Could not close $data_dir$sendnews_users_auth_file: $!\n";

    foreach my $user (@sendnews_users) {
        ($user_access, $user_password_access, $user_email, $user_time_out) = split (/\:/, $user);
        chomp ($user_time_out);

        if ($user_submit eq $user_access) {
            if (length ($password_submit) != length ($user_password_access) ) {
                $send_newsletter_interface_password_check_char_failed = 1;
                goto CHECK_STATUS;
            }

            my @password_submit = split (//, $password_submit);
            my @user_password_access = split (//, $user_password_access);

            for (my $i = 0; $i < @user_password_access; $i++) {
                if ($user_password_access[$i] =~ /[1-9]/) {
                    unless ($user_password_access[$i] == $password_submit[$i]) {
                        $send_newsletter_interface_password_check_char_failed = 1;
                        last;
                    }
                } else {
                    unless ($user_password_access[$i] eq $password_submit[$i]) {
                        $send_newsletter_interface_password_check_char_failed = 1;
                        last;
                    }
                }
            }

            CHECK_STATUS:
            unless ($send_newsletter_interface_password_check_char_failed) {
                $send_newsletter_interface_access_allowed = 1;
            }

        }
    }


    if ($send_newsletter_interface_access_allowed == 1) {
        &create_session ($user_submit);
        &drop_unactivated_addresses();
        &send_newsletter_interface_main();
    } else {
        &send_newsletter_interface_login ($send_newsletter_interface_access_denied_msg);
    }
}


# Create a new admin session
sub create_session {
    my $user = shift (@_);

    $sessionid = int ( rand ($random_digit) * rand ($random_digit) + 1);

    open (USER_SESSION, "<$data_dir$user_session_file") or die "Could not open $data_dir$user_session_file: $!\n";
    my @sessions = <USER_SESSION>;
    close (USER_SESSION) or die "Could not close $data_dir$user_session_file: $!\n";

    for ($i = 0; $i < scalar @sessions; $i++) {
        my ($user_session) = split (/\:/, $sessions[$i]);

        if ($user eq $user_session) {
            splice (@sessions, $i, 1);
        }
    }

    open (USER_SESSION, ">$data_dir$user_session_file") or die "Could not open $data_dir$user_session_file: $!\n";
    print USER_SESSION "$user:$sessionid:" . time . ":$user_time_out" . "\n";
    close (USER_SESSION) or die "Could not close $data_dir$user_session_file: $!\n";

    open (USER_SESSION, ">>$data_dir$user_session_file") or die "Could not open $data_dir$user_session_file: $!\n";
    print USER_SESSION @sessions;
    close (USER_SESSION) or die "Could not close $data_dir$user_session_file: $!\n";

    return $sessionid;
}


# Check whether the admin session is valid or not
sub valid_session {
    my $user = shift (@_);

    open (USER_SESSION, "<$data_dir$user_session_file") or die "Could not open $data_dir$user_session_file: $!\n";
    my @sessions = <USER_SESSION>;
    close (USER_SESSION) or die "Could not close $data_dir$user_session_file: $!\n";

    foreach my $session (@sessions) {
        chomp ($session);
        my ($user_session, $sessionid_log, $timestamp_log, $user_time_out) = split (/\:/, $session);

        if ($user eq $user_session) {
            my $waiting_mins = int ( (time - $timestamp_log) / 60);

            if ($sessionid == $sessionid_log && $waiting_mins < $user_time_out) {
                return 1;
            }
        }
    }

    return 0;
}


# Renew the admin session (timestamp)
sub renew_session {
    my $user = shift (@_);
    my $renew_session_successful;

    open (USER_SESSION, "<$data_dir$user_session_file") or die "Could not open $data_dir$user_session_file: $!\n";
    my @session_entries = <USER_SESSION>;
    close (USER_SESSION) or die "Could not close $data_dir$user_session_file: $!\n";

    for ($i = 0; $i < @session_entries; $i++) {
        my ($user_session, $sessionid_log, $timestamp_log, $user_time_out) = split (/\:/, $session_entries[$i]);

        if ($user eq $user_session) {
            $timestamp_log = time;
            $session_entries[$i] = "$user_session:$sessionid_log:$timestamp_log:$user_time_out";

            $renew_session_successful = 1;
            last;
        }
    }

    if ($renew_session_successful) {
        open (USER_SESSION, ">$data_dir$user_session_file") or die "Could not open $data_dir$user_session_file: $!\n";
        print USER_SESSION @session_entries;
        close (USER_SESSION) or die "Could not close $data_dir$user_session_file: $!\n";
    }
}


# Parse the newsform HTML & output the HTML
sub send_newsletter_interface_main {
    my $status_msg = shift (@_);

    my $send_newsletter_interface_main_html = &parse_template ($send_newsletter_interface_main_template);

    $send_newsletter_interface_main_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;
    $send_newsletter_interface_main_html =~ s/\$USER_SUBMIT_INVISIBLE/$user_submit/g;
    $send_newsletter_interface_main_html =~ s/\$SESSIONID_INVISIBLE/$sessionid/g;

    $send_newsletter_interface_main_html =~ s/\$CURRENT_USER/$user_submit/g;

    if ( defined ($status_msg) ) {
        $send_newsletter_interface_main_html =~ s/\$STATUS_MSG/$status_msg<br><br>/;
    } else {
        $send_newsletter_interface_main_html =~ s/\$STATUS_MSG//;
    }

    print "Content-Type: text/html\n\n";
    print $send_newsletter_interface_main_html;
    exit (0);
}


# Check whether the newsletter is valid or not (and redirect back to the form, if not)
sub check_send_newsletter_mail {
    unless ( &valid_session ($user_submit) ) {
        &send_newsletter_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_session ($user_submit);
    }

    unless ($newsletter_mail_message =~ /\w+/) {
        &send_newsletter_interface_main ($send_newsletter_interface_no_mail_message);
    } else {
        &send_newsletter();
    }
}


# Send an newsletter from the admin interface to all subscribers & return a confirmation message
sub send_newsletter {
    unless ( &valid_session ($user_submit) ) {
        &admin_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_session();
    }

    my $newsletter_signature = &parse_newsletter_signature();

    open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";

    while (my $line = <SUBSCRIBERS>) {
        $subscribers_count++;
        ($mail_subscriber, $name_subscriber, $signed_up_subscriber, $timestamp_saved, $id_saved, $mode) = split (/:/, $line);

        if ($mode == 1) {

            $newsletter_mail_subject =~ s/\'name\'/$name_subscriber/ig;
            $newsletter_mail_message =~ s/\'name\'/$name_subscriber/ig;

            open (SENDMAIL, "| $sendmailpath -t") or die "Could not open pipe to $sendmailpath: $!\n";

            select (SENDMAIL);

            print <<"SENDMAIL";
From: $send_newsletter_email_from
To: $mail_subscriber
Subject: $newsletter_mail_subject

$newsletter_mail_message
$newsletter_signature
SENDMAIL

	    select (STDOUT);

            close (SENDMAIL) or die "Could not close pipe to $sendmailpath: $!\n";
        }
    }

    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    &send_newsletter_interface_log_newsletter_archive();
    &send_newsletter_interface_main ($send_newsletter_interface_newsletter_sent_successfully);
}


sub send_newsletter_interface_log_newsletter_archive {
    if ($send_newsletter_interface_log_newsletter_archive_active) {
        unless ($newsletter_archive_dir =~ /\/$/) { $newsletter_archive_dir .= '/' }

        my ($sec, $min, $hour, $day, $month, $year) = localtime (time);
        $month++;
        $year += 1900;

        if (length ($min) < 2) { $min = "0$min" }
        if (length ($hour) < 2) { $hour = "$hour" }
        if (length ($day) < 2) { $day = "0$day" }
        if (length ($month) < 2) { $month = "0$month" }

        my $timezone = ($hour < 12) ? 'am' : 'pm';

        my $subject_shrinked = $newsletter_mail_subject;
        $subject_shrinked =~ s/(.{8}).*/$1/;

        my $newsletter_archive_logfile = "$subject_shrinked" . '_' . "$day.$month.$year" . '_' . "$newsletter_archive_logfile_suffix";

        unless ("-e ./$newsletter_archive_dir$newsletter_archive_logfile") {
            system ("dd if=/dev/null of= ./$newsletter_archive_dir$newsletter_archive_logfile");
        }

        open (SENT_NEWSLETTER_LOGFILE, ">$newsletter_archive_dir$newsletter_archive_logfile") or die "Could not open $newsletter_archive_dir$newsletter_archive_logfile: $!\n";

        select (SENT_NEWSLETTER_LOGFILE);

        print <<"SENT_NEWSLETTER_LOGFILE";
User: $user_submit
Current subscribers: $subscribers_count
Newsletter sent: $hour.$min $timezone - $day.$month.$year
Subject: $newsletter_mail_subject
Message:
$newsletter_mail_message
$newsletter_signature

SENT_NEWSLETTER_LOGFILE

	select (STDOUT);

        close (SENT_NEWSLETTER_LOGFILE) or die "Could not close $newsletter_archive_dir$newsletter_archive_logfile: $!\n";
    }
}


# Show all subscribers within the admin interface & allow the delete certain subscribers by clicking a button
sub send_newsletter_interface_show_subscribers {
    unless ( &valid_session ($user_submit) ) {
        &send_newsletter_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_session ($user_submit);
    }

    open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    my @subscribers = <SUBSCRIBERS>;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    my ($subscriber_saved) = split (/\:/, $subscribers[0]);
    unless ($subscriber_saved =~ /\@/) {
        my $send_newsletter_interface_show_subscribers_none_found_html = &parse_template ($send_newsletter_interface_show_subscribers_none_found_template);

        print "Content-type: text/html\n\n";
        print $send_newsletter_interface_show_subscribers_none_found_html;
        exit (0);
    }

    my $send_newsletter_interface_show_subscribers_html = &parse_template ($send_newsletter_interface_show_subscribers_template);

    my $send_newsletter_interface_show_subscribers_html_header = $send_newsletter_interface_show_subscribers_html;
    my $send_newsletter_interface_show_subscribers_html_body = $send_newsletter_interface_show_subscribers_html;
    my $send_newsletter_interface_show_subscribers_html_footer = $send_newsletter_interface_show_subscribers_html;
    undef $send_newsletter_interface_show_subscribers_html;

    $send_newsletter_interface_show_subscribers_html_header =~ s/\n/newline/g;
    $send_newsletter_interface_show_subscribers_html_body =~ s/\n/newline/g;
    $send_newsletter_interface_show_subscribers_html_footer =~ s/\n/newline/g;

    $send_newsletter_interface_show_subscribers_html_header =~ s/(.*?<table.*?>).*/$1/i;
    $send_newsletter_interface_show_subscribers_html_body =~ s/.*?<table.*?>(.*?)<\/table.*/$1/i;
    $send_newsletter_interface_show_subscribers_html_footer =~ s/.*(<\/table.*)/$1/;

    $send_newsletter_interface_show_subscribers_html_header =~ s/newline/\n/g;
    $send_newsletter_interface_show_subscribers_html_body =~ s/newline/\n/g;
    $send_newsletter_interface_show_subscribers_html_footer =~ s/newline/\n/g;

    print "Content-type: text/html\n\n";
    print $send_newsletter_interface_show_subscribers_html_header;

    open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    my @subscribers = <SUBSCRIBERS>;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    @subscribers = sort { (split (/\:/, $a))[1] cmp (split (/\:/, $b))[1] } @subscribers;

    for (my $i = 0; $i < @subscribers; $i++) {
        my $status_subscription;
        my ($mail_subscriber, $name_subscriber, $signed_up_subscriber, $timestamp_saved, $id_saved, $mode) = split (/\:/, $subscribers[$i]);

        if ($mode == 1) {
            $status_subscription = $subscription_complete_status_msg;
        } else {
            $status_subscription = $subscription_incomplete_status_msg;
        }

        my $send_newsletter_interface_show_subscribers_html_body_in_use =  $send_newsletter_interface_show_subscribers_html_body;
        $send_newsletter_interface_show_subscribers_html_body_in_use =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/;
        $send_newsletter_interface_show_subscribers_html_body_in_use =~ s/\$USER_SUBMIT_INVISIBLE/$user_submit/;
        $send_newsletter_interface_show_subscribers_html_body_in_use =~ s/\$SESSIONID_INVISIBLE/$sessionid/;
        $send_newsletter_interface_show_subscribers_html_body_in_use =~ s/\$MAIL_SUBSCRIBER/$mail_subscriber/g;
        $send_newsletter_interface_show_subscribers_html_body_in_use =~ s/\$NAME_SUBSCRIBER/$name_subscriber/;
        $send_newsletter_interface_show_subscribers_html_body_in_use =~ s/\$SIGNED_UP_SUBSCRIBER/$signed_up_subscriber/;
        $send_newsletter_interface_show_subscribers_html_body_in_use =~ s/\$STATUS_SUBSCRIPTION/$status_subscription/;

        print $send_newsletter_interface_show_subscribers_html_body_in_use;
    }

    print $send_newsletter_interface_show_subscribers_html_footer;
    exit (0);
}


# Remove a current subscriber from the list & return to show all subscribers
sub send_newsletter_interface_remove_subscriber {
    unless ( &valid_session ($user_submit) ) {
        &admin_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_session ($user_submit);
    }

    open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    my @subscribers = <SUBSCRIBERS>;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    print "Content-Type: text/html\n\n";

    for ($i = 0; $i < @subscribers; $i++) {
        my ($mail_subscriber) = split (/:/, $subscribers[$i]);
        if ($mail_subscriber eq $remove_subscriber) {
            splice (@subscribers, $i, 1);
        }
    }

    open (SUBSCRIBERS, ">$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    print SUBSCRIBERS @subscribers;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    &send_newsletter_interface_show_subscribers();
}


sub send_newsletter_interface_show_newsletter_archive {
    unless ( &valid_session ($user_submit) ) {
        &send_newsletter_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_session ($user_submit);
    }

    my $status_msg = shift (@_);

    my $send_newsletter_interface_show_newsletter_archive_html = &parse_template ($send_newsletter_interface_show_newsletter_archive_template);

    opendir (NEWSLETTER_ARCHIVE_DIR, "$newsletter_archive_dir") or die "Could not open $newsletter_archive_dir: $!\n";
    my @newsletter_archive_logfiles = readdir NEWSLETTER_ARCHIVE_DIR;
    closedir (NEWSLETTER_ARCHIVE_DIR) or die "Could not close $newsletter_archive_dir: $!\n";

    splice (@newsletter_archive_logfiles , 0, 2);

    push (@html_newsletter_archive_logfiles, "<option value=\"$send_newsletter_interface_select_newsletter_archive_msg\">$send_newsletter_interface_select_newsletter_archive_msg</option>\n");

    foreach my $newsletter_archive_logfile (@newsletter_archive_logfiles ) {
        my ($subject_logfile, $date_logfile) = split (/\_/, $newsletter_archive_logfile);
        push (@html_newsletter_archive_logfiles, "<option value=\"$newsletter_archive_logfile\">$date_logfile - $subject_logfile</option>\n");
    }

    $send_newsletter_interface_show_newsletter_archive_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/;
    $send_newsletter_interface_show_newsletter_archive_html =~ s/\$USER_SUBMIT_INVISIBLE/$user_submit/;
    $send_newsletter_interface_show_newsletter_archive_html =~ s/\$SESSIONID_INVISIBLE/$sessionid/;
    $send_newsletter_interface_show_newsletter_archive_html =~ s/\$NEWSLETTER_ARCHIVE_LOGFILES/@html_newsletter_archive_logfiles/;

    if ( defined ($status_msg) ) {
        my $breakline_status_msg;

        for (my $i = 1; $i < $breakline_to_status_msg_amount; $i++) {
            $breakline_status_msg .= '<br>';
        }

        $breakline_status_msg .= $status_msg;

        for (my $i = 0; $i < $breakline_to_status_msg_amount; $i++) {
            $breakline_status_msg .= '<br>';
        }
        $status_msg = $breakline_status_msg;

        $send_newsletter_interface_show_newsletter_archive_html =~ s/\$STATUS_MSG/$status_msg/;
    } else {
        $send_newsletter_interface_show_newsletter_archive_html =~ s/\$STATUS_MSG//;
    }

    print "Content-type: text/html\n\n";
    print $send_newsletter_interface_show_newsletter_archive_html;
    exit (0);
}


sub send_newsletter_interface_newsletter_archive_perform_action {
    unless ( &valid_session ($user_submit) ) {
        &send_newsletter_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_session ($user_submit);
    }

    unless ($user_view_newsletter_archive_active || $user_download_newsletter_archive_active) {
        &send_newsletter_interface_show_newsletter_archive ('Please select an action.');
    }

    if ($newsletter_archive_logfile_submit eq $send_newsletter_interface_select_newsletter_archive_msg) {
        &send_newsletter_interface_show_newsletter_archive ('Please select an existing newsletter.');
    }

    my ($user, $current_subscribers, $newsletter_sent, $subject, $message);

    unless ($newsletter_archive_dir =~ /\/$/) { $newsletter_archive_dir .= '/' }

    if ($user_view_newsletter_archive_active) {
        my $send_newsletter_interface_view_sent_newsletter_html = &parse_template ($send_newsletter_interface_view_newsletter_archive_template);

        open (NEWSLETTER_ARCHIVE, "<$newsletter_archive_dir$newsletter_archive_logfile_submit") or die "Could not open $newsletter_archive_dir$newsletter_archive_logfile_submit: $!\n";
        $user = <NEWSLETTER_ARCHIVE>;
        $current_subscribers = <NEWSLETTER_ARCHIVE>;
        $newsletter_sent = <NEWSLETTER_ARCHIVE>;
        $subject = <NEWSLETTER_ARCHIVE>;
        while ( ! eof (NEWSLETTER_ARCHIVE) ) {
            $message .= <NEWSLETTER_ARCHIVE>;
        }
        close (NEWSLETTER_ARCHIVE) or die "Could not close $newsletter_archive_dir$newsletter_archive_logfile_submit: $!\n";

        $user =~ s/.*?\: (.*)/$1/;
        $current_subscribers =~ s/.*?\: (.*)/$1/;
        $newsletter_sent =~ s/.*?\: (.*)/$1/;
        $subject =~ s/.*?\: (.*)/$1/;
        $message =~ s/.*?\:(.*)/$1/;

        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;
        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$USER_SUBMIT_INVISIBLE/$user_submit/g;
        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$SESSIONID_INVISIBLE/$sessionid/g;

        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$USER/$user/;
        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$CURRENT_SUBSCRIBERS/$current_subscribers/;
        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$NEWSLETTER_SENT/$newsletter_sent/;
        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$SUBJECT/$subject/;
        $send_newsletter_interface_view_sent_newsletter_html =~ s/\$MESSAGE/$message/;

        print "Content-type: text/html\n\n";
        print $send_newsletter_interface_view_sent_newsletter_html;
        exit (0);
    }

    if ($user_download_newsletter_archive_active) {
        open (NEWSLETTER_ARCHIVE, "<$newsletter_archive_dir$newsletter_archive_logfile_submit") or die "Could not open $newsletter_archive_dir$newsletter_archive_logfile_submit: $!\n";
        my @newsletter_archive_content = <NEWSLETTER_ARCHIVE>;
        close (NEWSLETTER_ARCHIVE) or die "Could not close $newsletter_archive_dir$newsletter_archive_logfile_submit: $!\n";

        for (my $i = 0; $i < @newsletter_archive_content; $i++) {
            $newsletter_archive_content[$i] =~ s/\n/\r\n/g;
        }

        print "Content-Transfer-Encoding: application/octet-stream\n";
        print "Content-disposition: attachment; filename=\"$newsletter_archive_logfile_submit\"\n\n";

        print @newsletter_archive_content;
    }
}



# Parse the admin FAQ HTML & return its HTML
sub send_newsletter_user_faq {
    my $send_newsletter_user_faq_html = &parse_template ($send_newsletter_user_faq_template);

    print "Content-type: text/html\n\n";
    print $send_newsletter_user_faq_html;
    exit (0);
}


# Log the user out & redirect to the send newsletter interface login
sub send_newsletter_interface_logout_user {
    unless ( &valid_session ($user_submit) ) {
        &send_newsletter_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &send_newsletter_interface_logout();
        &send_newsletter_interface_login ($send_newsletter_interface_logout_successful_msg);
    }
}


# Delete the current user session
sub send_newsletter_interface_logout {
    open (USER_SESSION, ">$data_dir$user_session_file") or die "Could not open $data_dir$user_session_file: $!\n";
    close (USER_SESSION) or die "Could not close $data_dir$user_session_file: $!\n";
}


# Attempt to set the unactivated subscriber's mode active & print a specific message
sub confirm_subscription {
    open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    my @subscribers = <SUBSCRIBERS>;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    for ($i = 0; $i < @subscribers; $i++) {
        ($mail_subscriber, $name_subscriber, $signed_up_subscriber, $timestamp_saved, $id_saved, $mode) = split (/\:/, $subscribers[$i]);
        if ($id == $id_saved) {
            if ($mode == 1) {
                $id_recognised_mode_on = 1;
            } else {
                $id_recognised = 1;
            }

            $subscribers[$i] = "$mail_subscriber:$name_subscriber:$signed_up_subscriber:$timestamp_saved:$id_saved:1\n";
            goto BREAK;
        }
    }

    BREAK:
    open (SUBSCRIBERS, ">$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    print SUBSCRIBERS @subscribers;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    my $confirm_subscription_html = &parse_template ($subscription_msg_template);
    my @subscription_activation_status_msg = &parse_subscription_status_msg ($subscription_activation_status_msg_file);

    if ($id_recognised_mode_on) {
        $subscription_activation_status_msg[1] =~ s/\$EMAIL/<a href="mailto:$mail_subscriber">$mail_subscriber<\/a>/i;
        $confirm_subscription_html =~ s/\$SUBSCRIPTION_STATUS/$subscription_activation_status_msg[1]/i;
    } elsif ($id_recognised) {
        $subscription_activation_status_msg[0] =~ s/\$EMAIL/<a href="mailto:$mail_subscriber">$mail_subscriber<\/a>/i;
        $confirm_subscription_html =~ s/\$SUBSCRIPTION_STATUS/$subscription_activation_status_msg[0]/i;
    } else {
        $confirm_subscription_html =~ s/\$SUBSCRIPTION_STATUS/$subscription_activation_status_msg[2]/i;
    }

    print "Content-type: text/html\n\n";
    print $confirm_subscription_html;
    exit (0);
}


# Remove the subscriber from the subscriber file (launched by clicking the remove subscription link within mail)
sub remove_subscription {
    my $remove_subscription_successful;

    open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    my @subscribers = <SUBSCRIBERS>;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    for (my $i = 0; $i < @subscribers; $i++) {
        ($mail_subscriber, $name_subscriber, $signed_up_subscriber, $timestamp_saved, $id_saved, $mode) = split (/:/, $subscribers[$i]);
        if ($id == $id_saved) {
            splice (@subscribers, $i, 1);
            $removed_subscription_successful = 1;
            goto BREAK;

        }
    }

    BREAK:
    open (SUBSCRIBERS, ">$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
    print SUBSCRIBERS @subscribers;
    close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

    my $remove_subscription_html = &parse_template ($subscription_msg_template);
    my @subscription_removal_status_msg = &parse_subscription_status_msg ($subscription_removal_status_msg_file);

    if ($removed_subscription_successful) {
        $subscription_removal_status_msg[0] =~ s/\$EMAIL/<a href="mailto:$mail_subscriber">$mail_subscriber<\/a>/;
        $remove_subscription_html =~ s/\$SUBSCRIPTION_STATUS/$subscription_removal_status_msg[0]/;
    } else {
        $remove_subscription_html =~ s/\$SUBSCRIPTION_STATUS/$subscription_removal_status_msg[1]/;
    }

    print "Content-type: text/html\n\n";
    print $remove_subscription_html;
    exit (0);
}


# Parse separated mail msg file & extract several messages into variables
sub parse_newsletter_mail_msg {
    my $file = shift (@_);
    my $crap;

    open (FILE, "<$template_dir/$file") or die "Could not open $template_dir/$file: $!\n";

    for ($i = 0; $i < 21; $i++) {
        $crap = <FILE>;
    }
    while (my $line = <FILE>) {
        if ($line !~ /\#/) {
            $mail_msg_part_1 .= $line;
        } else {
            goto BREAK_1;
        }
    }
    BREAK_1:

    for ($i = 0; $i < 11; $i++) {
        $crap = <FILE>;
    }
    while (my $line = <FILE>) {
        if ($line !~ /\#/) {
            $mail_msg_part_2 .= $line;
        } else {
            goto BREAK_2;
        }
    }
    BREAK_2:

    close (FILE) or die "Could not close $template_dir/$file: $!\n";
}


# Parse the subscription activation msg file & extract several messages into variables
sub parse_subscription_status_msg {
    my $file = shift (@_);
    my $crap;

    open (FILE, "<$template_dir/$file") or die "Could not open $template_dir/$subscription_activation_msg_file: $!\n";

    for ($i = 0; $i < 18; $i++) {
        $crap = <FILE>;
    }
    while (my $line = <FILE>) {
        if ($line !~ /\#/) {
            $subscription_status_msg[0] .= $line;
        } else {
            goto BREAK_3;
        }
    }
    BREAK_3:

    for ($i = 0; $i < 11; $i++) {
        $crap = <FILE>;
    }
    while (my $line = <FILE>) {
        if ($line !~ /\#/) {
            $subscription_status_msg[1] .= $line;
        } else {
             goto BREAK_4;
        }
    }
    BREAK_4:

    for ($i = 0; $i <  11; $i++) {
        $crap = <FILE>;
    }
    while (my $line = <FILE>) {
        if ($line !~ /\#/) {
            $subscription_status_msg[2] .= $line;
        } else {
            goto BREAK_5;
        }
    }
    BREAK_5:

    close (FILE) or die "Could not close $template_dir/$subscription_activation_msg_file: $!\n";

    return @subscription_status_msg;
}


# Parse the newsletter signature file & extract the signature into a variable
sub parse_newsletter_signature {
    my $crap, $newsletter_signature;

    open (FILE, "<$template_dir/$newsletter_mail_signature_file") or die "Could not open $template_dir/$newsletter_mail_signature_file: $!\n";
    for ($i = 0; $i < 19; $i++) {
        $crap = <FILE>;
    }
    while (my $line = <FILE>) {
        if ($line !~ /\#/) {
            $newsletter_signature .= $line;
        } else {
            goto BREAK;
        }
    }
    BREAK:

    close (FILE) or die "Could not close $template_dir/$newsletter_mail_signature_file: $!\n";

    return $newsletter_signature;
}


# Parse an HTML template (filename has to be submitted by function launch)
sub parse_template {
    my $template = shift (@_);

    open (TEMPLATE, "<$template_dir/$template") or die "Could not open <$template_dir/$template: $!\n";
    while (! eof(TEMPLATE) ) {
        $template_html .= <TEMPLATE>;
    }
    close (TEMPLATE) or die "Could not close <$template_dir/$template: $!\n";

    return $template_html;
}


# Drop all unactivated subscribers that have been yet long enough subscribed, but did not activate
# their subscription manually by mail.
sub drop_unactivated_addresses {
    if ($drop_unactivated_addresses_active) {
        open (SUBSCRIBERS, "<$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
        my @subscribers = <SUBSCRIBERS>;
        close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";

        my $timestamp_current = time;

        for ($i = 0; $i <= @subscribers; $i++) {
            my ($mail_subscriber, $name_subscriber, $signed_up_subscriber, $timestamp_saved, $id_saved, $mode) = split (/\:/, $subscribers[$i]);

                if ($mode == 0) {
                    my $secs_passed = $timestamp_current - $timestamp_saved;
                    my $mins_passed = int ($secs_passed / 60);
                    my $hours_passed = int ($mins_passed / 60);
                    my $days_passed = int ($hours_passed / 24);

                    if ($after_days_delete_unsubscribed <= $days_passed) {
                        splice (@subscribers, $i, 1);
                    }
               }
        }

        open (SUBSCRIBERS, ">$data_dir$subscriber_file") or die "Could not open $data_dir$subscriber_file: $!\n";
        print SUBSCRIBERS @subscribers;
        close (SUBSCRIBERS) or die "Could not close $data_dir$subscriber_file: $!\n";
    }
}


# Parse the admin login HTML & print the HTML
sub admin_interface_login {
    my $status_msg = shift (@_);

    my $admin_interface_login_html = &parse_template ($admin_interface_login_template);

    $admin_interface_login_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;

    if ( defined ($admin_user_submit) ) {
        $admin_interface_login_html =~ s/\$ADMIN_USER_SUBMIT_INVISIBLE/$admin_user_submit/;
    } else {
        $admin_interface_login_html =~ s/\$ADMIN_USER_SUBMIT_INVISIBLE//;
    }

    if ( defined ($status_msg) ) {
        $admin_interface_login_html =~ s/\$STATUS_MSG/<br>$status_msg<br><br>/;
    } else {
        $admin_interface_login_html =~ s/\$STATUS_MSG//;
    }

    print "Content-Type: text/html\n\n";
    print $admin_interface_login_html;
    exit (0);
}



# Check whether the submitted password is equal to the one specified within the configuration file;
# if so, create admin session & drop unactivated subscribers that have been within the file for some time.
sub check_admin_interface_login {
    my $admin_interface_access_allowed = 1;

    unless ($admin_user_submit eq $admin_user) {
        $admin_interface_access_allowed = 0;
    } else {
        if (length ($admin_password_submit) != length ($admin_password) ) {
            $admin_interface_access_allowed = 0;
        }

        my @admin_password_submit = split (//, $admin_password_submit);
        my @admin_password = split (//, $admin_password);

        for (my $i = 0; $i < @admin_password; $i++) {
            if ($admin_password[$i] =~ /[1-9]/) {
                unless ($admin_password_submit[$i] == $admin_password[$i]) {
                    $admin_interface_access_allowed = 0;
                }
            } else {
                unless ($admin_password_submit[$i] eq $admin_password[$i]) {
                    $admin_interface_access_allowed = 0;
                }
            }
        }
    }

    if ($admin_interface_access_allowed == 1) {
        &create_admin_session();
        &drop_unactivated_addresses();
        &print_admin_interface();
    } else {
         &admin_interface_login ($admin_interface_access_denied_msg);
    }
}


# Create the admin session
sub create_admin_session {
    $admin_sessionid = int ( rand ($random_digit) * rand ($random_digit) + 1);

    open (ADMIN_SESSION, ">$data_dir$admin_session_file") or die "Could not open $data_dir$admin_session_file: $!\n";
    print ADMIN_SESSION "$admin_sessionid:" . time . "\n";
    close (ADMIN_SESSION) or die "Could not close $data_dir$admin_session_file: $!\n";
}


# Check the admin session for its validity (sessionid & timestamp)
sub valid_admin_session {
    open (ADMIN_SESSION, "<$data_dir$admin_session_file") or die "Could not open $data_dir$admin_session_file: $!\n";
    my $admin_session = <ADMIN_SESSION>;
    close (ADMIN_SESSION) or die "Could not close $data_dir$admin_session_file: $!\n";

    my ($admin_sessionid_saved, $admin_timestamp) = split (/\:/, $admin_session);
    my $timestamp_current = time;
    my $waiting_mins = int ( ($timestamp_current - $admin_timestamp) / 60);

    if ($admin_user_submit eq $admin_user && $admin_sessionid == $admin_sessionid_saved && $waiting_mins < $admin_time_out) {
        return 1;
    } else {
        return 0;
    }
}


# Renew the admin session (timestamp)
sub renew_admin_session {
    my $current_timestamp = time;

    open (ADMIN_SESSION, "<$data_dir$admin_session_file") or die "Could not open $data_dir$admin_session_file: $!\n";
    my $admin_session = <ADMIN_SESSION>;
    close (ADMIN_SESSION) or die "Could not close $data_dir$admin_session_file: $!\n";

    my ($admin_sessionid, $admin_timestamp) = split (/\:/, $admin_session);

    open (ADMIN_SESSION, ">$data_dir$admin_session_file") or die "Could not open $data_dir$admin_session_file: $!\n";
    print ADMIN_SESSION "$admin_sessionid:$current_timestamp\n";
    close (ADMIN_SESSION) or die "Could not close $data_dir$admin_session_file: $!\n";
}


# Logout from the admin interface & delete the current admin session
sub admin_interface_logout {
    open (ADMIN_SESSION, ">$data_dir$admin_session_file") or die "Could not open $data_dir$admin_session_file: $!\n";
    close (ADMIN_SESSION) or die "Could not close $data_dir$admin_session_file: $!\n";

    &admin_interface_login ($admin_interface_logout_successful_msg);
}


# Parse the newsform HTML & output the HTML
sub print_admin_interface {
    unless ( &valid_admin_session() ) {
        &admin_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_admin_session();
    }

    my $status_msg = shift (@_);
    my @sendnews_users_html;

    my $admin_interface_main_html = &parse_template ($admin_interface_main_template);

    $admin_interface_main_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;
    $admin_interface_main_html =~ s/\$ADMIN_USER_SUBMIT_INVISIBLE/$admin_user/g;
    $admin_interface_main_html =~ s/\$ADMIN_SESSIONID_INVISIBLE/$admin_sessionid/g;

    if ( defined ($status_msg) ) {
        $admin_interface_main_html =~ s/\$STATUS_MSG/<br>$status_msg<br><br>/;
    } else {
        $admin_interface_main_html =~ s/\$STATUS_MSG//;
    }

    open (SENDNEWS_USERS_AUTH, "<$data_dir$sendnews_users_auth_file") or die "Could not open $data_dir$sendnews_users_auth_file: $!\n";
    my @sendnews_users = <SENDNEWS_USERS_AUTH>;
    close (SENDNEWS_USERS_AUTH) or die "Could not close $data_dir$sendnews_users_auth_file: $!\n";

    push (@sendnews_users_html, "<option value=\"$admin_interface_select_user_msg\">$admin_interface_select_user_msg</option>\n");

    foreach my $user (@sendnews_users) {
        my ($user_access) = split (/\:/, $user);

        push (@sendnews_users_html, "<option value=\"$user_access\">$user_access</option>\n");
    }

    $admin_interface_main_html =~ s/\$SENDNEWS_USERS/@sendnews_users_html/i;

    print "Content-Type: text/html\n\n";
    print $admin_interface_main_html;
    exit (0);
}


# Decide which action shall be launched
sub admin_user_changes {
    unless ( &valid_admin_session() ) {
        &admin_interface_login ($admin_interface_session_dead_msg);
    } else {
        &renew_admin_session();
    }

    if ($user_submit eq $admin_interface_select_user_msg && $admin_create_new_user_active == 0) {
        &print_admin_interface ($admin_interface_select_existing_user_msg);
    }

    if ($admin_delete_user_active == 1) {
        &admin_perform_user_changes();
    } elsif ($admin_change_user_settings_active == 1) {
        &admin_change_user_settings();
    } elsif ($admin_create_new_user_active == 1) {
        &admin_create_new_user();
    }

    &print_admin_interface ($admin_interface_no_option_selected_msg);
}


# Parse the admin change user settings template & print the HTML
sub admin_change_user_settings {
    my @status_msg = shift (@_);

    my $admin_change_user_settings_html = &parse_template ($admin_change_user_settings_template);

    $admin_change_user_settings_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;
    $admin_change_user_settings_html =~ s/\$ADMIN_USER_SUBMIT_INVISIBLE/$admin_user_submit/g;
    $admin_change_user_settings_html =~ s/\$ADMIN_SESSIONID_INVISIBLE/$admin_sessionid/g;

    $admin_change_user_settings_html =~ s/\$USER_SUBMIT_INVISIBLE/$user_submit/g;
    $admin_change_user_settings_html =~ s/\$USER_SUBMIT/$user_submit/;

    open (SENDNEWS_USERS_AUTH, "<$data_dir$sendnews_users_auth_file") or die "Could not open $data_dir$sendnews_users_auth_file: $!\n";
    my @sendnews_users = <SENDNEWS_USERS_AUTH>;
    close (SENDNEWS_USERS_AUTH) or die "Could not close $data_dir$sendnews_users_auth_file: $!\n";

    foreach my $user (@sendnews_users) {
        ($user_saved, $user_password_saved, $user_email_saved, $user_time_out) = split (/\:/, $user);

        if ($user_submit eq $user_saved) { last }
    }

    $admin_change_user_settings_html =~ s/\$USER_EMAIL/$user_email_saved/;
    $admin_change_user_settings_html =~ s/\$USER_TIME_OUT/$user_time_out/;

    if ( defined(@status_msg) ) {
        $admin_change_user_settings_html =~ s/\$STATUS_MSG/@status_msg/;
    } else {
        $admin_change_user_settings_html =~ s/\$STATUS_MSG//;
    }

    print "Content-type: text/html\n\n";
    print $admin_change_user_settings_html;
    exit (0);
}


# Parse the admin create new user template & print the HTML
sub admin_create_new_user {
    my @status_msg = @_;

    foreach my $error (@status_msg) {
        push (@status_msg_new, $error . '<br>');
    }
    @status_msg = @status_msg_new;

    my $admin_create_new_user_html = &parse_template ($admin_create_new_user_template);

    $admin_create_new_user_html =~ s/\$SCRIPT_URL_INVISIBLE/$script_url/g;
    $admin_create_new_user_html =~ s/\$ADMIN_USER_SUBMIT_INVISIBLE/$admin_user/g;
    $admin_create_new_user_html =~ s/\$ADMIN_SESSIONID_INVISIBLE/$admin_sessionid/g;

    if ( defined (@status_msg) ) {
        $admin_create_new_user_html =~ s/\$STATUS_MSG/@status_msg/;
    } else {
        $admin_create_new_user_html =~ s/\$STATUS_MSG//;
    }

    print "Content-type: text/html\n\n";
    print $admin_create_new_user_html;
    exit (0);
}


# Either delete / change / create new user
sub admin_perform_user_changes {
    unless ( &valid_admin_session() ) {
        &admin_interface_login ($send_newsletter_interface_session_dead_msg);
    } else {
        &renew_admin_session();
    }

    my $admin_change_user_settings_successful, $admin_delete_user_successful;

    open (SENDNEWS_USERS_AUTH, "<$data_dir$sendnews_users_auth_file") or die "Could not open $data_dir$sendnews_users_auth_file: $!\n";
    my @sendnews_users = <SENDNEWS_USERS_AUTH>;
    close (SENDNEWS_USERS_AUTH) or die "Could not close $data_dir$sendnews_users_auth_file: $!\n";

    if ($admin_delete_user_active) {
        for ($i = 0; $i < scalar @sendnews_users; $i++) {
            my ($user_saved) = split (/\:/, $sendnews_users[$i]);

            if ($user_submit eq $user_saved) {
                splice (@sendnews_users, $i, 1);
                $admin_delete_user_successful = 1;
                last;
            }
        }
    }

    if ($admin_change_user_settings_active) {
        my @error;

        if ($admin_change_user_password_active) {
            if (length ($password_submit) < $mind_user_password_length) {
                push (@error, $admin_change_user_settings_password_length_too_short_msg);
            }
            unless ($password_submit eq $password_submit_2 || $password_submit == $password_submit_2) {
                push (@error, $admin_change_user_settings_passwords_not_equal_msg);
            }
        }

        unless ($email_submit =~ /\w+\@\w+\.\w{2,}/) {
            push (@error, $admin_change_user_settings_email_not_valid_msg);
        }

        if ($time_out_submit !~ /[0-9]/ || $time_out_submit < 1 || $time_out_submit > 60) {
            push (@error, $admin_change_user_settings_time_out_not_valid_msg);
        }

        if ( defined (@error) ) {
            &admin_change_user_settings (@error);
        }

        for ($i = 0; $i < scalar @sendnews_users; $i++) {
            my ($user_saved, $password_saved, $email_saved, $time_out_saved) = split (/\:/, $sendnews_users[$i]);

            if ($user_submit eq $user_saved) {
                if ($admin_change_user_password_active) {
                    $sendnews_users[$i] = "$user_saved:$password_submit:$email_submit:$time_out_submit";
                } else {
                    $sendnews_users[$i] = "$user_saved:$password_saved:$email_submit:$time_out_submit";
                }
                $admin_change_user_settings_successful = 1;
                last;
            }
       }
   }

   if ($admin_create_new_user_active) {
       unless ($user_submit =~ /[a-z]/i) {
           push (@error, $admin_create_new_user_no_user_name_msg);
       }

       if (length ($password_submit) < $mind_user_password_length) {
           push (@error, $admin_change_user_settings_password_length_too_short_msg);
       }
       unless ($password_submit eq $password_submit_2 || $password_submit == $password_submit_2) {
           push (@error, $admin_change_user_settings_passwords_not_equal_msg);
       }

       unless ($email_submit =~ /\w+\@\w+\.\w{2,}/) {
           push (@error, $admin_change_user_settings_email_not_valid_msg);
       }

       if ($time_out_submit !~ /[0-9]/ || $time_out_submit < 1 || $time_out_submit > 60) {
           push (@error, $admin_change_user_settings_time_out_not_valid_msg);
       }

       if (defined( @error )) {
           &admin_create_new_user (@error);
       }

       open (SENDNEWS_USERS_AUTH, "<$data_dir$sendnews_users_auth_file") or die "Could not open $data_dir$sendnews_users_auth_file: $!\n";
       @sendnews_users = <SENDNEWS_USERS_AUTH>;
       close (SENDNEWS_USERS_AUTH) or die "Could not close $data_dir$sendnews_users_auth_file: $!\n";
       unshift (@sendnews_users, "$user_submit:$password_submit:$email_submit:$time_out_submit\n");

       $admin_create_new_user_successful = 1;
   }


   if ($admin_change_user_settings_successful == 1 || $admin_delete_user_successful == 1 || $admin_create_new_user_successful == 1) {
       open (SENDNEWS_USERS_AUTH, ">$data_dir$sendnews_users_auth_file") or die "Could not open $data_dir$sendnews_users_auth_file: $!\n";
       print SENDNEWS_USERS_AUTH @sendnews_users;
       close (SENDNEWS_USERS_AUTH) or die "Could not close $data_dir$sendnews_users_auth_file: $!\n";

       if ($admin_change_user_settings_successful == 1) {
           $status_msg = $admin_change_user_settings_successful_msg;
       } elsif ($admin_delete_user_successful == 1) {
           $status_msg = $admin_delete_user_successful_msg;
       } elsif ($admin_create_new_user_successful == 1) {
           $status_msg = $admin_create_new_user_successful_msg;
       }

       &print_admin_interface ($status_msg);
   }
}