package Date::Manip::TZ::euwars00;
# Copyright (c) 2008-2010 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Tue Oct 12 10:30:29 EDT 2010
#    Data version: tzdata2010m
#    Code version: tzcode2010m

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://elsie.nci.nih.gov/pub

=pod

=head1 NAME

Date::Manip::TZ::euwars00 - Support for the Europe/Warsaw time zone

=head1 SYNPOSIS

This module contains data from the Olsen database for the time zone. It
is not intended to be used directly (other Date::Manip modules will
load it as needed).

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.13';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,2,1,24,0],'+01:24:00',[1,24,0],
          'LMT',0,[1879,12,31,22,35,59],[1879,12,31,23,59,59],
          '0001010200:00:00','0001010201:24:00','1879123122:35:59','1879123123:59:59' ],
     ],
   1879 =>
     [
        [ [1879,12,31,22,36,0],[1880,1,1,0,0,0],'+01:24:00',[1,24,0],
          'WMT',0,[1915,8,4,22,35,59],[1915,8,4,23,59,59],
          '1879123122:36:00','1880010100:00:00','1915080422:35:59','1915080423:59:59' ],
     ],
   1915 =>
     [
        [ [1915,8,4,22,36,0],[1915,8,4,23,36,0],'+01:00:00',[1,0,0],
          'CET',0,[1916,4,30,21,59,59],[1916,4,30,22,59,59],
          '1915080422:36:00','1915080423:36:00','1916043021:59:59','1916043022:59:59' ],
     ],
   1916 =>
     [
        [ [1916,4,30,22,0,0],[1916,5,1,0,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1916,9,30,22,59,59],[1916,10,1,0,59,59],
          '1916043022:00:00','1916050100:00:00','1916093022:59:59','1916100100:59:59' ],
        [ [1916,9,30,23,0,0],[1916,10,1,0,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1917,4,16,0,59,59],[1917,4,16,1,59,59],
          '1916093023:00:00','1916100100:00:00','1917041600:59:59','1917041601:59:59' ],
     ],
   1917 =>
     [
        [ [1917,4,16,1,0,0],[1917,4,16,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1917,9,17,0,59,59],[1917,9,17,2,59,59],
          '1917041601:00:00','1917041603:00:00','1917091700:59:59','1917091702:59:59' ],
        [ [1917,9,17,1,0,0],[1917,9,17,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1918,4,15,0,59,59],[1918,4,15,1,59,59],
          '1917091701:00:00','1917091702:00:00','1918041500:59:59','1918041501:59:59' ],
     ],
   1918 =>
     [
        [ [1918,4,15,1,0,0],[1918,4,15,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1918,9,16,0,59,59],[1918,9,16,2,59,59],
          '1918041501:00:00','1918041503:00:00','1918091600:59:59','1918091602:59:59' ],
        [ [1918,9,16,1,0,0],[1918,9,16,3,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1919,4,14,23,59,59],[1919,4,15,1,59,59],
          '1918091601:00:00','1918091603:00:00','1919041423:59:59','1919041501:59:59' ],
     ],
   1919 =>
     [
        [ [1919,4,15,0,0,0],[1919,4,15,3,0,0],'+03:00:00',[3,0,0],
          'EEST',1,[1919,9,15,23,59,59],[1919,9,16,2,59,59],
          '1919041500:00:00','1919041503:00:00','1919091523:59:59','1919091602:59:59' ],
        [ [1919,9,16,0,0,0],[1919,9,16,2,0,0],'+02:00:00',[2,0,0],
          'EET',0,[1922,5,31,21,59,59],[1922,5,31,23,59,59],
          '1919091600:00:00','1919091602:00:00','1922053121:59:59','1922053123:59:59' ],
     ],
   1922 =>
     [
        [ [1922,5,31,22,0,0],[1922,5,31,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1940,6,23,0,59,59],[1940,6,23,1,59,59],
          '1922053122:00:00','1922053123:00:00','1940062300:59:59','1940062301:59:59' ],
     ],
   1940 =>
     [
        [ [1940,6,23,1,0,0],[1940,6,23,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1942,11,2,0,59,59],[1942,11,2,2,59,59],
          '1940062301:00:00','1940062303:00:00','1942110200:59:59','1942110202:59:59' ],
     ],
   1942 =>
     [
        [ [1942,11,2,1,0,0],[1942,11,2,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1943,3,29,0,59,59],[1943,3,29,1,59,59],
          '1942110201:00:00','1942110202:00:00','1943032900:59:59','1943032901:59:59' ],
     ],
   1943 =>
     [
        [ [1943,3,29,1,0,0],[1943,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1943,10,4,0,59,59],[1943,10,4,2,59,59],
          '1943032901:00:00','1943032903:00:00','1943100400:59:59','1943100402:59:59' ],
        [ [1943,10,4,1,0,0],[1943,10,4,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1944,4,3,0,59,59],[1944,4,3,1,59,59],
          '1943100401:00:00','1943100402:00:00','1944040300:59:59','1944040301:59:59' ],
     ],
   1944 =>
     [
        [ [1944,4,3,1,0,0],[1944,4,3,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1944,10,3,23,59,59],[1944,10,4,1,59,59],
          '1944040301:00:00','1944040303:00:00','1944100323:59:59','1944100401:59:59' ],
        [ [1944,10,4,0,0,0],[1944,10,4,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1945,4,28,22,59,59],[1945,4,28,23,59,59],
          '1944100400:00:00','1944100401:00:00','1945042822:59:59','1945042823:59:59' ],
     ],
   1945 =>
     [
        [ [1945,4,28,23,0,0],[1945,4,29,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1945,10,31,21,59,59],[1945,10,31,23,59,59],
          '1945042823:00:00','1945042901:00:00','1945103121:59:59','1945103123:59:59' ],
        [ [1945,10,31,22,0,0],[1945,10,31,23,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1946,4,13,22,59,59],[1946,4,13,23,59,59],
          '1945103122:00:00','1945103123:00:00','1946041322:59:59','1946041323:59:59' ],
     ],
   1946 =>
     [
        [ [1946,4,13,23,0,0],[1946,4,14,1,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1946,10,7,0,59,59],[1946,10,7,2,59,59],
          '1946041323:00:00','1946041401:00:00','1946100700:59:59','1946100702:59:59' ],
        [ [1946,10,7,1,0,0],[1946,10,7,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1947,5,4,0,59,59],[1947,5,4,1,59,59],
          '1946100701:00:00','1946100702:00:00','1947050400:59:59','1947050401:59:59' ],
     ],
   1947 =>
     [
        [ [1947,5,4,1,0,0],[1947,5,4,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1947,10,5,0,59,59],[1947,10,5,2,59,59],
          '1947050401:00:00','1947050403:00:00','1947100500:59:59','1947100502:59:59' ],
        [ [1947,10,5,1,0,0],[1947,10,5,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1948,4,18,0,59,59],[1948,4,18,1,59,59],
          '1947100501:00:00','1947100502:00:00','1948041800:59:59','1948041801:59:59' ],
     ],
   1948 =>
     [
        [ [1948,4,18,1,0,0],[1948,4,18,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1948,10,3,0,59,59],[1948,10,3,2,59,59],
          '1948041801:00:00','1948041803:00:00','1948100300:59:59','1948100302:59:59' ],
        [ [1948,10,3,1,0,0],[1948,10,3,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1949,4,10,0,59,59],[1949,4,10,1,59,59],
          '1948100301:00:00','1948100302:00:00','1949041000:59:59','1949041001:59:59' ],
     ],
   1949 =>
     [
        [ [1949,4,10,1,0,0],[1949,4,10,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1949,10,2,0,59,59],[1949,10,2,2,59,59],
          '1949041001:00:00','1949041003:00:00','1949100200:59:59','1949100202:59:59' ],
        [ [1949,10,2,1,0,0],[1949,10,2,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1957,6,1,23,59,59],[1957,6,2,0,59,59],
          '1949100201:00:00','1949100202:00:00','1957060123:59:59','1957060200:59:59' ],
     ],
   1957 =>
     [
        [ [1957,6,2,0,0,0],[1957,6,2,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1957,9,28,23,59,59],[1957,9,29,1,59,59],
          '1957060200:00:00','1957060202:00:00','1957092823:59:59','1957092901:59:59' ],
        [ [1957,9,29,0,0,0],[1957,9,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1958,3,29,23,59,59],[1958,3,30,0,59,59],
          '1957092900:00:00','1957092901:00:00','1958032923:59:59','1958033000:59:59' ],
     ],
   1958 =>
     [
        [ [1958,3,30,0,0,0],[1958,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1958,9,27,23,59,59],[1958,9,28,1,59,59],
          '1958033000:00:00','1958033002:00:00','1958092723:59:59','1958092801:59:59' ],
        [ [1958,9,28,0,0,0],[1958,9,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1959,5,30,23,59,59],[1959,5,31,0,59,59],
          '1958092800:00:00','1958092801:00:00','1959053023:59:59','1959053100:59:59' ],
     ],
   1959 =>
     [
        [ [1959,5,31,0,0,0],[1959,5,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1959,10,3,23,59,59],[1959,10,4,1,59,59],
          '1959053100:00:00','1959053102:00:00','1959100323:59:59','1959100401:59:59' ],
        [ [1959,10,4,0,0,0],[1959,10,4,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1960,4,2,23,59,59],[1960,4,3,0,59,59],
          '1959100400:00:00','1959100401:00:00','1960040223:59:59','1960040300:59:59' ],
     ],
   1960 =>
     [
        [ [1960,4,3,0,0,0],[1960,4,3,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1960,10,1,23,59,59],[1960,10,2,1,59,59],
          '1960040300:00:00','1960040302:00:00','1960100123:59:59','1960100201:59:59' ],
        [ [1960,10,2,0,0,0],[1960,10,2,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1961,5,27,23,59,59],[1961,5,28,0,59,59],
          '1960100200:00:00','1960100201:00:00','1961052723:59:59','1961052800:59:59' ],
     ],
   1961 =>
     [
        [ [1961,5,28,0,0,0],[1961,5,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1961,9,30,23,59,59],[1961,10,1,1,59,59],
          '1961052800:00:00','1961052802:00:00','1961093023:59:59','1961100101:59:59' ],
        [ [1961,10,1,0,0,0],[1961,10,1,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1962,5,26,23,59,59],[1962,5,27,0,59,59],
          '1961100100:00:00','1961100101:00:00','1962052623:59:59','1962052700:59:59' ],
     ],
   1962 =>
     [
        [ [1962,5,27,0,0,0],[1962,5,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1962,9,29,23,59,59],[1962,9,30,1,59,59],
          '1962052700:00:00','1962052702:00:00','1962092923:59:59','1962093001:59:59' ],
        [ [1962,9,30,0,0,0],[1962,9,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1963,5,25,23,59,59],[1963,5,26,0,59,59],
          '1962093000:00:00','1962093001:00:00','1963052523:59:59','1963052600:59:59' ],
     ],
   1963 =>
     [
        [ [1963,5,26,0,0,0],[1963,5,26,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1963,9,28,23,59,59],[1963,9,29,1,59,59],
          '1963052600:00:00','1963052602:00:00','1963092823:59:59','1963092901:59:59' ],
        [ [1963,9,29,0,0,0],[1963,9,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1964,5,30,23,59,59],[1964,5,31,0,59,59],
          '1963092900:00:00','1963092901:00:00','1964053023:59:59','1964053100:59:59' ],
     ],
   1964 =>
     [
        [ [1964,5,31,0,0,0],[1964,5,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1964,9,26,23,59,59],[1964,9,27,1,59,59],
          '1964053100:00:00','1964053102:00:00','1964092623:59:59','1964092701:59:59' ],
        [ [1964,9,27,0,0,0],[1964,9,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1977,4,2,23,59,59],[1977,4,3,0,59,59],
          '1964092700:00:00','1964092701:00:00','1977040223:59:59','1977040300:59:59' ],
     ],
   1977 =>
     [
        [ [1977,4,3,0,0,0],[1977,4,3,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1977,9,24,23,59,59],[1977,9,25,1,59,59],
          '1977040300:00:00','1977040302:00:00','1977092423:59:59','1977092501:59:59' ],
        [ [1977,9,25,0,0,0],[1977,9,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1978,4,1,23,59,59],[1978,4,2,0,59,59],
          '1977092500:00:00','1977092501:00:00','1978040123:59:59','1978040200:59:59' ],
     ],
   1978 =>
     [
        [ [1978,4,2,0,0,0],[1978,4,2,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1978,9,30,23,59,59],[1978,10,1,1,59,59],
          '1978040200:00:00','1978040202:00:00','1978093023:59:59','1978100101:59:59' ],
        [ [1978,10,1,0,0,0],[1978,10,1,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1979,3,31,23,59,59],[1979,4,1,0,59,59],
          '1978100100:00:00','1978100101:00:00','1979033123:59:59','1979040100:59:59' ],
     ],
   1979 =>
     [
        [ [1979,4,1,0,0,0],[1979,4,1,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1979,9,29,23,59,59],[1979,9,30,1,59,59],
          '1979040100:00:00','1979040102:00:00','1979092923:59:59','1979093001:59:59' ],
        [ [1979,9,30,0,0,0],[1979,9,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1980,4,5,23,59,59],[1980,4,6,0,59,59],
          '1979093000:00:00','1979093001:00:00','1980040523:59:59','1980040600:59:59' ],
     ],
   1980 =>
     [
        [ [1980,4,6,0,0,0],[1980,4,6,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1980,9,27,23,59,59],[1980,9,28,1,59,59],
          '1980040600:00:00','1980040602:00:00','1980092723:59:59','1980092801:59:59' ],
        [ [1980,9,28,0,0,0],[1980,9,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1981,3,28,23,59,59],[1981,3,29,0,59,59],
          '1980092800:00:00','1980092801:00:00','1981032823:59:59','1981032900:59:59' ],
     ],
   1981 =>
     [
        [ [1981,3,29,0,0,0],[1981,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1981,9,26,23,59,59],[1981,9,27,1,59,59],
          '1981032900:00:00','1981032902:00:00','1981092623:59:59','1981092701:59:59' ],
        [ [1981,9,27,0,0,0],[1981,9,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1982,3,27,23,59,59],[1982,3,28,0,59,59],
          '1981092700:00:00','1981092701:00:00','1982032723:59:59','1982032800:59:59' ],
     ],
   1982 =>
     [
        [ [1982,3,28,0,0,0],[1982,3,28,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1982,9,25,23,59,59],[1982,9,26,1,59,59],
          '1982032800:00:00','1982032802:00:00','1982092523:59:59','1982092601:59:59' ],
        [ [1982,9,26,0,0,0],[1982,9,26,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1983,3,26,23,59,59],[1983,3,27,0,59,59],
          '1982092600:00:00','1982092601:00:00','1983032623:59:59','1983032700:59:59' ],
     ],
   1983 =>
     [
        [ [1983,3,27,0,0,0],[1983,3,27,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1983,9,24,23,59,59],[1983,9,25,1,59,59],
          '1983032700:00:00','1983032702:00:00','1983092423:59:59','1983092501:59:59' ],
        [ [1983,9,25,0,0,0],[1983,9,25,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1984,3,24,23,59,59],[1984,3,25,0,59,59],
          '1983092500:00:00','1983092501:00:00','1984032423:59:59','1984032500:59:59' ],
     ],
   1984 =>
     [
        [ [1984,3,25,0,0,0],[1984,3,25,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1984,9,29,23,59,59],[1984,9,30,1,59,59],
          '1984032500:00:00','1984032502:00:00','1984092923:59:59','1984093001:59:59' ],
        [ [1984,9,30,0,0,0],[1984,9,30,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1985,3,30,23,59,59],[1985,3,31,0,59,59],
          '1984093000:00:00','1984093001:00:00','1985033023:59:59','1985033100:59:59' ],
     ],
   1985 =>
     [
        [ [1985,3,31,0,0,0],[1985,3,31,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1985,9,28,23,59,59],[1985,9,29,1,59,59],
          '1985033100:00:00','1985033102:00:00','1985092823:59:59','1985092901:59:59' ],
        [ [1985,9,29,0,0,0],[1985,9,29,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1986,3,29,23,59,59],[1986,3,30,0,59,59],
          '1985092900:00:00','1985092901:00:00','1986032923:59:59','1986033000:59:59' ],
     ],
   1986 =>
     [
        [ [1986,3,30,0,0,0],[1986,3,30,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1986,9,27,23,59,59],[1986,9,28,1,59,59],
          '1986033000:00:00','1986033002:00:00','1986092723:59:59','1986092801:59:59' ],
        [ [1986,9,28,0,0,0],[1986,9,28,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1987,3,28,23,59,59],[1987,3,29,0,59,59],
          '1986092800:00:00','1986092801:00:00','1987032823:59:59','1987032900:59:59' ],
     ],
   1987 =>
     [
        [ [1987,3,29,0,0,0],[1987,3,29,2,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1987,9,26,23,59,59],[1987,9,27,1,59,59],
          '1987032900:00:00','1987032902:00:00','1987092623:59:59','1987092701:59:59' ],
        [ [1987,9,27,0,0,0],[1987,9,27,1,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1988,3,27,0,59,59],[1988,3,27,1,59,59],
          '1987092700:00:00','1987092701:00:00','1988032700:59:59','1988032701:59:59' ],
     ],
   1988 =>
     [
        [ [1988,3,27,1,0,0],[1988,3,27,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1988,9,25,0,59,59],[1988,9,25,2,59,59],
          '1988032701:00:00','1988032703:00:00','1988092500:59:59','1988092502:59:59' ],
        [ [1988,9,25,1,0,0],[1988,9,25,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1989,3,26,0,59,59],[1989,3,26,1,59,59],
          '1988092501:00:00','1988092502:00:00','1989032600:59:59','1989032601:59:59' ],
     ],
   1989 =>
     [
        [ [1989,3,26,1,0,0],[1989,3,26,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1989,9,24,0,59,59],[1989,9,24,2,59,59],
          '1989032601:00:00','1989032603:00:00','1989092400:59:59','1989092402:59:59' ],
        [ [1989,9,24,1,0,0],[1989,9,24,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1990,3,25,0,59,59],[1990,3,25,1,59,59],
          '1989092401:00:00','1989092402:00:00','1990032500:59:59','1990032501:59:59' ],
     ],
   1990 =>
     [
        [ [1990,3,25,1,0,0],[1990,3,25,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1990,9,30,0,59,59],[1990,9,30,2,59,59],
          '1990032501:00:00','1990032503:00:00','1990093000:59:59','1990093002:59:59' ],
        [ [1990,9,30,1,0,0],[1990,9,30,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1991,3,31,0,59,59],[1991,3,31,1,59,59],
          '1990093001:00:00','1990093002:00:00','1991033100:59:59','1991033101:59:59' ],
     ],
   1991 =>
     [
        [ [1991,3,31,1,0,0],[1991,3,31,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1991,9,29,0,59,59],[1991,9,29,2,59,59],
          '1991033101:00:00','1991033103:00:00','1991092900:59:59','1991092902:59:59' ],
        [ [1991,9,29,1,0,0],[1991,9,29,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1992,3,29,0,59,59],[1992,3,29,1,59,59],
          '1991092901:00:00','1991092902:00:00','1992032900:59:59','1992032901:59:59' ],
     ],
   1992 =>
     [
        [ [1992,3,29,1,0,0],[1992,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1992,9,27,0,59,59],[1992,9,27,2,59,59],
          '1992032901:00:00','1992032903:00:00','1992092700:59:59','1992092702:59:59' ],
        [ [1992,9,27,1,0,0],[1992,9,27,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1993,3,28,0,59,59],[1993,3,28,1,59,59],
          '1992092701:00:00','1992092702:00:00','1993032800:59:59','1993032801:59:59' ],
     ],
   1993 =>
     [
        [ [1993,3,28,1,0,0],[1993,3,28,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1993,9,26,0,59,59],[1993,9,26,2,59,59],
          '1993032801:00:00','1993032803:00:00','1993092600:59:59','1993092602:59:59' ],
        [ [1993,9,26,1,0,0],[1993,9,26,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1994,3,27,0,59,59],[1994,3,27,1,59,59],
          '1993092601:00:00','1993092602:00:00','1994032700:59:59','1994032701:59:59' ],
     ],
   1994 =>
     [
        [ [1994,3,27,1,0,0],[1994,3,27,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1994,9,25,0,59,59],[1994,9,25,2,59,59],
          '1994032701:00:00','1994032703:00:00','1994092500:59:59','1994092502:59:59' ],
        [ [1994,9,25,1,0,0],[1994,9,25,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1995,3,26,0,59,59],[1995,3,26,1,59,59],
          '1994092501:00:00','1994092502:00:00','1995032600:59:59','1995032601:59:59' ],
     ],
   1995 =>
     [
        [ [1995,3,26,1,0,0],[1995,3,26,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1995,9,24,0,59,59],[1995,9,24,2,59,59],
          '1995032601:00:00','1995032603:00:00','1995092400:59:59','1995092402:59:59' ],
        [ [1995,9,24,1,0,0],[1995,9,24,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1996,3,31,0,59,59],[1996,3,31,1,59,59],
          '1995092401:00:00','1995092402:00:00','1996033100:59:59','1996033101:59:59' ],
     ],
   1996 =>
     [
        [ [1996,3,31,1,0,0],[1996,3,31,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1996,10,27,0,59,59],[1996,10,27,2,59,59],
          '1996033101:00:00','1996033103:00:00','1996102700:59:59','1996102702:59:59' ],
        [ [1996,10,27,1,0,0],[1996,10,27,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1997,3,30,0,59,59],[1997,3,30,1,59,59],
          '1996102701:00:00','1996102702:00:00','1997033000:59:59','1997033001:59:59' ],
     ],
   1997 =>
     [
        [ [1997,3,30,1,0,0],[1997,3,30,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1997,10,26,0,59,59],[1997,10,26,2,59,59],
          '1997033001:00:00','1997033003:00:00','1997102600:59:59','1997102602:59:59' ],
        [ [1997,10,26,1,0,0],[1997,10,26,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1998,3,29,0,59,59],[1998,3,29,1,59,59],
          '1997102601:00:00','1997102602:00:00','1998032900:59:59','1998032901:59:59' ],
     ],
   1998 =>
     [
        [ [1998,3,29,1,0,0],[1998,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1998,10,25,0,59,59],[1998,10,25,2,59,59],
          '1998032901:00:00','1998032903:00:00','1998102500:59:59','1998102502:59:59' ],
        [ [1998,10,25,1,0,0],[1998,10,25,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[1999,3,28,0,59,59],[1999,3,28,1,59,59],
          '1998102501:00:00','1998102502:00:00','1999032800:59:59','1999032801:59:59' ],
     ],
   1999 =>
     [
        [ [1999,3,28,1,0,0],[1999,3,28,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[1999,10,31,0,59,59],[1999,10,31,2,59,59],
          '1999032801:00:00','1999032803:00:00','1999103100:59:59','1999103102:59:59' ],
        [ [1999,10,31,1,0,0],[1999,10,31,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2000,3,26,0,59,59],[2000,3,26,1,59,59],
          '1999103101:00:00','1999103102:00:00','2000032600:59:59','2000032601:59:59' ],
     ],
   2000 =>
     [
        [ [2000,3,26,1,0,0],[2000,3,26,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2000,10,29,0,59,59],[2000,10,29,2,59,59],
          '2000032601:00:00','2000032603:00:00','2000102900:59:59','2000102902:59:59' ],
        [ [2000,10,29,1,0,0],[2000,10,29,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2001,3,25,0,59,59],[2001,3,25,1,59,59],
          '2000102901:00:00','2000102902:00:00','2001032500:59:59','2001032501:59:59' ],
     ],
   2001 =>
     [
        [ [2001,3,25,1,0,0],[2001,3,25,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2001,10,28,0,59,59],[2001,10,28,2,59,59],
          '2001032501:00:00','2001032503:00:00','2001102800:59:59','2001102802:59:59' ],
        [ [2001,10,28,1,0,0],[2001,10,28,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2002,3,31,0,59,59],[2002,3,31,1,59,59],
          '2001102801:00:00','2001102802:00:00','2002033100:59:59','2002033101:59:59' ],
     ],
   2002 =>
     [
        [ [2002,3,31,1,0,0],[2002,3,31,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2002,10,27,0,59,59],[2002,10,27,2,59,59],
          '2002033101:00:00','2002033103:00:00','2002102700:59:59','2002102702:59:59' ],
        [ [2002,10,27,1,0,0],[2002,10,27,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2003,3,30,0,59,59],[2003,3,30,1,59,59],
          '2002102701:00:00','2002102702:00:00','2003033000:59:59','2003033001:59:59' ],
     ],
   2003 =>
     [
        [ [2003,3,30,1,0,0],[2003,3,30,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2003,10,26,0,59,59],[2003,10,26,2,59,59],
          '2003033001:00:00','2003033003:00:00','2003102600:59:59','2003102602:59:59' ],
        [ [2003,10,26,1,0,0],[2003,10,26,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2004,3,28,0,59,59],[2004,3,28,1,59,59],
          '2003102601:00:00','2003102602:00:00','2004032800:59:59','2004032801:59:59' ],
     ],
   2004 =>
     [
        [ [2004,3,28,1,0,0],[2004,3,28,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2004,10,31,0,59,59],[2004,10,31,2,59,59],
          '2004032801:00:00','2004032803:00:00','2004103100:59:59','2004103102:59:59' ],
        [ [2004,10,31,1,0,0],[2004,10,31,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2005,3,27,0,59,59],[2005,3,27,1,59,59],
          '2004103101:00:00','2004103102:00:00','2005032700:59:59','2005032701:59:59' ],
     ],
   2005 =>
     [
        [ [2005,3,27,1,0,0],[2005,3,27,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2005,10,30,0,59,59],[2005,10,30,2,59,59],
          '2005032701:00:00','2005032703:00:00','2005103000:59:59','2005103002:59:59' ],
        [ [2005,10,30,1,0,0],[2005,10,30,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2006,3,26,0,59,59],[2006,3,26,1,59,59],
          '2005103001:00:00','2005103002:00:00','2006032600:59:59','2006032601:59:59' ],
     ],
   2006 =>
     [
        [ [2006,3,26,1,0,0],[2006,3,26,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2006,10,29,0,59,59],[2006,10,29,2,59,59],
          '2006032601:00:00','2006032603:00:00','2006102900:59:59','2006102902:59:59' ],
        [ [2006,10,29,1,0,0],[2006,10,29,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2007,3,25,0,59,59],[2007,3,25,1,59,59],
          '2006102901:00:00','2006102902:00:00','2007032500:59:59','2007032501:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,25,1,0,0],[2007,3,25,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2007,10,28,0,59,59],[2007,10,28,2,59,59],
          '2007032501:00:00','2007032503:00:00','2007102800:59:59','2007102802:59:59' ],
        [ [2007,10,28,1,0,0],[2007,10,28,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2008,3,30,0,59,59],[2008,3,30,1,59,59],
          '2007102801:00:00','2007102802:00:00','2008033000:59:59','2008033001:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,30,1,0,0],[2008,3,30,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2008,10,26,0,59,59],[2008,10,26,2,59,59],
          '2008033001:00:00','2008033003:00:00','2008102600:59:59','2008102602:59:59' ],
        [ [2008,10,26,1,0,0],[2008,10,26,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2009,3,29,0,59,59],[2009,3,29,1,59,59],
          '2008102601:00:00','2008102602:00:00','2009032900:59:59','2009032901:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,29,1,0,0],[2009,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2009,10,25,0,59,59],[2009,10,25,2,59,59],
          '2009032901:00:00','2009032903:00:00','2009102500:59:59','2009102502:59:59' ],
        [ [2009,10,25,1,0,0],[2009,10,25,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2010,3,28,0,59,59],[2010,3,28,1,59,59],
          '2009102501:00:00','2009102502:00:00','2010032800:59:59','2010032801:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,28,1,0,0],[2010,3,28,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2010,10,31,0,59,59],[2010,10,31,2,59,59],
          '2010032801:00:00','2010032803:00:00','2010103100:59:59','2010103102:59:59' ],
        [ [2010,10,31,1,0,0],[2010,10,31,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2011,3,27,0,59,59],[2011,3,27,1,59,59],
          '2010103101:00:00','2010103102:00:00','2011032700:59:59','2011032701:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,27,1,0,0],[2011,3,27,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2011,10,30,0,59,59],[2011,10,30,2,59,59],
          '2011032701:00:00','2011032703:00:00','2011103000:59:59','2011103002:59:59' ],
        [ [2011,10,30,1,0,0],[2011,10,30,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2012,3,25,0,59,59],[2012,3,25,1,59,59],
          '2011103001:00:00','2011103002:00:00','2012032500:59:59','2012032501:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,25,1,0,0],[2012,3,25,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2012,10,28,0,59,59],[2012,10,28,2,59,59],
          '2012032501:00:00','2012032503:00:00','2012102800:59:59','2012102802:59:59' ],
        [ [2012,10,28,1,0,0],[2012,10,28,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2013,3,31,0,59,59],[2013,3,31,1,59,59],
          '2012102801:00:00','2012102802:00:00','2013033100:59:59','2013033101:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,31,1,0,0],[2013,3,31,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2013,10,27,0,59,59],[2013,10,27,2,59,59],
          '2013033101:00:00','2013033103:00:00','2013102700:59:59','2013102702:59:59' ],
        [ [2013,10,27,1,0,0],[2013,10,27,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2014,3,30,0,59,59],[2014,3,30,1,59,59],
          '2013102701:00:00','2013102702:00:00','2014033000:59:59','2014033001:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,30,1,0,0],[2014,3,30,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2014,10,26,0,59,59],[2014,10,26,2,59,59],
          '2014033001:00:00','2014033003:00:00','2014102600:59:59','2014102602:59:59' ],
        [ [2014,10,26,1,0,0],[2014,10,26,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2015,3,29,0,59,59],[2015,3,29,1,59,59],
          '2014102601:00:00','2014102602:00:00','2015032900:59:59','2015032901:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,29,1,0,0],[2015,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2015,10,25,0,59,59],[2015,10,25,2,59,59],
          '2015032901:00:00','2015032903:00:00','2015102500:59:59','2015102502:59:59' ],
        [ [2015,10,25,1,0,0],[2015,10,25,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2016,3,27,0,59,59],[2016,3,27,1,59,59],
          '2015102501:00:00','2015102502:00:00','2016032700:59:59','2016032701:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,27,1,0,0],[2016,3,27,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2016,10,30,0,59,59],[2016,10,30,2,59,59],
          '2016032701:00:00','2016032703:00:00','2016103000:59:59','2016103002:59:59' ],
        [ [2016,10,30,1,0,0],[2016,10,30,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2017,3,26,0,59,59],[2017,3,26,1,59,59],
          '2016103001:00:00','2016103002:00:00','2017032600:59:59','2017032601:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,26,1,0,0],[2017,3,26,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2017,10,29,0,59,59],[2017,10,29,2,59,59],
          '2017032601:00:00','2017032603:00:00','2017102900:59:59','2017102902:59:59' ],
        [ [2017,10,29,1,0,0],[2017,10,29,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2018,3,25,0,59,59],[2018,3,25,1,59,59],
          '2017102901:00:00','2017102902:00:00','2018032500:59:59','2018032501:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,25,1,0,0],[2018,3,25,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2018,10,28,0,59,59],[2018,10,28,2,59,59],
          '2018032501:00:00','2018032503:00:00','2018102800:59:59','2018102802:59:59' ],
        [ [2018,10,28,1,0,0],[2018,10,28,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2019,3,31,0,59,59],[2019,3,31,1,59,59],
          '2018102801:00:00','2018102802:00:00','2019033100:59:59','2019033101:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,31,1,0,0],[2019,3,31,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2019,10,27,0,59,59],[2019,10,27,2,59,59],
          '2019033101:00:00','2019033103:00:00','2019102700:59:59','2019102702:59:59' ],
        [ [2019,10,27,1,0,0],[2019,10,27,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2020,3,29,0,59,59],[2020,3,29,1,59,59],
          '2019102701:00:00','2019102702:00:00','2020032900:59:59','2020032901:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,29,1,0,0],[2020,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2020,10,25,0,59,59],[2020,10,25,2,59,59],
          '2020032901:00:00','2020032903:00:00','2020102500:59:59','2020102502:59:59' ],
        [ [2020,10,25,1,0,0],[2020,10,25,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2021,3,28,0,59,59],[2021,3,28,1,59,59],
          '2020102501:00:00','2020102502:00:00','2021032800:59:59','2021032801:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,28,1,0,0],[2021,3,28,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2021,10,31,0,59,59],[2021,10,31,2,59,59],
          '2021032801:00:00','2021032803:00:00','2021103100:59:59','2021103102:59:59' ],
        [ [2021,10,31,1,0,0],[2021,10,31,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2022,3,27,0,59,59],[2022,3,27,1,59,59],
          '2021103101:00:00','2021103102:00:00','2022032700:59:59','2022032701:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,27,1,0,0],[2022,3,27,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2022,10,30,0,59,59],[2022,10,30,2,59,59],
          '2022032701:00:00','2022032703:00:00','2022103000:59:59','2022103002:59:59' ],
        [ [2022,10,30,1,0,0],[2022,10,30,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2023,3,26,0,59,59],[2023,3,26,1,59,59],
          '2022103001:00:00','2022103002:00:00','2023032600:59:59','2023032601:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,26,1,0,0],[2023,3,26,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2023,10,29,0,59,59],[2023,10,29,2,59,59],
          '2023032601:00:00','2023032603:00:00','2023102900:59:59','2023102902:59:59' ],
        [ [2023,10,29,1,0,0],[2023,10,29,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2024,3,31,0,59,59],[2024,3,31,1,59,59],
          '2023102901:00:00','2023102902:00:00','2024033100:59:59','2024033101:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,31,1,0,0],[2024,3,31,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2024,10,27,0,59,59],[2024,10,27,2,59,59],
          '2024033101:00:00','2024033103:00:00','2024102700:59:59','2024102702:59:59' ],
        [ [2024,10,27,1,0,0],[2024,10,27,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2025,3,30,0,59,59],[2025,3,30,1,59,59],
          '2024102701:00:00','2024102702:00:00','2025033000:59:59','2025033001:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,30,1,0,0],[2025,3,30,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2025,10,26,0,59,59],[2025,10,26,2,59,59],
          '2025033001:00:00','2025033003:00:00','2025102600:59:59','2025102602:59:59' ],
        [ [2025,10,26,1,0,0],[2025,10,26,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2026,3,29,0,59,59],[2026,3,29,1,59,59],
          '2025102601:00:00','2025102602:00:00','2026032900:59:59','2026032901:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,29,1,0,0],[2026,3,29,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2026,10,25,0,59,59],[2026,10,25,2,59,59],
          '2026032901:00:00','2026032903:00:00','2026102500:59:59','2026102502:59:59' ],
        [ [2026,10,25,1,0,0],[2026,10,25,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2027,3,28,0,59,59],[2027,3,28,1,59,59],
          '2026102501:00:00','2026102502:00:00','2027032800:59:59','2027032801:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,28,1,0,0],[2027,3,28,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2027,10,31,0,59,59],[2027,10,31,2,59,59],
          '2027032801:00:00','2027032803:00:00','2027103100:59:59','2027103102:59:59' ],
        [ [2027,10,31,1,0,0],[2027,10,31,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2028,3,26,0,59,59],[2028,3,26,1,59,59],
          '2027103101:00:00','2027103102:00:00','2028032600:59:59','2028032601:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,26,1,0,0],[2028,3,26,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2028,10,29,0,59,59],[2028,10,29,2,59,59],
          '2028032601:00:00','2028032603:00:00','2028102900:59:59','2028102902:59:59' ],
        [ [2028,10,29,1,0,0],[2028,10,29,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2029,3,25,0,59,59],[2029,3,25,1,59,59],
          '2028102901:00:00','2028102902:00:00','2029032500:59:59','2029032501:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,25,1,0,0],[2029,3,25,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2029,10,28,0,59,59],[2029,10,28,2,59,59],
          '2029032501:00:00','2029032503:00:00','2029102800:59:59','2029102802:59:59' ],
        [ [2029,10,28,1,0,0],[2029,10,28,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2030,3,31,0,59,59],[2030,3,31,1,59,59],
          '2029102801:00:00','2029102802:00:00','2030033100:59:59','2030033101:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,31,1,0,0],[2030,3,31,3,0,0],'+02:00:00',[2,0,0],
          'CEST',1,[2030,10,27,0,59,59],[2030,10,27,2,59,59],
          '2030033101:00:00','2030033103:00:00','2030102700:59:59','2030102702:59:59' ],
        [ [2030,10,27,1,0,0],[2030,10,27,2,0,0],'+01:00:00',[1,0,0],
          'CET',0,[2031,3,30,0,59,59],[2031,3,30,1,59,59],
          '2030102701:00:00','2030102702:00:00','2031033000:59:59','2031033001:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '+02:00:00',
                'stdoff' => '+01:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'u',
                         'time'    => '01:00:00',
                         'isdst'   => '1',
                         'abb'     => 'CEST',
                        },
                '10' => {
                         'flag'    => 'last',
                         'dow'     => '7',
                         'num'     => '0',
                         'type'    => 'u',
                         'time'    => '01:00:00',
                         'isdst'   => '0',
                         'abb'     => 'CET',
                        },
               },
);

1;
