package Test::BDD::Cucumber::Model::DataTableRow;
$Test::BDD::Cucumber::Model::DataTableRow::VERSION = '0.47';
use Moose;

=head1 NAME

Test::BDD::Cucumber::Model::DataTableRow - Model to represent a row of a DataTable

=head1 VERSION

version 0.47

=head1 DESCRIPTION

Model to represent a row of a DataTable

=head1 ATTRIBUTES

=head2 line

The corresponding L<Test:BDD::Cucumber::Model::Line> that the row starts on

=cut

has 'line' => ( is => 'rw', isa => 'Test::BDD::Cucumber::Model::Line' );

=head2 cells

An arraryref of strings containing the cell data, trimmed

=cut

has 'cells' => (
    is      => 'rw',
    isa     => 'ArrayRef[Str]',
    default => sub { [] }
);

=head2 cells_original

An arraryref of strings containing the cell data, untrimmed

=cut

has 'cells_original' => (
    is      => 'rw',
    isa     => 'ArrayRef[Str]',
    default => sub { [] }
);

=head1 METHODS

=head2 as_string

Pipe-delimited string representing the row

=cut

=head1 AUTHOR

Peter Sergeant C<pete@clueball.com>

=head1 LICENSE

Copyright 2011-2016, Peter Sergeant; Licensed under the same terms as Perl

=cut

1;
