package Test::BDD::Cucumber::Model::DataTable;
$Test::BDD::Cucumber::Model::DataTable::VERSION = '0.47';
use Moose;

=head1 NAME

Test::BDD::Cucumber::Model::DataTable - Model to represent a DataTable

=head1 VERSION

version 0.47

=head1 DESCRIPTION

Model to represent a DataTable

=head1 ATTRIBUTES

=head2 line

The corresponding L<Test:BDD::Cucumber::Model::Line> that the table starts on

=cut

has 'line' => ( is => 'rw', isa => 'Test::BDD::Cucumber::Model::Line' );

=head2 rows

An arraryref L<Test:BDD::Cucumber::Model::DataTableRow> objects

=cut

has 'rows' => (
    is      => 'rw',
    isa     => 'ArrayRef[Test:BDD::Cucumber::Model::DataTableRow]',
    default => sub { [] }
);

=head2 data

An arrayref of hashrefs representing the table data

=cut

has 'data' => (
    is => 'rw',
    isa => 'ArrayRef[HashRef]',
);

=head2 data_as_strings

An arrayref of strings containing the original step's data, for printing out
by harnesses

=cut

has 'data_as_strings' => (
    is      => 'rw',
    default => sub { [] },
    isa     => 'ArrayRef[Str]'
);

=head2 columns

The column names in the order they appeared

=cut

has 'columns' => ( is => 'rw', isa => 'ArrayRef[Str]' );

=head1 AUTHOR

Peter Sergeant C<pete@clueball.com>

=head1 LICENSE

Copyright 2011-2016, Peter Sergeant; Licensed under the same terms as Perl

=cut

1;
