#!/usr/bin/perl
use strict;
use warnings;
use ExtUtils::MakeMaker;

WriteMakefile(
    NAME                => 'POE::Component::NetSNMP::agent',
    LICENSE             => 'perl',
    AUTHOR              => 'Sebastien Aperghis-Tramoni <sebastien@aperghis.net>',
    VERSION_FROM        => 'lib/POE/Component/NetSNMP/agent.pm',
    ABSTRACT_FROM       => 'lib/POE/Component/NetSNMP/agent.pm',
    PREREQ_PM => {
        # prereqs
        'List::MoreUtils'   => 0.07,
        'NetSNMP::agent'    => 5.0000,
        'POE'               => 0.3502,
        'SNMP'              => 5.0000,
        'version'           => 0,

        # build/test prereqs
        'Test::More'        => 0,
    },
    META_MERGE          => {
        resources       => {
            repository  => {
                type    => "git",
                url     => "git://github.com/maddingue/POE-Component-NetSNMP-agent.git",
                web     => "https://github.com/maddingue/POE-Component-NetSNMP-agent",
            }
        },
    },
    PL_FILES            => {},
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'POE-Component-NetSNMP-agent-*' },
);
