
BEGIN {
    unless ("A" eq pack('U', 0x41)) {
	print "1..0 # Unicode::Collate " .
	    "cannot stringify a Unicode code point\n";
	exit 0;
    }
    if ($ENV{PERL_CORE}) {
	chdir('t') if -d 't';
	@INC = $^O eq 'MacOS' ? qw(::lib) : qw(../lib);
    }
}

use Test;
BEGIN { plan tests => 7022 };

use strict;
use warnings;
use Unicode::Collate::Locale;

ok(1);

#########################

my $objDefault = Unicode::Collate::Locale->
    new(locale => 'DEFAULT', normalization => undef);

ok($objDefault->getlocale, 'default');

my $objB = Unicode::Collate::Locale->
    new(locale => 'ZH__big5han', normalization => undef);

ok($objB->getlocale, 'zh__big5han');

my $objG = Unicode::Collate::Locale->
    new(locale => 'ZH__gb2312han', normalization => undef);

ok($objG->getlocale, 'zh__gb2312han');

my $objJ = Unicode::Collate::Locale->
    new(locale => 'JA', normalization => undef);

ok($objJ->getlocale, 'ja');

my $objK = Unicode::Collate::Locale->
    new(locale => 'KO', normalization => undef);

ok($objK->getlocale, 'ko');

my $objP = Unicode::Collate::Locale->
    new(locale => 'ZH__pinyin', normalization => undef);

ok($objP->getlocale, 'zh__pinyin');

my $objS = Unicode::Collate::Locale->
    new(locale => 'ZH__stroke', normalization => undef);

ok($objS->getlocale, 'zh__stroke');

for my $obj ($objDefault, $objB, $objG, $objJ, $objK, $objP, $objS) {
    $obj->change(level => 3);
    ok($obj->eq("\x{4E0D}", "\x{F967}"));
    ok($obj->eq("\x{4E26}", "\x{FA70}"));
    ok($obj->eq("\x{4E32}", "\x{F905}"));
    ok($obj->eq("\x{4E38}", "\x{2F801}"));
    ok($obj->eq("\x{4E39}", "\x{F95E}"));
    ok($obj->eq("\x{4E3D}", "\x{2F800}"));
    ok($obj->eq("\x{4E41}", "\x{2F802}"));
    ok($obj->eq("\x{4E82}", "\x{F91B}"));
    ok($obj->eq("\x{4E86}", "\x{F9BA}"));
    ok($obj->eq("\x{4EAE}", "\x{F977}"));
    ok($obj->eq("\x{4EC0}", "\x{F9FD}"));
    ok($obj->eq("\x{4ECC}", "\x{2F819}"));
    ok($obj->eq("\x{4EE4}", "\x{F9A8}"));
    ok($obj->eq("\x{4F60}", "\x{2F804}"));
    ok($obj->eq("\x{4F80}", "\x{FA73}"));
    ok($obj->eq("\x{4F86}", "\x{F92D}"));
    ok($obj->eq("\x{4F8B}", "\x{F9B5}"));
    ok($obj->eq("\x{4FAE}", "\x{FA30}"));
    ok($obj->eq("\x{4FAE}", "\x{2F805}"));
    ok($obj->eq("\x{4FBB}", "\x{2F806}"));
    ok($obj->eq("\x{4FBF}", "\x{F965}"));
    ok($obj->eq("\x{5002}", "\x{2F807}"));
    ok($obj->eq("\x{502B}", "\x{F9D4}"));
    ok($obj->eq("\x{507A}", "\x{2F808}"));
    ok($obj->eq("\x{5099}", "\x{2F809}"));
    ok($obj->eq("\x{50CF}", "\x{2F80B}"));
    ok($obj->eq("\x{50DA}", "\x{F9BB}"));
    ok($obj->eq("\x{50E7}", "\x{FA31}"));
    ok($obj->eq("\x{50E7}", "\x{2F80A}"));
    ok($obj->eq("\x{5140}", "\x{FA0C}"));
    ok($obj->eq("\x{5145}", "\x{FA74}"));
    ok($obj->eq("\x{514D}", "\x{FA32}"));
    ok($obj->eq("\x{514D}", "\x{2F80E}"));
    ok($obj->eq("\x{5154}", "\x{2F80F}"));
    ok($obj->eq("\x{5164}", "\x{2F810}"));
    ok($obj->eq("\x{5167}", "\x{2F814}"));
    ok($obj->eq("\x{5168}", "\x{FA72}"));
    ok($obj->eq("\x{5169}", "\x{F978}"));
    ok($obj->eq("\x{516D}", "\x{F9D1}"));
    ok($obj->eq("\x{5177}", "\x{2F811}"));
    ok($obj->eq("\x{5180}", "\x{FA75}"));
    ok($obj->eq("\x{518D}", "\x{2F815}"));
    ok($obj->eq("\x{5192}", "\x{2F8D2}"));
    ok($obj->eq("\x{5195}", "\x{2F8D3}"));
    ok($obj->eq("\x{5197}", "\x{2F817}"));
    ok($obj->eq("\x{51A4}", "\x{2F818}"));
    ok($obj->eq("\x{51AC}", "\x{2F81A}"));
    ok($obj->eq("\x{51B5}", "\x{FA71}"));
    ok($obj->eq("\x{51B5}", "\x{2F81B}"));
    ok($obj->eq("\x{51B7}", "\x{F92E}"));
    ok($obj->eq("\x{51C9}", "\x{F979}"));
    ok($obj->eq("\x{51CC}", "\x{F955}"));
    ok($obj->eq("\x{51DC}", "\x{F954}"));
    ok($obj->eq("\x{51DE}", "\x{FA15}"));
    ok($obj->eq("\x{51F5}", "\x{2F81D}"));
    ok($obj->eq("\x{5203}", "\x{2F81E}"));
    ok($obj->eq("\x{5207}", "\x{FA00}"));
    ok($obj->eq("\x{5207}", "\x{2F850}"));
    ok($obj->eq("\x{5217}", "\x{F99C}"));
    ok($obj->eq("\x{5229}", "\x{F9DD}"));
    ok($obj->eq("\x{523A}", "\x{F9FF}"));
    ok($obj->eq("\x{523B}", "\x{2F820}"));
    ok($obj->eq("\x{5246}", "\x{2F821}"));
    ok($obj->eq("\x{5272}", "\x{2F822}"));
    ok($obj->eq("\x{5277}", "\x{2F823}"));
    ok($obj->eq("\x{5289}", "\x{F9C7}"));
    ok($obj->eq("\x{529B}", "\x{F98A}"));
    ok($obj->eq("\x{52A3}", "\x{F99D}"));
    ok($obj->eq("\x{52B3}", "\x{2F992}"));
    ok($obj->eq("\x{52C7}", "\x{FA76}"));
    ok($obj->eq("\x{52C7}", "\x{2F825}"));
    ok($obj->eq("\x{52C9}", "\x{FA33}"));
    ok($obj->eq("\x{52C9}", "\x{2F826}"));
    ok($obj->eq("\x{52D2}", "\x{F952}"));
    ok($obj->eq("\x{52DE}", "\x{F92F}"));
    ok($obj->eq("\x{52E4}", "\x{FA34}"));
    ok($obj->eq("\x{52E4}", "\x{2F827}"));
    ok($obj->eq("\x{52F5}", "\x{F97F}"));
    ok($obj->eq("\x{52FA}", "\x{FA77}"));
    ok($obj->eq("\x{52FA}", "\x{2F828}"));
    ok($obj->eq("\x{5305}", "\x{2F829}"));
    ok($obj->eq("\x{5306}", "\x{2F82A}"));
    ok($obj->eq("\x{5317}", "\x{F963}"));
    ok($obj->eq("\x{5317}", "\x{2F82B}"));
    ok($obj->eq("\x{533F}", "\x{F9EB}"));
    ok($obj->eq("\x{5349}", "\x{2F82C}"));
    ok($obj->eq("\x{5351}", "\x{FA35}"));
    ok($obj->eq("\x{5351}", "\x{2F82D}"));
    ok($obj->eq("\x{535A}", "\x{2F82E}"));
    ok($obj->eq("\x{5373}", "\x{2F82F}"));
    ok($obj->eq("\x{5375}", "\x{F91C}"));
    ok($obj->eq("\x{537D}", "\x{2F830}"));
    ok($obj->eq("\x{537F}", "\x{2F831}"));
    ok($obj->eq("\x{537F}", "\x{2F832}"));
    ok($obj->eq("\x{537F}", "\x{2F833}"));
    ok($obj->eq("\x{53C3}", "\x{F96B}"));
    ok($obj->eq("\x{53CA}", "\x{2F836}"));
    ok($obj->eq("\x{53DF}", "\x{2F837}"));
    ok($obj->eq("\x{53E5}", "\x{F906}"));
    ok($obj->eq("\x{53EB}", "\x{2F839}"));
    ok($obj->eq("\x{53F1}", "\x{2F83A}"));
    ok($obj->eq("\x{5406}", "\x{2F83B}"));
    ok($obj->eq("\x{540F}", "\x{F9DE}"));
    ok($obj->eq("\x{541D}", "\x{F9ED}"));
    ok($obj->eq("\x{5438}", "\x{2F83D}"));
    ok($obj->eq("\x{5442}", "\x{F980}"));
    ok($obj->eq("\x{5448}", "\x{2F83E}"));
    ok($obj->eq("\x{5468}", "\x{2F83F}"));
    ok($obj->eq("\x{549E}", "\x{2F83C}"));
    ok($obj->eq("\x{54A2}", "\x{2F840}"));
    ok($obj->eq("\x{54BD}", "\x{F99E}"));
    ok($obj->eq("\x{54F6}", "\x{2F841}"));
    ok($obj->eq("\x{5510}", "\x{2F842}"));
    ok($obj->eq("\x{5553}", "\x{2F843}"));
    ok($obj->eq("\x{5555}", "\x{FA79}"));
    ok($obj->eq("\x{5563}", "\x{2F844}"));
    ok($obj->eq("\x{5584}", "\x{2F845}"));
    ok($obj->eq("\x{5584}", "\x{2F846}"));
    ok($obj->eq("\x{5587}", "\x{F90B}"));
    ok($obj->eq("\x{5599}", "\x{FA7A}"));
    ok($obj->eq("\x{5599}", "\x{2F847}"));
    ok($obj->eq("\x{559D}", "\x{FA36}"));
    ok($obj->eq("\x{559D}", "\x{FA78}"));
    ok($obj->eq("\x{55AB}", "\x{2F848}"));
    ok($obj->eq("\x{55B3}", "\x{2F849}"));
    ok($obj->eq("\x{55C0}", "\x{FA0D}"));
    ok($obj->eq("\x{55C2}", "\x{2F84A}"));
    ok($obj->eq("\x{55E2}", "\x{FA7B}"));
    ok($obj->eq("\x{5606}", "\x{FA37}"));
    ok($obj->eq("\x{5606}", "\x{2F84C}"));
    ok($obj->eq("\x{5651}", "\x{2F84E}"));
    ok($obj->eq("\x{5668}", "\x{FA38}"));
    ok($obj->eq("\x{5674}", "\x{2F84F}"));
    ok($obj->eq("\x{56F9}", "\x{F9A9}"));
    ok($obj->eq("\x{5716}", "\x{2F84B}"));
    ok($obj->eq("\x{5717}", "\x{2F84D}"));
    ok($obj->eq("\x{578B}", "\x{2F855}"));
    ok($obj->eq("\x{57CE}", "\x{2F852}"));
    ok($obj->eq("\x{57F4}", "\x{2F853}"));
    ok($obj->eq("\x{580D}", "\x{2F854}"));
    ok($obj->eq("\x{5831}", "\x{2F857}"));
    ok($obj->eq("\x{5832}", "\x{2F856}"));
    ok($obj->eq("\x{5840}", "\x{FA39}"));
    ok($obj->eq("\x{585A}", "\x{FA10}"));
    ok($obj->eq("\x{585A}", "\x{FA7C}"));
    ok($obj->eq("\x{585E}", "\x{F96C}"));
    ok($obj->eq("\x{58A8}", "\x{FA3A}"));
    ok($obj->eq("\x{58AC}", "\x{2F858}"));
    ok($obj->eq("\x{58B3}", "\x{FA7D}"));
    ok($obj->eq("\x{58D8}", "\x{F94A}"));
    ok($obj->eq("\x{58DF}", "\x{F942}"));
    ok($obj->eq("\x{58EE}", "\x{2F851}"));
    ok($obj->eq("\x{58F2}", "\x{2F85A}"));
    ok($obj->eq("\x{58F7}", "\x{2F85B}"));
    ok($obj->eq("\x{5906}", "\x{2F85C}"));
    ok($obj->eq("\x{591A}", "\x{2F85D}"));
    ok($obj->eq("\x{5922}", "\x{2F85E}"));
    ok($obj->eq("\x{5944}", "\x{FA7E}"));
    ok($obj->eq("\x{5948}", "\x{F90C}"));
    ok($obj->eq("\x{5951}", "\x{F909}"));
    ok($obj->eq("\x{5954}", "\x{FA7F}"));
    ok($obj->eq("\x{5962}", "\x{2F85F}"));
    ok($obj->eq("\x{5973}", "\x{F981}"));
    ok($obj->eq("\x{59D8}", "\x{2F865}"));
    ok($obj->eq("\x{59EC}", "\x{2F862}"));
    ok($obj->eq("\x{5A1B}", "\x{2F863}"));
    ok($obj->eq("\x{5A27}", "\x{2F864}"));
    ok($obj->eq("\x{5A62}", "\x{FA80}"));
    ok($obj->eq("\x{5A66}", "\x{2F866}"));
    ok($obj->eq("\x{5AB5}", "\x{2F986}"));
    ok($obj->eq("\x{5B08}", "\x{2F869}"));
    ok($obj->eq("\x{5B28}", "\x{FA81}"));
    ok($obj->eq("\x{5B3E}", "\x{2F86A}"));
    ok($obj->eq("\x{5B3E}", "\x{2F86B}"));
    ok($obj->eq("\x{5B85}", "\x{FA04}"));
    ok($obj->eq("\x{5BC3}", "\x{2F86D}"));
    ok($obj->eq("\x{5BD8}", "\x{2F86E}"));
    ok($obj->eq("\x{5BE7}", "\x{F95F}"));
    ok($obj->eq("\x{5BE7}", "\x{F9AA}"));
    ok($obj->eq("\x{5BE7}", "\x{2F86F}"));
    ok($obj->eq("\x{5BEE}", "\x{F9BC}"));
    ok($obj->eq("\x{5BF3}", "\x{2F870}"));
    ok($obj->eq("\x{5BFF}", "\x{2F872}"));
    ok($obj->eq("\x{5C06}", "\x{2F873}"));
    ok($obj->eq("\x{5C22}", "\x{2F875}"));
    ok($obj->eq("\x{5C3F}", "\x{F9BD}"));
    ok($obj->eq("\x{5C60}", "\x{2F877}"));
    ok($obj->eq("\x{5C62}", "\x{F94B}"));
    ok($obj->eq("\x{5C64}", "\x{FA3B}"));
    ok($obj->eq("\x{5C65}", "\x{F9DF}"));
    ok($obj->eq("\x{5C6E}", "\x{FA3C}"));
    ok($obj->eq("\x{5C6E}", "\x{2F878}"));
    ok($obj->eq("\x{5C8D}", "\x{2F87A}"));
    ok($obj->eq("\x{5CC0}", "\x{2F879}"));
    ok($obj->eq("\x{5D19}", "\x{F9D5}"));
    ok($obj->eq("\x{5D43}", "\x{2F87C}"));
    ok($obj->eq("\x{5D50}", "\x{F921}"));
    ok($obj->eq("\x{5D6B}", "\x{2F87F}"));
    ok($obj->eq("\x{5D6E}", "\x{2F87E}"));
    ok($obj->eq("\x{5D7C}", "\x{2F880}"));
    ok($obj->eq("\x{5DB2}", "\x{2F9F4}"));
    ok($obj->eq("\x{5DBA}", "\x{F9AB}"));
    ok($obj->eq("\x{5DE1}", "\x{2F881}"));
    ok($obj->eq("\x{5DE2}", "\x{2F882}"));
    ok($obj->eq("\x{5DFD}", "\x{2F884}"));
    ok($obj->eq("\x{5E28}", "\x{2F885}"));
    ok($obj->eq("\x{5E3D}", "\x{2F886}"));
    ok($obj->eq("\x{5E69}", "\x{2F887}"));
    ok($obj->eq("\x{5E74}", "\x{F98E}"));
    ok($obj->eq("\x{5EA6}", "\x{FA01}"));
    ok($obj->eq("\x{5EB0}", "\x{2F88B}"));
    ok($obj->eq("\x{5EB3}", "\x{2F88C}"));
    ok($obj->eq("\x{5EB6}", "\x{2F88D}"));
    ok($obj->eq("\x{5EC9}", "\x{F9A2}"));
    ok($obj->eq("\x{5ECA}", "\x{F928}"));
    ok($obj->eq("\x{5ECA}", "\x{2F88E}"));
    ok($obj->eq("\x{5ED2}", "\x{FA82}"));
    ok($obj->eq("\x{5ED3}", "\x{FA0B}"));
    ok($obj->eq("\x{5ED9}", "\x{FA83}"));
    ok($obj->eq("\x{5EEC}", "\x{F982}"));
    ok($obj->eq("\x{5EFE}", "\x{2F890}"));
    ok($obj->eq("\x{5F04}", "\x{F943}"));
    ok($obj->eq("\x{5F22}", "\x{2F894}"));
    ok($obj->eq("\x{5F22}", "\x{2F895}"));
    ok($obj->eq("\x{5F53}", "\x{2F874}"));
    ok($obj->eq("\x{5F62}", "\x{2F899}"));
    ok($obj->eq("\x{5F69}", "\x{FA84}"));
    ok($obj->eq("\x{5F6B}", "\x{2F89A}"));
    ok($obj->eq("\x{5F8B}", "\x{F9D8}"));
    ok($obj->eq("\x{5F9A}", "\x{2F89C}"));
    ok($obj->eq("\x{5FA9}", "\x{F966}"));
    ok($obj->eq("\x{5FAD}", "\x{FA85}"));
    ok($obj->eq("\x{5FCD}", "\x{2F89D}"));
    ok($obj->eq("\x{5FD7}", "\x{2F89E}"));
    ok($obj->eq("\x{5FF5}", "\x{F9A3}"));
    ok($obj->eq("\x{5FF9}", "\x{2F89F}"));
    ok($obj->eq("\x{6012}", "\x{F960}"));
    ok($obj->eq("\x{601C}", "\x{F9AC}"));
    ok($obj->eq("\x{6075}", "\x{FA6B}"));
    ok($obj->eq("\x{6081}", "\x{2F8A0}"));
    ok($obj->eq("\x{6094}", "\x{FA3D}"));
    ok($obj->eq("\x{6094}", "\x{2F8A3}"));
    ok($obj->eq("\x{60C7}", "\x{2F8A5}"));
    ok($obj->eq("\x{60D8}", "\x{FA86}"));
    ok($obj->eq("\x{60E1}", "\x{F9B9}"));
    ok($obj->eq("\x{6108}", "\x{FA88}"));
    ok($obj->eq("\x{6144}", "\x{F9D9}"));
    ok($obj->eq("\x{6148}", "\x{2F8A6}"));
    ok($obj->eq("\x{614C}", "\x{2F8A7}"));
    ok($obj->eq("\x{614C}", "\x{2F8A9}"));
    ok($obj->eq("\x{614E}", "\x{FA87}"));
    ok($obj->eq("\x{614E}", "\x{2F8A8}"));
    ok($obj->eq("\x{6160}", "\x{FA8A}"));
    ok($obj->eq("\x{6168}", "\x{FA3E}"));
    ok($obj->eq("\x{617A}", "\x{2F8AA}"));
    ok($obj->eq("\x{618E}", "\x{FA3F}"));
    ok($obj->eq("\x{618E}", "\x{FA89}"));
    ok($obj->eq("\x{618E}", "\x{2F8AB}"));
    ok($obj->eq("\x{6190}", "\x{F98F}"));
    ok($obj->eq("\x{61A4}", "\x{2F8AD}"));
    ok($obj->eq("\x{61AF}", "\x{2F8AE}"));
    ok($obj->eq("\x{61B2}", "\x{2F8AC}"));
    ok($obj->eq("\x{61DE}", "\x{2F8AF}"));
    ok($obj->eq("\x{61F2}", "\x{FA40}"));
    ok($obj->eq("\x{61F2}", "\x{FA8B}"));
    ok($obj->eq("\x{61F2}", "\x{2F8B0}"));
    ok($obj->eq("\x{61F6}", "\x{F90D}"));
    ok($obj->eq("\x{61F6}", "\x{2F8B1}"));
    ok($obj->eq("\x{6200}", "\x{F990}"));
    ok($obj->eq("\x{6210}", "\x{2F8B2}"));
    ok($obj->eq("\x{621B}", "\x{2F8B3}"));
    ok($obj->eq("\x{622E}", "\x{F9D2}"));
    ok($obj->eq("\x{6234}", "\x{FA8C}"));
    ok($obj->eq("\x{625D}", "\x{2F8B4}"));
    ok($obj->eq("\x{62B1}", "\x{2F8B5}"));
    ok($obj->eq("\x{62C9}", "\x{F925}"));
    ok($obj->eq("\x{62CF}", "\x{F95B}"));
    ok($obj->eq("\x{62D3}", "\x{FA02}"));
    ok($obj->eq("\x{62D4}", "\x{2F8B6}"));
    ok($obj->eq("\x{62FC}", "\x{2F8BA}"));
    ok($obj->eq("\x{62FE}", "\x{F973}"));
    ok($obj->eq("\x{633D}", "\x{2F8B9}"));
    ok($obj->eq("\x{6350}", "\x{2F8B7}"));
    ok($obj->eq("\x{6368}", "\x{2F8BB}"));
    ok($obj->eq("\x{637B}", "\x{F9A4}"));
    ok($obj->eq("\x{6383}", "\x{2F8BC}"));
    ok($obj->eq("\x{63A0}", "\x{F975}"));
    ok($obj->eq("\x{63A9}", "\x{2F8C1}"));
    ok($obj->eq("\x{63C4}", "\x{FA8D}"));
    ok($obj->eq("\x{63C5}", "\x{2F8C0}"));
    ok($obj->eq("\x{63E4}", "\x{2F8BD}"));
    ok($obj->eq("\x{641C}", "\x{FA8E}"));
    ok($obj->eq("\x{6422}", "\x{2F8BF}"));
    ok($obj->eq("\x{6452}", "\x{FA8F}"));
    ok($obj->eq("\x{6469}", "\x{2F8C3}"));
    ok($obj->eq("\x{6477}", "\x{2F8C6}"));
    ok($obj->eq("\x{647E}", "\x{2F8C4}"));
    ok($obj->eq("\x{649A}", "\x{F991}"));
    ok($obj->eq("\x{649D}", "\x{2F8C5}"));
    ok($obj->eq("\x{64C4}", "\x{F930}"));
    ok($obj->eq("\x{654F}", "\x{FA41}"));
    ok($obj->eq("\x{654F}", "\x{2F8C8}"));
    ok($obj->eq("\x{6556}", "\x{FA90}"));
    ok($obj->eq("\x{656C}", "\x{2F8C9}"));
    ok($obj->eq("\x{6578}", "\x{F969}"));
    ok($obj->eq("\x{6599}", "\x{F9BE}"));
    ok($obj->eq("\x{65C5}", "\x{F983}"));
    ok($obj->eq("\x{65E2}", "\x{FA42}"));
    ok($obj->eq("\x{65E3}", "\x{2F8CB}"));
    ok($obj->eq("\x{6613}", "\x{F9E0}"));
    ok($obj->eq("\x{6649}", "\x{2F8CD}"));
    ok($obj->eq("\x{6674}", "\x{FA12}"));
    ok($obj->eq("\x{6674}", "\x{FA91}"));
    ok($obj->eq("\x{6688}", "\x{F9C5}"));
    ok($obj->eq("\x{6691}", "\x{FA43}"));
    ok($obj->eq("\x{6691}", "\x{2F8CF}"));
    ok($obj->eq("\x{669C}", "\x{2F8D5}"));
    ok($obj->eq("\x{66B4}", "\x{FA06}"));
    ok($obj->eq("\x{66C6}", "\x{F98B}"));
    ok($obj->eq("\x{66F4}", "\x{F901}"));
    ok($obj->eq("\x{66F8}", "\x{2F8CC}"));
    ok($obj->eq("\x{6700}", "\x{2F8D4}"));
    ok($obj->eq("\x{6717}", "\x{F929}"));
    ok($obj->eq("\x{6717}", "\x{FA92}"));
    ok($obj->eq("\x{6717}", "\x{2F8D8}"));
    ok($obj->eq("\x{671B}", "\x{FA93}"));
    ok($obj->eq("\x{671B}", "\x{2F8D9}"));
    ok($obj->eq("\x{6721}", "\x{2F8DA}"));
    ok($obj->eq("\x{674E}", "\x{F9E1}"));
    ok($obj->eq("\x{6753}", "\x{2F8DC}"));
    ok($obj->eq("\x{6756}", "\x{FA94}"));
    ok($obj->eq("\x{675E}", "\x{2F8DB}"));
    ok($obj->eq("\x{677B}", "\x{F9C8}"));
    ok($obj->eq("\x{6785}", "\x{2F8E0}"));
    ok($obj->eq("\x{6797}", "\x{F9F4}"));
    ok($obj->eq("\x{67F3}", "\x{F9C9}"));
    ok($obj->eq("\x{67FA}", "\x{2F8DF}"));
    ok($obj->eq("\x{6817}", "\x{F9DA}"));
    ok($obj->eq("\x{681F}", "\x{2F8E5}"));
    ok($obj->eq("\x{6852}", "\x{2F8E1}"));
    ok($obj->eq("\x{6881}", "\x{F97A}"));
    ok($obj->eq("\x{6885}", "\x{FA44}"));
    ok($obj->eq("\x{6885}", "\x{2F8E2}"));
    ok($obj->eq("\x{688E}", "\x{2F8E4}"));
    ok($obj->eq("\x{68A8}", "\x{F9E2}"));
    ok($obj->eq("\x{6914}", "\x{2F8E6}"));
    ok($obj->eq("\x{6942}", "\x{2F8E8}"));
    ok($obj->eq("\x{69A3}", "\x{2F8E9}"));
    ok($obj->eq("\x{69EA}", "\x{2F8EA}"));
    ok($obj->eq("\x{6A02}", "\x{F914}"));
    ok($obj->eq("\x{6A02}", "\x{F95C}"));
    ok($obj->eq("\x{6A02}", "\x{F9BF}"));
    ok($obj->eq("\x{6A13}", "\x{F94C}"));
    ok($obj->eq("\x{6AA8}", "\x{2F8EB}"));
    ok($obj->eq("\x{6AD3}", "\x{F931}"));
    ok($obj->eq("\x{6ADB}", "\x{2F8ED}"));
    ok($obj->eq("\x{6B04}", "\x{F91D}"));
    ok($obj->eq("\x{6B21}", "\x{2F8EF}"));
    ok($obj->eq("\x{6B54}", "\x{2F8F1}"));
    ok($obj->eq("\x{6B72}", "\x{2F8F3}"));
    ok($obj->eq("\x{6B77}", "\x{F98C}"));
    ok($obj->eq("\x{6B79}", "\x{FA95}"));
    ok($obj->eq("\x{6B9F}", "\x{2F8F4}"));
    ok($obj->eq("\x{6BAE}", "\x{F9A5}"));
    ok($obj->eq("\x{6BBA}", "\x{F970}"));
    ok($obj->eq("\x{6BBA}", "\x{FA96}"));
    ok($obj->eq("\x{6BBA}", "\x{2F8F5}"));
    ok($obj->eq("\x{6BBB}", "\x{2F8F6}"));
    ok($obj->eq("\x{6C4E}", "\x{2F8FA}"));
    ok($obj->eq("\x{6C67}", "\x{2F8FE}"));
    ok($obj->eq("\x{6C88}", "\x{F972}"));
    ok($obj->eq("\x{6CBF}", "\x{2F8FC}"));
    ok($obj->eq("\x{6CCC}", "\x{F968}"));
    ok($obj->eq("\x{6CCD}", "\x{2F8FD}"));
    ok($obj->eq("\x{6CE5}", "\x{F9E3}"));
    ok($obj->eq("\x{6D16}", "\x{2F8FF}"));
    ok($obj->eq("\x{6D1B}", "\x{F915}"));
    ok($obj->eq("\x{6D1E}", "\x{FA05}"));
    ok($obj->eq("\x{6D34}", "\x{2F907}"));
    ok($obj->eq("\x{6D3E}", "\x{2F900}"));
    ok($obj->eq("\x{6D41}", "\x{F9CA}"));
    ok($obj->eq("\x{6D41}", "\x{FA97}"));
    ok($obj->eq("\x{6D41}", "\x{2F902}"));
    ok($obj->eq("\x{6D69}", "\x{2F903}"));
    ok($obj->eq("\x{6D6A}", "\x{F92A}"));
    ok($obj->eq("\x{6D77}", "\x{FA45}"));
    ok($obj->eq("\x{6D77}", "\x{2F901}"));
    ok($obj->eq("\x{6D78}", "\x{2F904}"));
    ok($obj->eq("\x{6D85}", "\x{2F905}"));
    ok($obj->eq("\x{6DCB}", "\x{F9F5}"));
    ok($obj->eq("\x{6DDA}", "\x{F94D}"));
    ok($obj->eq("\x{6DEA}", "\x{F9D6}"));
    ok($obj->eq("\x{6DF9}", "\x{2F90E}"));
    ok($obj->eq("\x{6E1A}", "\x{FA46}"));
    ok($obj->eq("\x{6E2F}", "\x{2F908}"));
    ok($obj->eq("\x{6E6E}", "\x{2F909}"));
    ok($obj->eq("\x{6E9C}", "\x{F9CB}"));
    ok($obj->eq("\x{6EBA}", "\x{F9EC}"));
    ok($obj->eq("\x{6EC7}", "\x{2F90C}"));
    ok($obj->eq("\x{6ECB}", "\x{FA99}"));
    ok($obj->eq("\x{6ECB}", "\x{2F90B}"));
    ok($obj->eq("\x{6ED1}", "\x{F904}"));
    ok($obj->eq("\x{6EDB}", "\x{FA98}"));
    ok($obj->eq("\x{6F0F}", "\x{F94E}"));
    ok($obj->eq("\x{6F22}", "\x{FA47}"));
    ok($obj->eq("\x{6F22}", "\x{FA9A}"));
    ok($obj->eq("\x{6F23}", "\x{F992}"));
    ok($obj->eq("\x{6F6E}", "\x{2F90F}"));
    ok($obj->eq("\x{6FC6}", "\x{2F912}"));
    ok($obj->eq("\x{6FEB}", "\x{F922}"));
    ok($obj->eq("\x{6FFE}", "\x{F984}"));
    ok($obj->eq("\x{701B}", "\x{2F915}"));
    ok($obj->eq("\x{701E}", "\x{FA9B}"));
    ok($obj->eq("\x{701E}", "\x{2F914}"));
    ok($obj->eq("\x{7039}", "\x{2F913}"));
    ok($obj->eq("\x{704A}", "\x{2F917}"));
    ok($obj->eq("\x{7070}", "\x{2F835}"));
    ok($obj->eq("\x{7077}", "\x{2F919}"));
    ok($obj->eq("\x{707D}", "\x{2F918}"));
    ok($obj->eq("\x{7099}", "\x{F9FB}"));
    ok($obj->eq("\x{70AD}", "\x{2F91A}"));
    ok($obj->eq("\x{70C8}", "\x{F99F}"));
    ok($obj->eq("\x{70D9}", "\x{F916}"));
    ok($obj->eq("\x{7145}", "\x{2F91C}"));
    ok($obj->eq("\x{7149}", "\x{F993}"));
    ok($obj->eq("\x{716E}", "\x{FA48}"));
    ok($obj->eq("\x{716E}", "\x{FA9C}"));
    ok($obj->eq("\x{719C}", "\x{2F91E}"));
    ok($obj->eq("\x{71CE}", "\x{F9C0}"));
    ok($obj->eq("\x{71D0}", "\x{F9EE}"));
    ok($obj->eq("\x{7210}", "\x{F932}"));
    ok($obj->eq("\x{721B}", "\x{F91E}"));
    ok($obj->eq("\x{7228}", "\x{2F920}"));
    ok($obj->eq("\x{722B}", "\x{FA49}"));
    ok($obj->eq("\x{7235}", "\x{FA9E}"));
    ok($obj->eq("\x{7235}", "\x{2F921}"));
    ok($obj->eq("\x{7250}", "\x{2F922}"));
    ok($obj->eq("\x{7262}", "\x{F946}"));
    ok($obj->eq("\x{7280}", "\x{2F924}"));
    ok($obj->eq("\x{7295}", "\x{2F925}"));
    ok($obj->eq("\x{72AF}", "\x{FA9F}"));
    ok($obj->eq("\x{72C0}", "\x{F9FA}"));
    ok($obj->eq("\x{72FC}", "\x{F92B}"));
    ok($obj->eq("\x{732A}", "\x{FA16}"));
    ok($obj->eq("\x{732A}", "\x{FAA0}"));
    ok($obj->eq("\x{7375}", "\x{F9A7}"));
    ok($obj->eq("\x{737A}", "\x{2F928}"));
    ok($obj->eq("\x{7387}", "\x{F961}"));
    ok($obj->eq("\x{7387}", "\x{F9DB}"));
    ok($obj->eq("\x{738B}", "\x{2F929}"));
    ok($obj->eq("\x{73A5}", "\x{2F92B}"));
    ok($obj->eq("\x{73B2}", "\x{F9AD}"));
    ok($obj->eq("\x{73DE}", "\x{F917}"));
    ok($obj->eq("\x{7406}", "\x{F9E4}"));
    ok($obj->eq("\x{7409}", "\x{F9CC}"));
    ok($obj->eq("\x{7422}", "\x{FA4A}"));
    ok($obj->eq("\x{7447}", "\x{2F92E}"));
    ok($obj->eq("\x{745C}", "\x{2F92F}"));
    ok($obj->eq("\x{7469}", "\x{F9AE}"));
    ok($obj->eq("\x{7471}", "\x{FAA1}"));
    ok($obj->eq("\x{7471}", "\x{2F930}"));
    ok($obj->eq("\x{7485}", "\x{2F931}"));
    ok($obj->eq("\x{7489}", "\x{F994}"));
    ok($obj->eq("\x{7498}", "\x{F9EF}"));
    ok($obj->eq("\x{74CA}", "\x{2F932}"));
    ok($obj->eq("\x{7506}", "\x{FAA2}"));
    ok($obj->eq("\x{7524}", "\x{2F934}"));
    ok($obj->eq("\x{753B}", "\x{FAA3}"));
    ok($obj->eq("\x{753E}", "\x{2F936}"));
    ok($obj->eq("\x{7559}", "\x{F9CD}"));
    ok($obj->eq("\x{7565}", "\x{F976}"));
    ok($obj->eq("\x{7570}", "\x{F962}"));
    ok($obj->eq("\x{7570}", "\x{2F938}"));
    ok($obj->eq("\x{75E2}", "\x{F9E5}"));
    ok($obj->eq("\x{7610}", "\x{2F93A}"));
    ok($obj->eq("\x{761D}", "\x{FAA4}"));
    ok($obj->eq("\x{761F}", "\x{FAA5}"));
    ok($obj->eq("\x{7642}", "\x{F9C1}"));
    ok($obj->eq("\x{7669}", "\x{F90E}"));
    ok($obj->eq("\x{76CA}", "\x{FA17}"));
    ok($obj->eq("\x{76CA}", "\x{FAA6}"));
    ok($obj->eq("\x{76DB}", "\x{FAA7}"));
    ok($obj->eq("\x{76E7}", "\x{F933}"));
    ok($obj->eq("\x{76F4}", "\x{FAA8}"));
    ok($obj->eq("\x{76F4}", "\x{2F940}"));
    ok($obj->eq("\x{7701}", "\x{F96D}"));
    ok($obj->eq("\x{771E}", "\x{2F945}"));
    ok($obj->eq("\x{771F}", "\x{2F946}"));
    ok($obj->eq("\x{771F}", "\x{2F947}"));
    ok($obj->eq("\x{7740}", "\x{FAAA}"));
    ok($obj->eq("\x{774A}", "\x{FAA9}"));
    ok($obj->eq("\x{774A}", "\x{2F948}"));
    ok($obj->eq("\x{778B}", "\x{2F94A}"));
    ok($obj->eq("\x{77A7}", "\x{FA9D}"));
    ok($obj->eq("\x{784E}", "\x{2F94E}"));
    ok($obj->eq("\x{786B}", "\x{F9CE}"));
    ok($obj->eq("\x{788C}", "\x{F93B}"));
    ok($obj->eq("\x{788C}", "\x{2F94F}"));
    ok($obj->eq("\x{7891}", "\x{FA4B}"));
    ok($obj->eq("\x{78CA}", "\x{F947}"));
    ok($obj->eq("\x{78CC}", "\x{FAAB}"));
    ok($obj->eq("\x{78CC}", "\x{2F950}"));
    ok($obj->eq("\x{78FB}", "\x{F964}"));
    ok($obj->eq("\x{792A}", "\x{F985}"));
    ok($obj->eq("\x{793C}", "\x{FA18}"));
    ok($obj->eq("\x{793E}", "\x{FA4C}"));
    ok($obj->eq("\x{7948}", "\x{FA4E}"));
    ok($obj->eq("\x{7949}", "\x{FA4D}"));
    ok($obj->eq("\x{7950}", "\x{FA4F}"));
    ok($obj->eq("\x{7956}", "\x{FA50}"));
    ok($obj->eq("\x{7956}", "\x{2F953}"));
    ok($obj->eq("\x{795D}", "\x{FA51}"));
    ok($obj->eq("\x{795E}", "\x{FA19}"));
    ok($obj->eq("\x{7965}", "\x{FA1A}"));
    ok($obj->eq("\x{797F}", "\x{F93C}"));
    ok($obj->eq("\x{798D}", "\x{FA52}"));
    ok($obj->eq("\x{798E}", "\x{FA53}"));
    ok($obj->eq("\x{798F}", "\x{FA1B}"));
    ok($obj->eq("\x{798F}", "\x{2F956}"));
    ok($obj->eq("\x{79AE}", "\x{F9B6}"));
    ok($obj->eq("\x{79CA}", "\x{F995}"));
    ok($obj->eq("\x{79EB}", "\x{2F957}"));
    ok($obj->eq("\x{7A1C}", "\x{F956}"));
    ok($obj->eq("\x{7A40}", "\x{FA54}"));
    ok($obj->eq("\x{7A40}", "\x{2F959}"));
    ok($obj->eq("\x{7A4A}", "\x{2F95A}"));
    ok($obj->eq("\x{7A4F}", "\x{2F95B}"));
    ok($obj->eq("\x{7A81}", "\x{FA55}"));
    ok($obj->eq("\x{7AB1}", "\x{FAAC}"));
    ok($obj->eq("\x{7ACB}", "\x{F9F7}"));
    ok($obj->eq("\x{7AEE}", "\x{2F95F}"));
    ok($obj->eq("\x{7B20}", "\x{F9F8}"));
    ok($obj->eq("\x{7BC0}", "\x{FA56}"));
    ok($obj->eq("\x{7BC0}", "\x{FAAD}"));
    ok($obj->eq("\x{7BC6}", "\x{2F962}"));
    ok($obj->eq("\x{7BC9}", "\x{2F963}"));
    ok($obj->eq("\x{7C3E}", "\x{F9A6}"));
    ok($obj->eq("\x{7C60}", "\x{F944}"));
    ok($obj->eq("\x{7C7B}", "\x{FAAE}"));
    ok($obj->eq("\x{7C92}", "\x{F9F9}"));
    ok($obj->eq("\x{7CBE}", "\x{FA1D}"));
    ok($obj->eq("\x{7CD2}", "\x{2F966}"));
    ok($obj->eq("\x{7CD6}", "\x{FA03}"));
    ok($obj->eq("\x{7CE3}", "\x{2F969}"));
    ok($obj->eq("\x{7CE7}", "\x{F97B}"));
    ok($obj->eq("\x{7CE8}", "\x{2F968}"));
    ok($obj->eq("\x{7D00}", "\x{2F96A}"));
    ok($obj->eq("\x{7D10}", "\x{F9CF}"));
    ok($obj->eq("\x{7D22}", "\x{F96A}"));
    ok($obj->eq("\x{7D2F}", "\x{F94F}"));
    ok($obj->eq("\x{7D5B}", "\x{FAAF}"));
    ok($obj->eq("\x{7D63}", "\x{2F96C}"));
    ok($obj->eq("\x{7DA0}", "\x{F93D}"));
    ok($obj->eq("\x{7DBE}", "\x{F957}"));
    ok($obj->eq("\x{7DC7}", "\x{2F96E}"));
    ok($obj->eq("\x{7DF4}", "\x{F996}"));
    ok($obj->eq("\x{7DF4}", "\x{FA57}"));
    ok($obj->eq("\x{7DF4}", "\x{FAB0}"));
    ok($obj->eq("\x{7E02}", "\x{2F96F}"));
    ok($obj->eq("\x{7E09}", "\x{FA58}"));
    ok($obj->eq("\x{7E37}", "\x{F950}"));
    ok($obj->eq("\x{7E41}", "\x{FA59}"));
    ok($obj->eq("\x{7E45}", "\x{2F970}"));
    ok($obj->eq("\x{7F3E}", "\x{FAB1}"));
    ok($obj->eq("\x{7F72}", "\x{FA5A}"));
    ok($obj->eq("\x{7F79}", "\x{F9E6}"));
    ok($obj->eq("\x{7F7A}", "\x{2F976}"));
    ok($obj->eq("\x{7F85}", "\x{F90F}"));
    ok($obj->eq("\x{7F95}", "\x{2F978}"));
    ok($obj->eq("\x{7F9A}", "\x{F9AF}"));
    ok($obj->eq("\x{7FBD}", "\x{FA1E}"));
    ok($obj->eq("\x{7FFA}", "\x{2F979}"));
    ok($obj->eq("\x{8001}", "\x{F934}"));
    ok($obj->eq("\x{8005}", "\x{FA5B}"));
    ok($obj->eq("\x{8005}", "\x{FAB2}"));
    ok($obj->eq("\x{8005}", "\x{2F97A}"));
    ok($obj->eq("\x{8046}", "\x{F9B0}"));
    ok($obj->eq("\x{8060}", "\x{2F97D}"));
    ok($obj->eq("\x{806F}", "\x{F997}"));
    ok($obj->eq("\x{8070}", "\x{2F97F}"));
    ok($obj->eq("\x{807E}", "\x{F945}"));
    ok($obj->eq("\x{808B}", "\x{F953}"));
    ok($obj->eq("\x{80AD}", "\x{2F8D6}"));
    ok($obj->eq("\x{80B2}", "\x{2F982}"));
    ok($obj->eq("\x{8103}", "\x{2F983}"));
    ok($obj->eq("\x{813E}", "\x{2F985}"));
    ok($obj->eq("\x{81D8}", "\x{F926}"));
    ok($obj->eq("\x{81E8}", "\x{F9F6}"));
    ok($obj->eq("\x{81ED}", "\x{FA5C}"));
    ok($obj->eq("\x{8201}", "\x{2F893}"));
    ok($obj->eq("\x{8201}", "\x{2F98B}"));
    ok($obj->eq("\x{8204}", "\x{2F98C}"));
    ok($obj->eq("\x{8218}", "\x{FA6D}"));
    ok($obj->eq("\x{826F}", "\x{F97C}"));
    ok($obj->eq("\x{8279}", "\x{FA5D}"));
    ok($obj->eq("\x{8279}", "\x{FA5E}"));
    ok($obj->eq("\x{828B}", "\x{2F990}"));
    ok($obj->eq("\x{8291}", "\x{2F98F}"));
    ok($obj->eq("\x{829D}", "\x{2F991}"));
    ok($obj->eq("\x{82B1}", "\x{2F993}"));
    ok($obj->eq("\x{82B3}", "\x{2F994}"));
    ok($obj->eq("\x{82BD}", "\x{2F995}"));
    ok($obj->eq("\x{82E5}", "\x{F974}"));
    ok($obj->eq("\x{82E5}", "\x{2F998}"));
    ok($obj->eq("\x{82E6}", "\x{2F996}"));
    ok($obj->eq("\x{831D}", "\x{2F999}"));
    ok($obj->eq("\x{8323}", "\x{2F99C}"));
    ok($obj->eq("\x{8336}", "\x{F9FE}"));
    ok($obj->eq("\x{8352}", "\x{FAB3}"));
    ok($obj->eq("\x{8353}", "\x{2F9A0}"));
    ok($obj->eq("\x{8363}", "\x{2F99A}"));
    ok($obj->eq("\x{83AD}", "\x{2F99B}"));
    ok($obj->eq("\x{83BD}", "\x{2F99D}"));
    ok($obj->eq("\x{83C9}", "\x{F93E}"));
    ok($obj->eq("\x{83CA}", "\x{2F9A1}"));
    ok($obj->eq("\x{83CC}", "\x{2F9A2}"));
    ok($obj->eq("\x{83DC}", "\x{2F9A3}"));
    ok($obj->eq("\x{83E7}", "\x{2F99E}"));
    ok($obj->eq("\x{83EF}", "\x{FAB4}"));
    ok($obj->eq("\x{83F1}", "\x{F958}"));
    ok($obj->eq("\x{843D}", "\x{F918}"));
    ok($obj->eq("\x{8449}", "\x{F96E}"));
    ok($obj->eq("\x{8457}", "\x{FA5F}"));
    ok($obj->eq("\x{8457}", "\x{2F99F}"));
    ok($obj->eq("\x{84EE}", "\x{F999}"));
    ok($obj->eq("\x{84F1}", "\x{2F9A8}"));
    ok($obj->eq("\x{84F3}", "\x{2F9A9}"));
    ok($obj->eq("\x{84FC}", "\x{F9C2}"));
    ok($obj->eq("\x{8516}", "\x{2F9AA}"));
    ok($obj->eq("\x{8564}", "\x{2F9AC}"));
    ok($obj->eq("\x{85CD}", "\x{F923}"));
    ok($obj->eq("\x{85FA}", "\x{F9F0}"));
    ok($obj->eq("\x{8606}", "\x{F935}"));
    ok($obj->eq("\x{8612}", "\x{FA20}"));
    ok($obj->eq("\x{862D}", "\x{F91F}"));
    ok($obj->eq("\x{863F}", "\x{F910}"));
    ok($obj->eq("\x{8650}", "\x{2F9B3}"));
    ok($obj->eq("\x{865C}", "\x{F936}"));
    ok($obj->eq("\x{865C}", "\x{2F9B4}"));
    ok($obj->eq("\x{8667}", "\x{2F9B5}"));
    ok($obj->eq("\x{8669}", "\x{2F9B6}"));
    ok($obj->eq("\x{8688}", "\x{2F9B8}"));
    ok($obj->eq("\x{86A9}", "\x{2F9B7}"));
    ok($obj->eq("\x{86E2}", "\x{2F9BA}"));
    ok($obj->eq("\x{870E}", "\x{2F9B9}"));
    ok($obj->eq("\x{8728}", "\x{2F9BC}"));
    ok($obj->eq("\x{876B}", "\x{2F9BD}"));
    ok($obj->eq("\x{8779}", "\x{FAB5}"));
    ok($obj->eq("\x{8779}", "\x{2F9BB}"));
    ok($obj->eq("\x{8786}", "\x{2F9BE}"));
    ok($obj->eq("\x{87BA}", "\x{F911}"));
    ok($obj->eq("\x{87E1}", "\x{2F9C0}"));
    ok($obj->eq("\x{8801}", "\x{2F9C1}"));
    ok($obj->eq("\x{881F}", "\x{F927}"));
    ok($obj->eq("\x{884C}", "\x{FA08}"));
    ok($obj->eq("\x{8860}", "\x{2F9C3}"));
    ok($obj->eq("\x{8863}", "\x{2F9C4}"));
    ok($obj->eq("\x{88C2}", "\x{F9A0}"));
    ok($obj->eq("\x{88CF}", "\x{F9E7}"));
    ok($obj->eq("\x{88D7}", "\x{2F9C6}"));
    ok($obj->eq("\x{88DE}", "\x{2F9C7}"));
    ok($obj->eq("\x{88E1}", "\x{F9E8}"));
    ok($obj->eq("\x{88F8}", "\x{F912}"));
    ok($obj->eq("\x{88FA}", "\x{2F9C9}"));
    ok($obj->eq("\x{8910}", "\x{FA60}"));
    ok($obj->eq("\x{8941}", "\x{FAB6}"));
    ok($obj->eq("\x{8964}", "\x{F924}"));
    ok($obj->eq("\x{8986}", "\x{FAB7}"));
    ok($obj->eq("\x{898B}", "\x{FA0A}"));
    ok($obj->eq("\x{8996}", "\x{FA61}"));
    ok($obj->eq("\x{8996}", "\x{FAB8}"));
    ok($obj->eq("\x{8AA0}", "\x{2F9CF}"));
    ok($obj->eq("\x{8AAA}", "\x{F96F}"));
    ok($obj->eq("\x{8AAA}", "\x{F9A1}"));
    ok($obj->eq("\x{8ABF}", "\x{FAB9}"));
    ok($obj->eq("\x{8ACB}", "\x{FABB}"));
    ok($obj->eq("\x{8AD2}", "\x{F97D}"));
    ok($obj->eq("\x{8AD6}", "\x{F941}"));
    ok($obj->eq("\x{8AED}", "\x{FABE}"));
    ok($obj->eq("\x{8AED}", "\x{2F9D0}"));
    ok($obj->eq("\x{8AF8}", "\x{FA22}"));
    ok($obj->eq("\x{8AF8}", "\x{FABA}"));
    ok($obj->eq("\x{8AFE}", "\x{F95D}"));
    ok($obj->eq("\x{8AFE}", "\x{FABD}"));
    ok($obj->eq("\x{8B01}", "\x{FA62}"));
    ok($obj->eq("\x{8B01}", "\x{FABC}"));
    ok($obj->eq("\x{8B39}", "\x{FA63}"));
    ok($obj->eq("\x{8B39}", "\x{FABF}"));
    ok($obj->eq("\x{8B58}", "\x{F9FC}"));
    ok($obj->eq("\x{8B80}", "\x{F95A}"));
    ok($obj->eq("\x{8B8A}", "\x{FAC0}"));
    ok($obj->eq("\x{8B8A}", "\x{2F9D1}"));
    ok($obj->eq("\x{8C48}", "\x{F900}"));
    ok($obj->eq("\x{8C55}", "\x{2F9D2}"));
    ok($obj->eq("\x{8CAB}", "\x{2F9D4}"));
    ok($obj->eq("\x{8CC1}", "\x{2F9D5}"));
    ok($obj->eq("\x{8CC2}", "\x{F948}"));
    ok($obj->eq("\x{8CC8}", "\x{F903}"));
    ok($obj->eq("\x{8CD3}", "\x{FA64}"));
    ok($obj->eq("\x{8D08}", "\x{FA65}"));
    ok($obj->eq("\x{8D08}", "\x{FAC1}"));
    ok($obj->eq("\x{8D1B}", "\x{2F9D6}"));
    ok($obj->eq("\x{8D77}", "\x{2F9D7}"));
    ok($obj->eq("\x{8DBC}", "\x{2F9DB}"));
    ok($obj->eq("\x{8DCB}", "\x{2F9DA}"));
    ok($obj->eq("\x{8DEF}", "\x{F937}"));
    ok($obj->eq("\x{8DF0}", "\x{2F9DC}"));
    ok($obj->eq("\x{8ECA}", "\x{F902}"));
    ok($obj->eq("\x{8ED4}", "\x{2F9DE}"));
    ok($obj->eq("\x{8F26}", "\x{F998}"));
    ok($obj->eq("\x{8F2A}", "\x{F9D7}"));
    ok($obj->eq("\x{8F38}", "\x{FAC2}"));
    ok($obj->eq("\x{8F38}", "\x{2F9DF}"));
    ok($obj->eq("\x{8F3B}", "\x{FA07}"));
    ok($obj->eq("\x{8F62}", "\x{F98D}"));
    ok($obj->eq("\x{8F9E}", "\x{2F98D}"));
    ok($obj->eq("\x{8FB0}", "\x{F971}"));
    ok($obj->eq("\x{8FB6}", "\x{FA66}"));
    ok($obj->eq("\x{9023}", "\x{F99A}"));
    ok($obj->eq("\x{9038}", "\x{FA25}"));
    ok($obj->eq("\x{9038}", "\x{FA67}"));
    ok($obj->eq("\x{9072}", "\x{FAC3}"));
    ok($obj->eq("\x{907C}", "\x{F9C3}"));
    ok($obj->eq("\x{908F}", "\x{F913}"));
    ok($obj->eq("\x{9094}", "\x{2F9E2}"));
    ok($obj->eq("\x{90CE}", "\x{F92C}"));
    ok($obj->eq("\x{90DE}", "\x{FA2E}"));
    ok($obj->eq("\x{90F1}", "\x{2F9E3}"));
    ok($obj->eq("\x{90FD}", "\x{FA26}"));
    ok($obj->eq("\x{9111}", "\x{2F9E4}"));
    ok($obj->eq("\x{911B}", "\x{2F9E6}"));
    ok($obj->eq("\x{916A}", "\x{F919}"));
    ok($obj->eq("\x{9199}", "\x{FAC4}"));
    ok($obj->eq("\x{91B4}", "\x{F9B7}"));
    ok($obj->eq("\x{91CC}", "\x{F9E9}"));
    ok($obj->eq("\x{91CF}", "\x{F97E}"));
    ok($obj->eq("\x{91D1}", "\x{F90A}"));
    ok($obj->eq("\x{9234}", "\x{F9B1}"));
    ok($obj->eq("\x{9238}", "\x{2F9E7}"));
    ok($obj->eq("\x{9276}", "\x{FAC5}"));
    ok($obj->eq("\x{927C}", "\x{2F9EA}"));
    ok($obj->eq("\x{92D7}", "\x{2F9E8}"));
    ok($obj->eq("\x{92D8}", "\x{2F9E9}"));
    ok($obj->eq("\x{9304}", "\x{F93F}"));
    ok($obj->eq("\x{934A}", "\x{F99B}"));
    ok($obj->eq("\x{93F9}", "\x{2F9EB}"));
    ok($obj->eq("\x{9415}", "\x{2F9EC}"));
    ok($obj->eq("\x{958B}", "\x{2F9EE}"));
    ok($obj->eq("\x{95AD}", "\x{F986}"));
    ok($obj->eq("\x{95B7}", "\x{2F9F0}"));
    ok($obj->eq("\x{962E}", "\x{F9C6}"));
    ok($obj->eq("\x{964B}", "\x{F951}"));
    ok($obj->eq("\x{964D}", "\x{FA09}"));
    ok($obj->eq("\x{9675}", "\x{F959}"));
    ok($obj->eq("\x{9678}", "\x{F9D3}"));
    ok($obj->eq("\x{967C}", "\x{FAC6}"));
    ok($obj->eq("\x{9686}", "\x{F9DC}"));
    ok($obj->eq("\x{96A3}", "\x{F9F1}"));
    ok($obj->eq("\x{96B7}", "\x{FA2F}"));
    ok($obj->eq("\x{96B8}", "\x{F9B8}"));
    ok($obj->eq("\x{96C3}", "\x{2F9F3}"));
    ok($obj->eq("\x{96E2}", "\x{F9EA}"));
    ok($obj->eq("\x{96E3}", "\x{FA68}"));
    ok($obj->eq("\x{96E3}", "\x{FAC7}"));
    ok($obj->eq("\x{96F6}", "\x{F9B2}"));
    ok($obj->eq("\x{96F7}", "\x{F949}"));
    ok($obj->eq("\x{9723}", "\x{2F9F5}"));
    ok($obj->eq("\x{9732}", "\x{F938}"));
    ok($obj->eq("\x{9748}", "\x{F9B3}"));
    ok($obj->eq("\x{9756}", "\x{FA1C}"));
    ok($obj->eq("\x{9756}", "\x{FAC8}"));
    ok($obj->eq("\x{97DB}", "\x{FAC9}"));
    ok($obj->eq("\x{97E0}", "\x{2F9FA}"));
    ok($obj->eq("\x{97FF}", "\x{FA69}"));
    ok($obj->eq("\x{97FF}", "\x{FACA}"));
    ok($obj->eq("\x{980B}", "\x{FACB}"));
    ok($obj->eq("\x{980B}", "\x{2F9FE}"));
    ok($obj->eq("\x{980B}", "\x{2F9FF}"));
    ok($obj->eq("\x{9818}", "\x{F9B4}"));
    ok($obj->eq("\x{9829}", "\x{2FA00}"));
    ok($obj->eq("\x{983B}", "\x{FA6A}"));
    ok($obj->eq("\x{983B}", "\x{FACC}"));
    ok($obj->eq("\x{985E}", "\x{F9D0}"));
    ok($obj->eq("\x{98E2}", "\x{2FA02}"));
    ok($obj->eq("\x{98EF}", "\x{FA2A}"));
    ok($obj->eq("\x{98FC}", "\x{FA2B}"));
    ok($obj->eq("\x{9928}", "\x{FA2C}"));
    ok($obj->eq("\x{9929}", "\x{2FA04}"));
    ok($obj->eq("\x{99A7}", "\x{2FA05}"));
    ok($obj->eq("\x{99C2}", "\x{2FA06}"));
    ok($obj->eq("\x{99F1}", "\x{F91A}"));
    ok($obj->eq("\x{99FE}", "\x{2FA07}"));
    ok($obj->eq("\x{9A6A}", "\x{F987}"));
    ok($obj->eq("\x{9B12}", "\x{FACD}"));
    ok($obj->eq("\x{9B12}", "\x{2FA0A}"));
    ok($obj->eq("\x{9B6F}", "\x{F939}"));
    ok($obj->eq("\x{9C40}", "\x{2FA0B}"));
    ok($obj->eq("\x{9C57}", "\x{F9F2}"));
    ok($obj->eq("\x{9CFD}", "\x{2FA0C}"));
    ok($obj->eq("\x{9D67}", "\x{2FA0F}"));
    ok($obj->eq("\x{9DB4}", "\x{FA2D}"));
    ok($obj->eq("\x{9DFA}", "\x{F93A}"));
    ok($obj->eq("\x{9E1E}", "\x{F920}"));
    ok($obj->eq("\x{9E7F}", "\x{F940}"));
    ok($obj->eq("\x{9E97}", "\x{F988}"));
    ok($obj->eq("\x{9E9F}", "\x{F9F3}"));
    ok($obj->eq("\x{9EBB}", "\x{2FA15}"));
    ok($obj->eq("\x{9ECE}", "\x{F989}"));
    ok($obj->eq("\x{9EF9}", "\x{2FA17}"));
    ok($obj->eq("\x{9EFE}", "\x{2FA18}"));
    ok($obj->eq("\x{9F05}", "\x{2FA19}"));
    ok($obj->eq("\x{9F0F}", "\x{2FA1A}"));
    ok($obj->eq("\x{9F16}", "\x{2FA1B}"));
    ok($obj->eq("\x{9F3B}", "\x{2FA1C}"));
    ok($obj->eq("\x{9F43}", "\x{FAD8}"));
    ok($obj->eq("\x{9F8D}", "\x{F9C4}"));
    ok($obj->eq("\x{9F8E}", "\x{FAD9}"));
    ok($obj->eq("\x{9F9C}", "\x{F907}"));
    ok($obj->eq("\x{9F9C}", "\x{F908}"));
    ok($obj->eq("\x{9F9C}", "\x{FACE}"));
    ok($obj->eq("\x{349E}", "\x{2F80C}"));
    ok($obj->eq("\x{34B9}", "\x{2F813}"));
    ok($obj->eq("\x{34BB}", "\x{2F9CA}"));
    ok($obj->eq("\x{34DF}", "\x{2F81F}"));
    ok($obj->eq("\x{3515}", "\x{2F824}"));
    ok($obj->eq("\x{36EE}", "\x{2F867}"));
    ok($obj->eq("\x{36FC}", "\x{2F868}"));
    ok($obj->eq("\x{3781}", "\x{2F876}"));
    ok($obj->eq("\x{382F}", "\x{2F883}"));
    ok($obj->eq("\x{3862}", "\x{2F888}"));
    ok($obj->eq("\x{387C}", "\x{2F88A}"));
    ok($obj->eq("\x{38C7}", "\x{2F896}"));
    ok($obj->eq("\x{38E3}", "\x{2F89B}"));
    ok($obj->eq("\x{391C}", "\x{2F8A2}"));
    ok($obj->eq("\x{393A}", "\x{2F8A1}"));
    ok($obj->eq("\x{3A2E}", "\x{2F8C2}"));
    ok($obj->eq("\x{3A6C}", "\x{2F8C7}"));
    ok($obj->eq("\x{3AE4}", "\x{2F8D1}"));
    ok($obj->eq("\x{3B08}", "\x{2F8D0}"));
    ok($obj->eq("\x{3B19}", "\x{2F8CE}"));
    ok($obj->eq("\x{3B49}", "\x{2F8DE}"));
    ok($obj->eq("\x{3B9D}", "\x{FAD2}"));
    ok($obj->eq("\x{3B9D}", "\x{2F8E7}"));
    ok($obj->eq("\x{3C18}", "\x{2F8EE}"));
    ok($obj->eq("\x{3C4E}", "\x{2F8F2}"));
    ok($obj->eq("\x{3D33}", "\x{2F90A}"));
    ok($obj->eq("\x{3D96}", "\x{2F916}"));
    ok($obj->eq("\x{3EAC}", "\x{2F92A}"));
    ok($obj->eq("\x{3EB8}", "\x{2F92C}"));
    ok($obj->eq("\x{3EB8}", "\x{2F92D}"));
    ok($obj->eq("\x{3F1B}", "\x{2F933}"));
    ok($obj->eq("\x{3FFC}", "\x{2F93E}"));
    ok($obj->eq("\x{4008}", "\x{2F93F}"));
    ok($obj->eq("\x{4018}", "\x{FAD3}"));
    ok($obj->eq("\x{4039}", "\x{FAD4}"));
    ok($obj->eq("\x{4039}", "\x{2F949}"));
    ok($obj->eq("\x{4046}", "\x{2F94B}"));
    ok($obj->eq("\x{4096}", "\x{2F94C}"));
    ok($obj->eq("\x{40E3}", "\x{2F951}"));
    ok($obj->eq("\x{412F}", "\x{2F958}"));
    ok($obj->eq("\x{4202}", "\x{2F960}"));
    ok($obj->eq("\x{4227}", "\x{2F964}"));
    ok($obj->eq("\x{42A0}", "\x{2F967}"));
    ok($obj->eq("\x{4301}", "\x{2F96D}"));
    ok($obj->eq("\x{4334}", "\x{2F971}"));
    ok($obj->eq("\x{4359}", "\x{2F974}"));
    ok($obj->eq("\x{43D5}", "\x{2F981}"));
    ok($obj->eq("\x{43D9}", "\x{2F8D7}"));
    ok($obj->eq("\x{440B}", "\x{2F984}"));
    ok($obj->eq("\x{446B}", "\x{2F98E}"));
    ok($obj->eq("\x{452B}", "\x{2F9A7}"));
    ok($obj->eq("\x{455D}", "\x{2F9AE}"));
    ok($obj->eq("\x{4561}", "\x{2F9AF}"));
    ok($obj->eq("\x{456B}", "\x{2F9B2}"));
    ok($obj->eq("\x{45D7}", "\x{2F9BF}"));
    ok($obj->eq("\x{45F9}", "\x{2F9C2}"));
    ok($obj->eq("\x{4635}", "\x{2F9C8}"));
    ok($obj->eq("\x{46BE}", "\x{2F9CD}"));
    ok($obj->eq("\x{46C7}", "\x{2F9CE}"));
    ok($obj->eq("\x{4995}", "\x{2F9EF}"));
    ok($obj->eq("\x{49E6}", "\x{2F9F2}"));
    ok($obj->eq("\x{4A6E}", "\x{2F9F8}"));
    ok($obj->eq("\x{4A76}", "\x{2F9F9}"));
    ok($obj->eq("\x{4AB2}", "\x{2F9FC}"));
    ok($obj->eq("\x{4B33}", "\x{2FA03}"));
    ok($obj->eq("\x{4BCE}", "\x{2FA08}"));
    ok($obj->eq("\x{4CCE}", "\x{2FA0D}"));
    ok($obj->eq("\x{4CED}", "\x{2FA0E}"));
    ok($obj->eq("\x{4CF8}", "\x{2FA11}"));
    ok($obj->eq("\x{4D56}", "\x{2FA16}"));
    ok($obj->eq("\x{20122}", "\x{2F803}"));
    ok($obj->eq("\x{2051C}", "\x{2F812}"));
    ok($obj->eq("\x{20525}", "\x{2F91B}"));
    ok($obj->eq("\x{2054B}", "\x{2F816}"));
    ok($obj->eq("\x{2063A}", "\x{2F80D}"));
    ok($obj->eq("\x{20804}", "\x{2F9D9}"));
    ok($obj->eq("\x{208DE}", "\x{2F9DD}"));
    ok($obj->eq("\x{20A2C}", "\x{2F834}"));
    ok($obj->eq("\x{20B63}", "\x{2F838}"));
    ok($obj->eq("\x{214E4}", "\x{2F859}"));
    ok($obj->eq("\x{216A8}", "\x{2F860}"));
    ok($obj->eq("\x{216EA}", "\x{2F861}"));
    ok($obj->eq("\x{219C8}", "\x{2F86C}"));
    ok($obj->eq("\x{21B18}", "\x{2F871}"));
    ok($obj->eq("\x{21D0B}", "\x{2F8F8}"));
    ok($obj->eq("\x{21DE4}", "\x{2F87B}"));
    ok($obj->eq("\x{21DE6}", "\x{2F87D}"));
    ok($obj->eq("\x{22183}", "\x{2F889}"));
    ok($obj->eq("\x{2219F}", "\x{2F939}"));
    ok($obj->eq("\x{22331}", "\x{2F891}"));
    ok($obj->eq("\x{22331}", "\x{2F892}"));
    ok($obj->eq("\x{226D4}", "\x{2F8A4}"));
    ok($obj->eq("\x{22844}", "\x{FAD0}"));
    ok($obj->eq("\x{2284A}", "\x{FACF}"));
    ok($obj->eq("\x{22B0C}", "\x{2F8B8}"));
    ok($obj->eq("\x{22BF1}", "\x{2F8BE}"));
    ok($obj->eq("\x{2300A}", "\x{2F8CA}"));
    ok($obj->eq("\x{232B8}", "\x{2F897}"));
    ok($obj->eq("\x{2335F}", "\x{2F980}"));
    ok($obj->eq("\x{23393}", "\x{2F989}"));
    ok($obj->eq("\x{2339C}", "\x{2F98A}"));
    ok($obj->eq("\x{233C3}", "\x{2F8DD}"));
    ok($obj->eq("\x{233D5}", "\x{FAD1}"));
    ok($obj->eq("\x{2346D}", "\x{2F8E3}"));
    ok($obj->eq("\x{236A3}", "\x{2F8EC}"));
    ok($obj->eq("\x{238A7}", "\x{2F8F0}"));
    ok($obj->eq("\x{23A8D}", "\x{2F8F7}"));
    ok($obj->eq("\x{23AFA}", "\x{2F8F9}"));
    ok($obj->eq("\x{23CBC}", "\x{2F8FB}"));
    ok($obj->eq("\x{23D1E}", "\x{2F906}"));
    ok($obj->eq("\x{23ED1}", "\x{2F90D}"));
    ok($obj->eq("\x{23F5E}", "\x{2F910}"));
    ok($obj->eq("\x{23F8E}", "\x{2F911}"));
    ok($obj->eq("\x{24263}", "\x{2F91D}"));
    ok($obj->eq("\x{242EE}", "\x{FA6C}"));
    ok($obj->eq("\x{243AB}", "\x{2F91F}"));
    ok($obj->eq("\x{24608}", "\x{2F923}"));
    ok($obj->eq("\x{24735}", "\x{2F926}"));
    ok($obj->eq("\x{24814}", "\x{2F927}"));
    ok($obj->eq("\x{24C36}", "\x{2F935}"));
    ok($obj->eq("\x{24C92}", "\x{2F937}"));
    ok($obj->eq("\x{24FA1}", "\x{2F93B}"));
    ok($obj->eq("\x{24FB8}", "\x{2F93C}"));
    ok($obj->eq("\x{25044}", "\x{2F93D}"));
    ok($obj->eq("\x{250F2}", "\x{2F942}"));
    ok($obj->eq("\x{250F3}", "\x{2F941}"));
    ok($obj->eq("\x{25119}", "\x{2F943}"));
    ok($obj->eq("\x{25133}", "\x{2F944}"));
    ok($obj->eq("\x{25249}", "\x{FAD5}"));
    ok($obj->eq("\x{2541D}", "\x{2F94D}"));
    ok($obj->eq("\x{25626}", "\x{2F952}"));
    ok($obj->eq("\x{2569A}", "\x{2F954}"));
    ok($obj->eq("\x{256C5}", "\x{2F955}"));
    ok($obj->eq("\x{2597C}", "\x{2F95C}"));
    ok($obj->eq("\x{25AA7}", "\x{2F95D}"));
    ok($obj->eq("\x{25AA7}", "\x{2F95E}"));
    ok($obj->eq("\x{25BAB}", "\x{2F961}"));
    ok($obj->eq("\x{25C80}", "\x{2F965}"));
    ok($obj->eq("\x{25CD0}", "\x{FAD6}"));
    ok($obj->eq("\x{25F86}", "\x{2F96B}"));
    ok($obj->eq("\x{261DA}", "\x{2F898}"));
    ok($obj->eq("\x{26228}", "\x{2F972}"));
    ok($obj->eq("\x{26247}", "\x{2F973}"));
    ok($obj->eq("\x{262D9}", "\x{2F975}"));
    ok($obj->eq("\x{2633E}", "\x{2F977}"));
    ok($obj->eq("\x{264DA}", "\x{2F97B}"));
    ok($obj->eq("\x{26523}", "\x{2F97C}"));
    ok($obj->eq("\x{265A8}", "\x{2F97E}"));
    ok($obj->eq("\x{267A7}", "\x{2F987}"));
    ok($obj->eq("\x{267B5}", "\x{2F988}"));
    ok($obj->eq("\x{26B3C}", "\x{2F997}"));
    ok($obj->eq("\x{26C36}", "\x{2F9A4}"));
    ok($obj->eq("\x{26CD5}", "\x{2F9A6}"));
    ok($obj->eq("\x{26D6B}", "\x{2F9A5}"));
    ok($obj->eq("\x{26F2C}", "\x{2F9AD}"));
    ok($obj->eq("\x{26FB1}", "\x{2F9B0}"));
    ok($obj->eq("\x{270D2}", "\x{2F9B1}"));
    ok($obj->eq("\x{273CA}", "\x{2F9AB}"));
    ok($obj->eq("\x{27667}", "\x{2F9C5}"));
    ok($obj->eq("\x{278AE}", "\x{2F9CB}"));
    ok($obj->eq("\x{27966}", "\x{2F9CC}"));
    ok($obj->eq("\x{27CA8}", "\x{2F9D3}"));
    ok($obj->eq("\x{27ED3}", "\x{FAD7}"));
    ok($obj->eq("\x{27F2F}", "\x{2F9D8}"));
    ok($obj->eq("\x{285D2}", "\x{2F9E0}"));
    ok($obj->eq("\x{285ED}", "\x{2F9E1}"));
    ok($obj->eq("\x{2872E}", "\x{2F9E5}"));
    ok($obj->eq("\x{28BFA}", "\x{2F9ED}"));
    ok($obj->eq("\x{28D77}", "\x{2F9F1}"));
    ok($obj->eq("\x{29145}", "\x{2F9F6}"));
    ok($obj->eq("\x{291DF}", "\x{2F81C}"));
    ok($obj->eq("\x{2921A}", "\x{2F9F7}"));
    ok($obj->eq("\x{2940A}", "\x{2F9FB}"));
    ok($obj->eq("\x{29496}", "\x{2F9FD}"));
    ok($obj->eq("\x{295B6}", "\x{2FA01}"));
    ok($obj->eq("\x{29B30}", "\x{2FA09}"));
    ok($obj->eq("\x{2A0CE}", "\x{2FA10}"));
    ok($obj->eq("\x{2A105}", "\x{2FA12}"));
    ok($obj->eq("\x{2A20E}", "\x{2FA13}"));
    ok($obj->eq("\x{2A291}", "\x{2FA14}"));
    ok($obj->eq("\x{2A392}", "\x{2F88F}"));
    ok($obj->eq("\x{2A600}", "\x{2FA1D}"));
}
