use strict;
BEGIN {
	require 5.008001;
}
use ExtUtils::MakeMaker;

WriteMakefile1(
	META_MERGE => {
		resources => {
			repository => 'http://svn.ali.as/cpan/trunk/Config-Tiny',
		},
	},
	BUILD_REQUIRES => {
		# Skip on Windows to avoid breaking ActivePerl PPMs
		# 0.47 means 5.6.2 or newer, which everyone on Win32 has.
		($^O eq 'MSWin32' ? () : ('Test::More' => '0.47')),
	},
	NAME         => 'Config::Tiny',
	ABSTRACT     => 'Read/Write .ini style files with as little code as possible',
	VERSION_FROM => 'lib/Config/Tiny.pm',
	PREREQ_PM    =>
	{
		'File::Spec' => 3.40,
		'File::Temp' => 0.2301,
		'Path::Tiny' => 0.025,
		'perl'       => '5.8.1', # For the utf stuff.
		'strict'     => 0,
		'UNIVERSAL'  => 0,
		'utf8'       => 0,
		'vars'       => 0,
	},
	AUTHOR  => 'Adam Kennedy <adamk@cpan.org>',
	LICENSE => 'perl',
);

# Written by Alexandr Ciornii, version 0.20. Added by eumm-upgrade.
sub WriteMakefile1 {
	my %params = @_;
	my $eumm_version = $ExtUtils::MakeMaker::VERSION;
	$eumm_version = eval $eumm_version;
	die "License not specified" if not exists $params{LICENSE};
	if ($params{BUILD_REQUIRES} and $eumm_version < 6.5503) {
		#EUMM 6.5502 has problems with BUILD_REQUIRES
		$params{PREREQ_PM}={ %{$params{PREREQ_PM} || {}} , %{$params{BUILD_REQUIRES}} };
		delete $params{BUILD_REQUIRES};
	}
	delete $params{MIN_PERL_VERSION} if $eumm_version < 6.48;
	delete $params{META_MERGE} if $eumm_version < 6.46;
	delete $params{LICENSE} if $eumm_version < 6.31;
	delete $params{AUTHOR} if $] < 5.005;

	WriteMakefile(%params);
}
