#!perl -T
use 5.006;
use strict;
use warnings FATAL => 'all';
use Test::More;

use Crypt::RS14_PP;

# Test vectors supplied by referenced algorithm description
my %vectors = (
    'ABC'     => [0x77, 0x9a, 0x8e, 0x01, 0xf9, 0xe9, 0xcb, 0xc0],
    'spam'    => [0xf0, 0x60, 0x9a, 0x1d, 0xf1, 0x43, 0xce, 0xbf],
    'arcfour' => [0x1a, 0xfa, 0x8b, 0x5e, 0xe3, 0x37, 0xdb, 0xc7],
);

my $nv = keys %vectors;
plan tests => 2 * $nv;

diag( "Testing cipher stream: Crypt::RS14_PP $Crypt::RS14_PP::VERSION, Perl $], $^X" );
diag( 'There will be warnings about keys being too short. The test vectors' );
diag( 'supplied by the algorithm creators have very short keys.' );

while (my ($key, $bytes) = each %vectors)
{
    my $c = new_ok('Crypt::RS14_PP', [$key]);
    is_deeply([ map $c->_cipher(), @$bytes ], $bytes)
        or diag explain $bytes;
}
