/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.osgish;

import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.aries.jmx.Activator;
import org.jmx4perl.osgi.J4pActivator;
import org.jmx4perl.osgish.OsgishService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgishActivator
implements BundleActivator {
    J4pActivator j4pActivator = new J4pActivator();
    Activator ariesActivator = new Activator();
    private ObjectName serviceMBeanName;
    private MBeanServer mBeanServer;

    public void start(BundleContext pContext) throws Exception {
        this.j4pActivator.start(pContext);
        this.registerMBeanServerAsService(pContext);
        this.registerOsgiServiceMBean(pContext);
        this.ariesActivator.start(pContext);
    }

    public void stop(BundleContext pContext) throws Exception {
        this.ariesActivator.stop(pContext);
        this.unregisterOsgiServiceMBean();
        this.j4pActivator.stop(pContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMBeanServerAsService(BundleContext pContext) {
        ServiceReference mBeanServerRef = pContext.getServiceReference(MBeanServer.class.getCanonicalName());
        if (mBeanServerRef == null) {
            this.mBeanServer = this.getMBeanServer();
            pContext.registerService(MBeanServer.class.getCanonicalName(), (Object)this.mBeanServer, null);
        } else {
            boolean serviceFound = true;
            try {
                this.mBeanServer = (MBeanServer)pContext.getService(mBeanServerRef);
                if (this.mBeanServer == null) {
                    this.mBeanServer = this.getMBeanServer();
                    pContext.registerService(MBeanServer.class.getCanonicalName(), (Object)this.mBeanServer, null);
                    serviceFound = false;
                }
            }
            finally {
                if (mBeanServerRef != null && serviceFound) {
                    pContext.ungetService(mBeanServerRef);
                }
            }
        }
    }

    private void registerOsgiServiceMBean(BundleContext pBundleContext) throws MBeanRegistrationException, InstanceAlreadyExistsException, NotCompliantMBeanException {
        OsgishService service = new OsgishService(pBundleContext);
        this.serviceMBeanName = this.mBeanServer.registerMBean(service, null).getObjectName();
        System.out.println(">>>>>>>>>>> osgish: Registering " + this.serviceMBeanName + " to " + this.mBeanServer);
    }

    private void unregisterOsgiServiceMBean() throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mBeanServer != null) {
            this.mBeanServer.unregisterMBean(this.serviceMBeanName);
            this.mBeanServer = null;
            System.out.println(">>>>>>>>>>> osgish: Un-Registering " + this.serviceMBeanName + " from " + this.mBeanServer);
        }
    }

    private MBeanServer getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }
}

