/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.handler;

import java.util.HashMap;
import java.util.Map;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.config.Restrictor;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.jmx4perl.handler.ExecHandler;
import org.jmx4perl.handler.JsonRequestHandler;
import org.jmx4perl.handler.ListHandler;
import org.jmx4perl.handler.ReadHandler;
import org.jmx4perl.handler.SearchHandler;
import org.jmx4perl.handler.VersionHandler;
import org.jmx4perl.handler.WriteHandler;

public class RequestHandlerManager {
    private static final Map<JmxRequest.Type, JsonRequestHandler> REQUEST_HANDLER_MAP = new HashMap<JmxRequest.Type, JsonRequestHandler>();

    public RequestHandlerManager(ObjectToJsonConverter pObjectToJsonConverter, StringToObjectConverter pStringToObjectConverter, Restrictor pRestrictor) {
        this.registerRequestHandlers(pObjectToJsonConverter, pStringToObjectConverter, pRestrictor);
    }

    protected void registerRequestHandlers(ObjectToJsonConverter objectToJsonConverter, StringToObjectConverter stringToObjectConverter, Restrictor restrictor) {
        JsonRequestHandler[] handlers;
        for (JsonRequestHandler handler : handlers = new JsonRequestHandler[]{new ReadHandler(restrictor), new WriteHandler(restrictor, objectToJsonConverter), new ExecHandler(restrictor, stringToObjectConverter), new ListHandler(restrictor), new VersionHandler(restrictor), new SearchHandler(restrictor)}) {
            REQUEST_HANDLER_MAP.put(handler.getType(), handler);
        }
    }

    public JsonRequestHandler getRequestHandler(JmxRequest.Type pType) {
        JsonRequestHandler handler = REQUEST_HANDLER_MAP.get((Object)pType);
        if (handler == null) {
            throw new UnsupportedOperationException("Unsupported operation '" + (Object)((Object)pType) + "'");
        }
        return handler;
    }
}

