/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jmx4perl.JmxRequest;
import org.jmx4perl.config.Restrictor;
import org.jmx4perl.handler.JsonRequestHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListHandler
extends JsonRequestHandler {
    @Override
    public JmxRequest.Type getType() {
        return JmxRequest.Type.LIST;
    }

    public ListHandler(Restrictor pRestrictor) {
        super(pRestrictor);
    }

    @Override
    public boolean handleAllServersAtOnce() {
        return true;
    }

    @Override
    public Object doHandleRequest(Set<MBeanServerConnection> pServers, JmxRequest request) throws InstanceNotFoundException, IOException {
        try {
            HashMap ret = new HashMap();
            for (MBeanServerConnection server : pServers) {
                Iterator<ObjectName> i$ = server.queryNames(null, null).iterator();
                while (i$.hasNext()) {
                    ObjectName nameObject;
                    ObjectName name = nameObject = i$.next();
                    Map mBeansMap = this.getOrCreateMap(ret, name.getDomain());
                    Map mBeanMap = this.getOrCreateMap(mBeansMap, name.getCanonicalKeyPropertyListString());
                    try {
                        MBeanInfo mBeanInfo = server.getMBeanInfo(name);
                        this.addAttributes(mBeanMap, mBeanInfo);
                        this.addOperations(mBeanMap, mBeanInfo);
                        if (mBeanMap.size() != 0) continue;
                        mBeansMap.remove(name.getCanonicalKeyPropertyListString());
                        if (mBeansMap.size() != 0) continue;
                        ret.remove(name.getDomain());
                    }
                    catch (IOException exp) {
                        mBeanMap.put("error", exp);
                    }
                }
            }
            return ret;
        }
        catch (ReflectionException e) {
            throw new IllegalStateException("Internal error while retrieving list: " + e, e);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Internal error while retrieving list: " + e, e);
        }
    }

    private void addOperations(Map pMBeanMap, MBeanInfo pMBeanInfo) {
        HashMap opMap = new HashMap();
        for (MBeanOperationInfo opInfo : pMBeanInfo.getOperations()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            ArrayList argList = new ArrayList();
            for (MBeanParameterInfo paramInfo : opInfo.getSignature()) {
                HashMap<String, String> args = new HashMap<String, String>();
                args.put("desc", paramInfo.getDescription());
                args.put("name", paramInfo.getName());
                args.put("type", paramInfo.getType());
                argList.add(args);
            }
            map.put("args", argList);
            map.put("ret", opInfo.getReturnType());
            map.put("desc", opInfo.getDescription());
            opMap.put(opInfo.getName(), map);
        }
        if (opMap.size() > 0) {
            pMBeanMap.put("op", opMap);
        }
    }

    private void addAttributes(Map pMBeanMap, MBeanInfo pMBeanInfo) {
        HashMap attrMap = new HashMap();
        for (MBeanAttributeInfo attrInfo : pMBeanInfo.getAttributes()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", attrInfo.getType());
            map.put("desc", attrInfo.getDescription());
            map.put("rw", attrInfo.isWritable() && attrInfo.isReadable());
            attrMap.put(attrInfo.getName(), map);
        }
        if (attrMap.size() > 0) {
            pMBeanMap.put("attr", attrMap);
        }
    }

    private Map getOrCreateMap(Map pMap, String pKey) {
        HashMap nMap = (HashMap)pMap.get(pKey);
        if (nMap == null) {
            nMap = new HashMap();
            pMap.put(pKey, nMap);
        }
        return nMap;
    }

    @Override
    public Object doHandleRequest(MBeanServerConnection server, JmxRequest request) throws InstanceNotFoundException, AttributeNotFoundException, ReflectionException, MBeanException {
        return null;
    }
}

