/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.converter.json;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;
import javax.management.AttributeNotFoundException;
import org.jmx4perl.converter.StringToObjectConverter;
import org.jmx4perl.converter.json.ObjectToJsonConverter;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayHandler
implements ObjectToJsonConverter.Handler {
    @Override
    public Class getType() {
        return null;
    }

    @Override
    public Object extractObject(ObjectToJsonConverter pConverter, Object pValue, Stack<String> pExtraArgs, boolean jsonify) throws AttributeNotFoundException {
        int length = pConverter.getCollectionLength(Array.getLength(pValue));
        if (!pExtraArgs.isEmpty()) {
            Object obj = Array.get(pValue, Integer.parseInt(pExtraArgs.pop()));
            return pConverter.extractObject(obj, pExtraArgs, jsonify);
        }
        if (jsonify) {
            JSONArray ret = new JSONArray();
            for (int i = 0; i < length; ++i) {
                Object obj = Array.get(pValue, i);
                ret.add(pConverter.extractObject(obj, pExtraArgs, jsonify));
            }
            return ret;
        }
        return pValue;
    }

    @Override
    public Object setObjectValue(StringToObjectConverter pConverter, Object pInner, String pAttribute, String pValueS) throws IllegalAccessException, InvocationTargetException {
        int idx;
        Class<?> clazz = pInner.getClass();
        if (!clazz.isArray()) {
            throw new IllegalArgumentException("Not an array to set a value, but " + clazz + ". (index = " + pAttribute + ", value = " + pValueS + ")");
        }
        try {
            idx = Integer.parseInt(pAttribute);
        }
        catch (NumberFormatException exp) {
            throw new IllegalArgumentException("Non-numeric index for accessing array " + pInner + ". (index = " + pAttribute + ", value to set = " + pValueS + ")", exp);
        }
        Class<?> type = clazz.getComponentType();
        Object value = pConverter.convertFromString(type.getName(), pValueS);
        Object oldValue = Array.get(pInner, idx);
        Array.set(pInner, idx, value);
        return oldValue;
    }
}

