/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl.config;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.jmx4perl.backend.MBeanServerHandler;
import org.jmx4perl.config.ConfigMBean;
import org.jmx4perl.config.DebugStore;
import org.jmx4perl.history.HistoryKey;
import org.jmx4perl.history.HistoryStore;

public class Config
implements ConfigMBean,
MBeanRegistration {
    private HistoryStore historyStore;
    private DebugStore debugStore;
    private MBeanServerHandler mBeanServerHandler;

    public Config(HistoryStore pHistoryStore, DebugStore pDebugStore, MBeanServerHandler pMBeanServerHandler) {
        this.historyStore = pHistoryStore;
        this.debugStore = pDebugStore;
        this.mBeanServerHandler = pMBeanServerHandler;
    }

    public void setHistoryEntriesForAttribute(String pMBean, String pAttribute, String pPath, String pTarget, int pMaxEntries) {
        HistoryKey key = new HistoryKey(pMBean, pAttribute, pPath, pTarget);
        this.historyStore.configure(key, pMaxEntries);
    }

    public void setHistoryEntriesForOperation(String pMBean, String pOperation, String pTarget, int pMaxEntries) {
        HistoryKey key = new HistoryKey(pMBean, pOperation, pTarget);
        this.historyStore.configure(key, pMaxEntries);
    }

    public void resetHistoryEntries() {
        this.historyStore.reset();
    }

    public String debugInfo() {
        return this.debugStore.debugInfo();
    }

    public String mBeanServerInfo() {
        StringBuffer ret = new StringBuffer();
        Set<MBeanServer> mBeanServers = this.mBeanServerHandler.getMBeanServers();
        ret.append("Found ").append(mBeanServers.size()).append(" MBeanServers\n");
        for (MBeanServer s : mBeanServers) {
            ret.append("    ").append("++ ").append(s.toString()).append(": default domain = ").append(s.getDefaultDomain()).append(", ").append(s.getMBeanCount()).append(" MBeans\n");
            ret.append("        Domains:\n");
            boolean javaLangFound = false;
            for (String d : s.getDomains()) {
                if ("java.lang".equals(d)) {
                    javaLangFound = true;
                }
                this.appendDomainInfo(ret, s, d);
            }
            if (javaLangFound) continue;
            this.appendDomainInfo(ret, s, "java.lang");
        }
        ret.append("\n");
        ret.append("Platform MBeanServer: ").append(ManagementFactory.getPlatformMBeanServer()).append("\n");
        return ret.toString();
    }

    private void appendDomainInfo(StringBuffer pRet, MBeanServer pServer, String pDomain) {
        try {
            pRet.append("         == ").append(pDomain).append("\n");
            Set<ObjectInstance> beans = pServer.queryMBeans(new ObjectName(pDomain + ":*"), null);
            for (ObjectInstance o : beans) {
                String n = o.getObjectName().getCanonicalKeyPropertyListString();
                pRet.append("              ").append(n).append("\n");
            }
        }
        catch (MalformedObjectNameException e) {
            pRet.append("              INTERNAL ERROR: ").append(e).append("\n");
        }
    }

    public void resetDebugInfo() {
        this.debugStore.resetDebugInfo();
    }

    public int getHistoryMaxEntries() {
        return this.historyStore.getGlobalMaxEntries();
    }

    public void setHistoryMaxEntries(int pLimit) {
        this.historyStore.setGlobalMaxEntries(pLimit);
    }

    public boolean isDebug() {
        return this.debugStore.isDebug();
    }

    public void setDebug(boolean pSwitch) {
        this.debugStore.setDebug(pSwitch);
    }

    public int getMaxDebugEntries() {
        return this.debugStore.getMaxDebugEntries();
    }

    public void setMaxDebugEntries(int pNumber) {
        this.debugStore.setMaxDebugEntries(pNumber);
    }

    public int getHistorySize() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        ObjectOutputStream oOut = new ObjectOutputStream(bOut);
        oOut.writeObject(this.historyStore);
        return bOut.size();
    }

    public ObjectName preRegister(MBeanServer pMBeanServer, ObjectName pObjectName) throws MalformedObjectNameException {
        return new ObjectName("jmx4perl:type=Config");
    }

    public void postRegister(Boolean pBoolean) {
    }

    public void preDeregister() {
    }

    public void postDeregister() {
    }
}

