/*
 * Decompiled with CFR 0.152.
 */
package org.jmx4perl;

import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.MalformedObjectNameException;
import org.jmx4perl.JmxRequest;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JmxRequestFactory {
    private static final Pattern SLASH_ESCAPE_PATTERN = Pattern.compile("^-*\\+?$");
    private static final Map<JmxRequest.Type, Processor> PROCESSOR_MAP = new HashMap<JmxRequest.Type, Processor>();

    private JmxRequestFactory() {
    }

    static JmxRequest createRequestFromUrl(String pPathInfo, Map pParameterMap) {
        JmxRequest request = null;
        try {
            if (pPathInfo != null && pPathInfo.length() > 0) {
                Stack<String> elements = JmxRequestFactory.extractElementsFromPath(pPathInfo);
                JmxRequest.Type type = JmxRequestFactory.extractType(elements.pop());
                Processor processor = PROCESSOR_MAP.get((Object)type);
                if (processor == null) {
                    throw new UnsupportedOperationException("Type " + (Object)((Object)type) + " is not supported (yet)");
                }
                request = processor.process(elements);
                request.setExtraArgs(JmxRequestFactory.toList(elements));
                JmxRequestFactory.extractParameters(request, pParameterMap);
            }
            return request;
        }
        catch (NoSuchElementException exp) {
            throw new IllegalArgumentException("Invalid path info " + pPathInfo, exp);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid object name. " + e.getMessage(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Internal: Illegal encoding for URL conversion: " + e, e);
        }
        catch (EmptyStackException exp) {
            throw new IllegalArgumentException("Invalid arguments in pathinfo " + pPathInfo + (request != null ? " for command " + (Object)((Object)request.getType()) : ""), exp);
        }
    }

    static List<JmxRequest> createRequestsFromInputStream(Reader content) throws MalformedObjectNameException, IOException {
        try {
            JSONParser parser = new JSONParser();
            Object json = parser.parse(content);
            ArrayList<JmxRequest> ret = new ArrayList<JmxRequest>();
            if (json instanceof List) {
                for (Object o : (List)json) {
                    if (!(o instanceof Map)) {
                        throw new IllegalArgumentException("Not a request within the list for the " + content + ". Expected map, but found: " + o);
                    }
                    ret.add(new JmxRequest((Map)o));
                }
            } else if (json instanceof Map) {
                ret.add(new JmxRequest((Map)json));
            } else {
                throw new IllegalArgumentException("Invalid JSON Request " + content);
            }
            return ret;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Invalid JSON request " + content, e);
        }
    }

    private static Stack<String> extractElementsFromPath(String path) throws UnsupportedEncodingException {
        String[] elements = (path.startsWith("/") ? path.substring(1) : path).split("/+");
        Stack<String> ret = new Stack<String>();
        Stack<String> elementStack = new Stack<String>();
        for (int i = elements.length - 1; i >= 0; --i) {
            elementStack.push(elements[i]);
        }
        JmxRequestFactory.extractElements(ret, elementStack, null);
        if (ret.size() == 0) {
            throw new IllegalArgumentException("No request type given");
        }
        Collections.reverse(ret);
        return ret;
    }

    private static void extractElements(Stack<String> ret, Stack<String> pElementStack, StringBuffer previousBuffer) throws UnsupportedEncodingException {
        if (pElementStack.isEmpty()) {
            if (previousBuffer != null && previousBuffer.length() > 0) {
                ret.push(JmxRequestFactory.decode(previousBuffer.toString()));
            }
            return;
        }
        String element = pElementStack.pop();
        Matcher matcher = SLASH_ESCAPE_PATTERN.matcher(element);
        if (matcher.matches()) {
            if (ret.isEmpty()) {
                return;
            }
            StringBuffer val = previousBuffer == null ? new StringBuffer(ret.pop()) : previousBuffer;
            for (int j = 0; j < element.length(); ++j) {
                val.append("/");
            }
            if (!element.substring(element.length() - 1, element.length()).equals("+")) {
                if (!pElementStack.isEmpty()) {
                    val.append(JmxRequestFactory.decode(pElementStack.pop()));
                }
                JmxRequestFactory.extractElements(ret, pElementStack, val);
                return;
            }
            ret.push(JmxRequestFactory.decode(val.toString()));
            JmxRequestFactory.extractElements(ret, pElementStack, null);
            return;
        }
        if (previousBuffer != null) {
            ret.push(JmxRequestFactory.decode(previousBuffer.toString()));
        }
        ret.push(JmxRequestFactory.decode(element));
        JmxRequestFactory.extractElements(ret, pElementStack, null);
    }

    private static String decode(String s) {
        return s;
    }

    private static JmxRequest.Type extractType(String pTypeS) {
        for (JmxRequest.Type t : JmxRequest.Type.values()) {
            if (!t.getValue().equals(pTypeS)) continue;
            return t;
        }
        throw new IllegalArgumentException("Invalid request type '" + pTypeS + "'");
    }

    private static List<String> toList(Stack<String> pElements) {
        ArrayList<String> p = new ArrayList<String>();
        while (!pElements.isEmpty()) {
            p.add(pElements.pop());
        }
        return p;
    }

    private static void extractParameters(JmxRequest pRequest, Map pParameterMap) {
        if (pParameterMap != null) {
            if (pParameterMap.get("maxDepth") != null) {
                pRequest.setMaxDepth(Integer.parseInt(((String[])pParameterMap.get("maxDepth"))[0]));
            }
            if (pParameterMap.get("maxCollectionSize") != null) {
                pRequest.setMaxCollectionSize(Integer.parseInt(((String[])pParameterMap.get("maxCollectionSize"))[0]));
            }
            if (pParameterMap.get("maxObjects") != null) {
                pRequest.setMaxObjects(Integer.parseInt(((String[])pParameterMap.get("maxObjects"))[0]));
            }
        }
    }

    static {
        PROCESSOR_MAP.put(JmxRequest.Type.READ, new Processor(){

            @Override
            public JmxRequest process(Stack<String> e) throws MalformedObjectNameException {
                JmxRequest req = new JmxRequest(JmxRequest.Type.READ, e.pop());
                req.setAttributeName(e.pop());
                return req;
            }
        });
        PROCESSOR_MAP.put(JmxRequest.Type.WRITE, new Processor(){

            @Override
            public JmxRequest process(Stack<String> e) throws MalformedObjectNameException {
                JmxRequest req = new JmxRequest(JmxRequest.Type.WRITE, e.pop());
                req.setAttributeName(e.pop());
                req.setValue(e.pop());
                return req;
            }
        });
        PROCESSOR_MAP.put(JmxRequest.Type.EXEC, new Processor(){

            @Override
            public JmxRequest process(Stack<String> e) throws MalformedObjectNameException {
                JmxRequest req = new JmxRequest(JmxRequest.Type.EXEC, e.pop());
                req.setOperation(e.pop());
                return req;
            }
        });
        PROCESSOR_MAP.put(JmxRequest.Type.LIST, new Processor(){

            @Override
            public JmxRequest process(Stack<String> e) throws MalformedObjectNameException {
                return new JmxRequest(JmxRequest.Type.LIST);
            }
        });
        PROCESSOR_MAP.put(JmxRequest.Type.VERSION, new Processor(){

            @Override
            public JmxRequest process(Stack<String> e) throws MalformedObjectNameException {
                return new JmxRequest(JmxRequest.Type.VERSION);
            }
        });
        PROCESSOR_MAP.put(JmxRequest.Type.SEARCH, new Processor(){

            @Override
            public JmxRequest process(Stack<String> e) throws MalformedObjectNameException {
                return new JmxRequest(JmxRequest.Type.SEARCH, e.pop());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Processor {
        public JmxRequest process(Stack<String> var1) throws MalformedObjectNameException;
    }
}

