#!/usr/bin/env perl

use strict;
# use warnings; # Use just for development
use constant {
    TRUE  => 1,
    FALSE => 0
};

# We use Time::HiRes for the alarm, and we need fractions of a second.
use Time::HiRes qw(alarm);
use Graphics::Framebuffer;

## Initialize any global variables here

my $device        = '/dev/fb0'; # Change this to your frambuffer device
my $double_buffer = FALSE;      # Make this TRUE, if you have a 16 bit display
my $delay         = 1/20;       # Use smaller numbers for slower machines

our ($PFB,$DFB);

# We will always draw to $DFB

unless ($double_buffer) {
    $DFB = Graphics::Framebuffer->new(
        'FB_DEVICE' => $device,
    );
} else {
    ($PFB,$DFB) = Graphics::Framebuffer->new(
        'FB_DEVICE'     => $device,
        'DOUBLE_BUFFER' => TRUE
    );
}


if ($double_buffer) {
    $PFB->cls('OFF'); # Turn off the cursor with the physical framebuffer
    $SIG{'ALRM'} = \&flip_it;
    alarm($delay);
}

## Do your stuff here ########################################################


##############################################################################

alarm(0);
$PFB->cls('ON');
exit(0);

sub flip_it {
    alarm(0);
    $PFB->blit_flip($DFB);
    alarm($delay);
}

__END__

