#!/usr/bin/perl

use 5.010;
use Module::Build;

my $build = Module::Build->new(
    'module_name'        => 'Graphics::Framebuffer',
    'license'            => 'perl',
    'configure_requires' => {
        'Module::Build' => '>= 0.30'
    },
    'requires'           => {
        'perl'            => '5.10.0',
        'Math::Bezier'    => '>= 0.01',
        'Math::Trig'      => '>= 1.10',
        'Math::Gradient'  => '>= 0.03',
        'List::Util'      => '>= 1.20',
        'Sys::Mmap'       => '>= 0.16',
        'Imager'          => '>= 0.91',
    },
    'recommends' => {
        'Inline'          => '>= 0.53',
        'Inline::C'       => '>= 0.53',
    },
    'build_requires'     => {
        'Test::Most' => '>= 0.30',
        'List::Util' => '>= 1.20'
    },
    'dist'               => {
        'COMPRESS' => 'gzip -9f',
        'SUFFIX'   => 'gz'
    },
    'clean'              => {
        'FILES' => 'Graphics-Framebuffer-* _Inline* examples/_Inline*'
    }
);
$build->dispatch('realclean');

eval {
    use Term::ANSIColor;

    if (defined($ENV{'DISPLAY'}) && !$ENV{'GFB_OVERRIDE'}) {
        print colored(['red'],qq(

****************************************************************************
* Graphics::Framebuffer should not be installed from within X-Windows!     *
*                                                                          *
* You should install it from the console itself, and not a console window. *
****************************************************************************
)),colored(['yellow'],qq(
If you insist on installing from within X-Windows, please keep in mind that
the tests will show nothing, as they will be unable to draw to the screen,
since X-Windows is using it.  Thus the tests will run in emulation mode only.

));
    }

    print "\nChecking for 'fgconsole' binary... ";
    my $fbset = `fgconsole 2>&1`;

    if ($fbset =~ /\d+/ || -e '/bin/fgconsole') {
        print colored(['green'],'FOUND'),"\n\n";
    } else {
        print colored(['yellow'],'NOT FOUND'),"\n\nWhile 'fgconsole' is not required, it is, nevertheless, required for the 'which_console' method to function properly.\n\n";
    }
    my $perl_version = `perl -v`;

    print 'Checking for Threaded Perl... ';
    if ($perl_version =~ /thread/) {
        print colored(['green'],'Threaded Perl detected'),"\n\n";
    } else {
        print colored(['yellow'],'Not a threaded Perl.  Making adjustments...'),"\n";
        my $MOD = slurp_file('lib/Graphics/Framebuffer.pm');
        $MOD =~ s/use threads/\# use threads/sg;
        $MOD =~ s/: shared//sg;
        my $change_from = 'NO_THREADS = FALSE';
        my $change_to   = 'NO_THREADS = TRUE';
        $MOD =~ s/$change_from/$change_to/s;
        open(my $OUT,'>','lib/Graphics/Framebuffer.pm');
        print $OUT "$MOD\n";
        close($OUT);
        print colored(['green'],'Changes complete'),"\n\n";
    }

    if ($build->create_build_script()) {

        print "\nNow run:\n\n\t",colored(['bold'],'./Build'),"\n";
        print "\nUse to test:\n\n\t",colored(['bold'],'./Build test'),"\n\nUse to install (you may need to do it as root with sudu):\n\n\t sudo ",colored(['bold'],'./Build install'),"\n\n";
        print qq{The "examples" directory (in this package) has some handy scripts to help get\nyou started, and show you how to use the module.  'perldoc' each to see how to\nuse them:\n\n};

        print "\t",colored(['bold'],'primitives.pl'),"\t- This script will pretty much demonstrate all of the\n\t\t\t  capabilities of this module.\n\n";
        print "\t",colored(['bold'],'threadstest.pl'),"\t- This script demonstrates how to use the module in a\n\t\t\t  threading environment.\n\n";
        print "\t",colored(['bold'],'slideshow.pl'),"\t- This script shows all of the images in a specific path.\n\t\t\t  It automatically detects all of your framebuffer\n\t\t\t  devices, and dedicates a thread to each.\n\n";
        print "\t",colored(['bold'],'viewpic.pl'),"\t- This script shows one specific image (or animation).\n\n";
        print "\t",colored(['bold'],'dump.pl'),"\t\t- This script does a diagnostic variable dump to STDERR\n\t\t\t  for the author to help you with troubleshooting.\n\n";
        print "\t",colored(['bold'],'fonts.pl'),"\t- This script prints installed font names.\n\n";
    }
};
if ($@) {
    if (defined($ENV{'DISPLAY'}) && !$ENV{'GFB_OVERRIDE'}) {
        print qq(

****************************************************************************
* Graphics::Framebuffer should not be installed from within X-Windows!     *
*                                                                          *
* You should install it from the console itself, and not a console window. *
****************************************************************************

If you insist on installing from within X-Windows, please keep in mind that
the tests will show nothing, as they will be unable to draw to the screen,
since X-Windows is using it.  Thus the tests will run in emulation mode only.

);
    }

    print "\nChecking for 'fgconsole' binary... ";
    my $fbset = `fgconsole 2>&1`;

    if ($fbset =~ /\d+/ || -e '/bin/fgconsole') {
        print "FOUND\n\n";
    } else {
        print "NOT FOUND\n\nWhile 'fgconsole' is not required, it is, nevertheless, required for the 'which_console' method to function properly.\n\n";
    }
    my $perl_version = `perl -v`;

    print 'Checking for Threaded Perl... ';
    if ($perl_version =~ /thread/) {
        print "Threaded Perl detected\n\n";
    } else {
        print "Not a threaded Perl.  Making adjustments...\n";
        my $MOD = slurp_file('lib/Graphics/Framebuffer.pm');
        $MOD =~ s/use threads/\# use threads/sg;
        $MOD =~ s/: shared//sg;
        my $change_from = 'NO_THREADS = FALSE';
        my $change_to   = 'NO_THREADS = TRUE';
        $MOD =~ s/$change_from/$change_to/s;
        open(my $OUT,'>','lib/Graphics/Framebuffer.pm');
        print $OUT "$MOD\n";
        close($OUT);
        print "Changes complete\n\n";
    }

    if ($build->create_build_script()) {

        print "\nNow run:\n\n\t./Build\n";
        print "\nUse to test:\n\n\t./Build test\n\nUse to install (you may need to do it as root with sudu):\n\n\t sudo ./Build install\n\n";
        print qq{The "examples" directory (in this package) has some handy scripts to help get\nyou started, and show you how to use the module.  'perldoc' each to see how to\nuse them:\n\n};

        print "\tprimitives.pl\t- This script will pretty much demonstrate all of the\n\t\t\t  capabilities of this module.\n\n";
        print "\tthreadstest.pl\t- This script demonstrates how to use the module in a\n\t\t\t  threading environment.\n\n";
        print "\tslideshow.pl\t- This script shows all of the images in a specific path.\n\t\t\t  It automatically detects all of your framebuffer\n\t\t\t  devices, and dedicates a thread to each.\n\n";
        print "\tviewpic.pl\t- This script shows one specific image (or animation).\n\n";
        print "\tdump.pl\t\t- This script does a diagnostic variable dump to STDERR\n\t\t\t  for the author to help you with troubleshooting.\n\n";
        print "\tfonts.pl\t- This script prints installed font names.\n\n";
    }
}

sub slurp_file {
    my $file = shift;

    # Read in a text file without using open
    return (
        do { local (@ARGV, $/) = $file; <> }
    );
}       
