use strict;
use warnings;
use Test::More 0.88;
# This is a relatively nice way to avoid Test::NoWarnings breaking our
# expectations by adding extra tests, without using no_plan.  It also helps
# avoid any other test module that feels introducing random tests, or even
# test plans, is a nice idea.
our $success = 0;
END { $success && done_testing; }

# List our own version used to generate this
my $v = "\nGenerated by Dist::Zilla::Plugin::ReportVersions::Tiny v1.10\n";

eval {                     # no excuses!
    # report our Perl details
    my $want = 'v5.14.0';
    $v .= "perl: $] (wanted $want) on $^O from $^X\n\n";
};
defined($@) and diag("$@");

# Now, our module version dependencies:
sub pmver {
    my ($module, $wanted) = @_;
    $wanted = " (want $wanted)";
    my $pmver;
    eval "require $module;";
    if ($@) {
        if ($@ =~ m/Can't locate .* in \@INC/) {
            $pmver = 'module not found.';
        } else {
            diag("${module}: $@");
            $pmver = 'died during require.';
        }
    } else {
        my $version;
        eval { $version = $module->VERSION; };
        if ($@) {
            diag("${module}: $@");
            $pmver = 'died during VERSION check.';
        } elsif (defined $version) {
            $pmver = "$version";
        } else {
            $pmver = '<undef>';
        }
    }

    # So, we should be good, right?
    return sprintf('%-45s => %-10s%-15s%s', $module, $pmver, $wanted, "\n");
}

eval { $v .= pmver('App::Ack','1.82') };
eval { $v .= pmver('App::Cmd','0.308') };
eval { $v .= pmver('App::Nopaste','0.34') };
eval { $v .= pmver('App::Uni','any version') };
eval { $v .= pmver('App::Whiff','any version') };
eval { $v .= pmver('App::cpanminus','1.1002') };
eval { $v .= pmver('App::cpanoutdated','0.12') };
eval { $v .= pmver('App::grindperl','any version') };
eval { $v .= pmver('CPAN::Mini','0.563') };
eval { $v .= pmver('Carp::Always','any version') };
eval { $v .= pmver('Config::GitLike','any version') };
eval { $v .= pmver('Config::INI','0.011') };
eval { $v .= pmver('Crypt::SSLeay','any version') };
eval { $v .= pmver('DBD::SQLite','any version') };
eval { $v .= pmver('Data::GUID','0.044') };
eval { $v .= pmver('DateTime','0.51') };
eval { $v .= pmver('Devel::Cover','any version') };
eval { $v .= pmver('Devel::NYTProf','any version') };
eval { $v .= pmver('Dist::Zilla','5') };
eval { $v .= pmver('Dist::Zilla::PluginBundle::RJBS','1.012') };
eval { $v .= pmver('Email::Filter','1.02') };
eval { $v .= pmver('Email::MIME','1.905') };
eval { $v .= pmver('Email::Sender','any version') };
eval { $v .= pmver('Email::Sender::Transport::SQLite','any version') };
eval { $v .= pmver('ExtUtils::MakeMaker','6.30') };
eval { $v .= pmver('File::Rename','any version') };
eval { $v .= pmver('HTML::Element','3.22') };
eval { $v .= pmver('IO::Socket::SSL','any version') };
eval { $v .= pmver('JSON','2.12') };
eval { $v .= pmver('LWP::Protocol::https','any version') };
eval { $v .= pmver('List::AllUtils','any version') };
eval { $v .= pmver('Log::Dispatchouli','2.000') };
eval { $v .= pmver('Module::CoreList','2.68') };
eval { $v .= pmver('Module::Which','any version') };
eval { $v .= pmver('Moose','1.19') };
eval { $v .= pmver('MooseX::StrictConstructor','any version') };
eval { $v .= pmver('Mozilla::CA','any version') };
eval { $v .= pmver('PPI','1.212') };
eval { $v .= pmver('Params::Util','0.38') };
eval { $v .= pmver('Perl::Tidy','20071205') };
eval { $v .= pmver('Plack','any version') };
eval { $v .= pmver('Pod::Cpandoc','any version') };
eval { $v .= pmver('Pod::Weaver','4') };
eval { $v .= pmver('Scalar::Util','1.18') };
eval { $v .= pmver('Sub::Exporter','0.980') };
eval { $v .= pmver('Term::ReadLine::Gnu','1') };
eval { $v .= pmver('Test::More','0.96') };
eval { $v .= pmver('Text::Markdown','v1.0.24') };
eval { $v .= pmver('Throwable','0.102080') };
eval { $v .= pmver('Throwable::X','any version') };
eval { $v .= pmver('Try::Tiny','0.007') };
eval { $v .= pmver('Unicode::Tussle','any version') };
eval { $v .= pmver('namespace::autoclean','any version') };
eval { $v .= pmver('strict','any version') };
eval { $v .= pmver('warnings','any version') };


# All done.
$v .= <<'EOT';

Thanks for using my code.  I hope it works for you.
If not, please try and include this output in the bug report.
That will help me reproduce the issue and solve your problem.

EOT

diag($v);
ok(1, "we really didn't test anything, just reporting data");
$success = 1;

# Work around another nasty module on CPAN. :/
no warnings 'once';
$Template::Test::NO_FLUSH = 1;
exit 0;
