use strict;
use warnings;
use Module::Build;

my $builder = Module::Build->new(
    module_name         => 'Time::LST',
    license             => 'perl',
    dist_author         => q{Roderick Garton <rgarton@cpan.org>},
    dist_abstract => 'Convert date/time to local sidereal time via Astro-Time and other Date/Time modules',
    dist_version_from   => 'lib/Time/LST.pm',
    configure_requires => {
        'Module::Build' => '0.4007',
    },
    build_requires => {
       'Test::More' => '0.92',
       'Astro::Time' => 0.075,
       'Date::Parse' => 0,
       'DateTime'    => 1.03,
    },
    add_to_cleanup      => [ 'Time-LST-0.04-*' ],
    create_makefile_pl => 'traditional',
);

$builder->create_build_script();