# 6A-exclusions.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data when exclusions of certain words or associations have been set
use strict;
use warnings;

use Test::More tests => 11;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new(
    ex_errors => 1,
    ex_cultural => 0,
    ex_phrasal => 0,
    ex_lexical => 0,
    ex_misc => 1,
);

my ($word1, $word2, $dat, $aref, $num, @ari) = (qw/diary cow/);


my %dat_ref = (
    nassocs_norm => 14, # normally 14 for "DAIRY", including "->COW" and "->MILK"
    nassocs_cull => 12, # normally 14 for "DAIRY", including "->COW" and "->MILK"
    ncues => 40, # normally 41
);

# "ex_errors" are loaded by way of new()
$num = $usf->setsize('DIARY', calc => 0); # should be taken directly from DB field
ok( is_equal($num, $dat_ref{'nassocs_norm'}), "N assocs returned = $num, should be $dat_ref{'nassocs_norm'}" );

$num = $usf->setsize('DIARY', calc => 1);
ok( is_equal($num, $dat_ref{'nassocs_cull'}), "N assocs returned = $num, should be $dat_ref{'nassocs_cull'}" );

# check can unset exclusions globally:
$usf->unset_exclusions();
$num = $usf->setsize('DIARY', calc => 1);
ok( is_equal($num, $dat_ref{'nassocs_norm'}), "N assocs returned = $num, should be $dat_ref{'nassocs_norm'}" );

# check can set exclusions on:
$usf->set_exclusions(ex_cultural => 1);
$num = $usf->setsize('BOY', calc => 1); # affects list_associates: usually 10 associates of BOY
ok( is_equal($num, 9), "N assocs returned = $num, should be 9'}" );

# - and also for single words:
$usf->set_exclusions(ex_structural => 1);
$num = scalar $usf->list_associates('FIB', ref => 0); # use list_associates directly
ok( is_equal($num, 3), "N assocs returned = $num, should be 3'}" ); # LIE, TALE, TRUTH - should skip "FBI" 

# - and affects assoc_depth (by way of find_pair):
$num = $usf->assoc_depth('BOY', 'GEORGE'); # should be excluded
ok( is_equal($num, 0), "Assoc. depth returned = $num, should be 0'}" );

$num = $usf->assoc_depth('BOY', 'MAN'); # should now be 3
ok( is_equal($num, 3), "Assoc. depth returned = $num, should be 3'}" );

# and check that can set exclusion discretely off again:
$usf->set_exclusions(ex_cultural => 0);
$num = $usf->setsize('BOY', calc => 1);
ok( is_equal($num, 10), "N assocs returned = $num, should be 10'}" );

# check that single word methods are not affected by paired word exclusions:
$usf->set_exclusions(ex_cultural => 0);
$num = scalar $usf->list_words(first => 'F', chars => [3, 3], ref => 0, cues_only => 1); 
ok( is_equal($num, 21), "N words returned = $num, should be 21'}" ); # hand-checked
$usf->set_exclusions(ex_cultural => 1);
$num = scalar $usf->list_words(first => 'F', chars => [3, 3], ref => 0, cues_only => 1); # should exclude FBI but not FIG->NEWTON
ok( is_equal($num, 20), "N words returned = $num, should be 20'}" ); # hand-checked

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
