# 5B-list_cues.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from list_cues
use strict;
use warnings;

use Test::More tests => 9;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $word2, $dat, $aref, @ari) = (qw/milk cow/);

my %dat_ref = (
    ncues => 41,
    lastcue => 'YOGURT',
    depth4 => 22,
    depthword4s8 => 'DAIRY',
    depthword4s8val => 0.4940,
);

# Test list_associates:
$aref = $usf->list_cues($word1, ref => 1);
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'ncues'}), "N cues returned = $dat, should be $dat_ref{'ncues'}" );

#- as open array:
@ari = $usf->list_cues($word1, ref => 0);
$dat = scalar(@ari);
ok( is_equal($dat, $dat_ref{'ncues'}), "N cues returned = $dat, should be $dat_ref{'ncues'}" );

#- check got right to the proper end of list:
ok(char_equal($ari[-1], $dat_ref{'lastcue'}), "Last cue returned = $ari[-1], should be $dat_ref{'lastcue'}");

#-controlling depth:
$aref = $usf->list_cues($word1, depth => 4, ref => 1); # assume data => 0
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depth4'}), "Seeking $dat_ref{'depth4'} cue, got $dat" );

#- check got right to the proper 8th element of list:
ok(char_equal($aref->[8], $dat_ref{'depthword4s8'}), "8th cue returned = $aref->[8], should be $dat_ref{'depthword4s8'}");

#- try to get data, not just word list:
$aref = $usf->list_cues($word1, depth => 4, data => 1, ref => 1);
# -- ensuring only up to the 4th assoc, as a reference of 4 referenced lines - checking the value of the 5th col in the 8th line:
$dat = scalar(@$aref);
ok( is_equal($dat, $dat_ref{'depth4'}), "Seeking $dat_ref{'depth4'} cues, got $dat");
my $datline = $aref->[8];
ok( is_equal($datline->[5], $dat_ref{'depthword4s8val'}), "Seeking $dat_ref{'depthword4s8val'} cue value, got $datline->[5]");

# - same but as a reference of hashed lines:
$aref = $usf->list_cues($word1, depth => 4, data => 2, ref => 1);
$datline = $aref->[8];
ok( is_equal($datline->{'FSG'}, $dat_ref{'depthword4s8val'}), "Seeking $dat_ref{'depthword4s8val'} cue val, got $datline->{'FSG'}");

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
