# 2B-cannedstats_extra.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from DB fields for data from other sources
use strict;
use warnings;

use Test::More tests => 15;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $dat) = ('milk');

my %dat_ref = (
	FRQ => 49,
	CCN => 6.66,
	HMG => 0,
	PSP => 'NN',
);

# Get stats by method name:
$dat = $usf->frequency($word1);
ok( is_equal($dat, $dat_ref{'FRQ'}), "frq calculated = $dat, should be $dat_ref{'FRQ'}");

$dat = $usf->concreteness($word1);
ok( is_equal($dat, $dat_ref{'CCN'}), "ccn calculated = $dat, should be $dat_ref{'CCN'}");

$dat = $usf->homograph($word1);
ok( is_equal($dat, $dat_ref{'HMG'}), "hmg calculated = $dat, should be $dat_ref{'HMG'}");

$dat = $usf->partofspeech($word1);
ok( char_equal($dat, $dat_ref{'PSP'}), "psp calculated = $dat, should be $dat_ref{'PSP'}");

# Get stats directly from word_stat();
foreach my $s(qw/FRQ CCN/) {
    $dat = $usf->word_stat($word1, $s);
    ok( is_equal($dat, $dat_ref{$s}), "$s calculated = $dat, should be $dat_ref{$s}");
}

$dat = $usf->word_stat($word1, 'HMG');
ok( char_equal($dat, ''), "HMG calculated = $dat, should be undef" );

$dat = $usf->word_stat($word1, 'PSP');
ok( char_equal($dat, $dat_ref{'PSP'}), "PSP calculated = $dat, should be $dat_ref{'PSP'}" );


# Get two stats at once:
# FRQ = 49 and SSZ = 18 := 67
#* by word_stat as open array (as default):
my (@ari, $aref, $href) = ();
my $sum_want = 67;
my $sum_got = '';

@ari = $usf->word_stat($word1, [qw/SSZ FRQ/]);
$sum_got = sum(@ari);
ok( is_equal($sum_got, $sum_want), "SSZ and FRQ requested = $sum_got, should be $sum_want" );

#* by word_stat as open array (specifying ref => 0, unreferenced):
@ari = $usf->word_stat($word1, [qw/SSZ FRQ/], ref => 0);
$sum_got = sum(@ari);
ok( is_equal($sum_got, $sum_want), "SSZ and FRQ requested = $sum_got, should be $sum_want" );

#* by word_stat as open array (specifying {ref => 0}, referenced):
@ari = $usf->word_stat($word1, [qw/SSZ FRQ/], {ref => 0});
$sum_got = sum(@ari);
ok( is_equal($sum_got, $sum_want), "SSZ and FRQ requested = $sum_got, should be $sum_want" );

#* by word_stat as aref (specifying ref => 1, unreferenced):
$aref = $usf->word_stat($word1, [qw/SSZ FRQ/], ref => 1);
$sum_got = sum(@{$aref});
ok( is_equal($sum_got, $sum_want), "SSZ and FRQ requested = $sum_got, should be $sum_want" );

#* by word_stat as aref (specifying {ref => 1}, referenced):
$aref = $usf->word_stat($word1, [qw/SSZ FRQ/], {ref => 1});
$sum_got = sum(@{$aref});
ok( is_equal($sum_got, $sum_want), "SSZ and FRQ requested = $sum_got, should be $sum_want" );

#* by word_stat as href (specifying {ref => 2}}:
$href = $usf->word_stat($word1, [qw/SSZ FRQ/], {ref => 2});
$sum_got = sum(values %{$href});
ok( is_equal($sum_got, $sum_want), "SSZ and FRQ requested = $sum_got, should be $sum_want" );

sub sum {
    my $d = 0;
    $d += $_ foreach @_;
    return $d;
}

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
