# 2A-cannedstats_sglmain.t version 0.01
# A script to run tests on the Lingua::Norms::USF module.
# Checks correct returns of data from DB fields calculated from DB's own data
use strict;
use warnings;

use Test::More tests => 9;
use constant EPS => 1e-9;

BEGIN { use_ok('Lingua::Norms::USF') };

my $usf = Lingua::Norms::USF->new();

my ($word1, $dat) = ('milk');

my %dat_ref = (
    SSZ => 18,
    CNM => 1.29,
    RSM => 0.59,
	RSS => 0.161,
);

# Get stats by method name:
$dat = $usf->setsize($word1);
ok( is_equal($dat, $dat_ref{'SSZ'}), "ssz calculated = $dat, should be $dat_ref{'SSZ'}" );

$dat = $usf->connectivity($word1);
ok( is_equal($dat, $dat_ref{'CNM'}), "cnm calculated = $dat, should be $dat_ref{'CNM'}" );

$dat = $usf->resonance_mean($word1);
ok( is_equal($dat, $dat_ref{'RSM'}), "RSM calculated = $dat, should be $dat_ref{'RSM'}" );

$dat = $usf->resonance_strength($word1);
ok( is_equal($dat, $dat_ref{'RSS'}), "rss calculated = $dat, should be $dat_ref{'RSS'}" );

# Get stats directly from word_stat();
foreach my $s(qw/SSZ CNM RSM RSS/) {
    $dat = $usf->word_stat($word1, $s);
    ok( is_equal($dat, $dat_ref{$s}), "$s calculated = $dat, should be $dat_ref{$s}" );
}

sub is_equal {
    return 1 if $_[0] == $_[1];
    return 0;
}

sub char_equal {
    return 1 if $_[0] eq $_[1];
    return 0;
}

sub about_equal {
    return 1 if $_[0] + EPS > $_[1] and $_[0] - EPS < $_[1];
    return 0;
}
