#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Twitter
#     ABSTRACT:  identify Twitter (AS13414 AS35995 AS54888) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Twitter;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Twitter (AS13414 AS35995 AS54888) IP blocks as of Oct 2014
    $self->ips(qw(
        8.25.194.0 - 8.25.195.255
        8.25.196.0 - 8.25.197.255
        185.45.4.0 - 185.45.7.255
        192.133.76.0 - 192.133.79.255
        199.16.156.0 - 199.16.159.255
        199.59.148.0 - 199.59.151.255
        199.96.56.0 - 199.96.63.255
        209.170.99.0 - 209.170.99.255
    ));
    return $self;
}

sub name {
    return 'Twitter';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Twitter - identify Twitter (AS13414 AS35995 AS54888) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Twitter;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Twitter identifies Twitter (AS13414 AS35995 AS54888) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Twitter object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
