#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Sharktech
#     ABSTRACT:  identify Sharktech (AS46844) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Wed Nov 12 09:37:48 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Sharktech;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Sharktech (AS46844) IP blocks as of Nov 2014
    $self->ips(qw(
        64.32.0.0 - 64.32.31.255
        67.21.64.0 - 67.21.95.255
        70.39.64.0 - 70.39.127.255
        104.37.244.0 - 104.37.247.255
        104.160.160.0 - 104.160.191.255
        104.201.64.0 - 104.201.127.255
        107.167.0.0 - 107.167.31.255
        170.178.160.0 - 170.178.191.255
        174.128.224.0 - 174.128.255.255
        198.148.80.0 - 198.148.95.255
        199.115.96.0 - 199.115.103.255
        204.188.192.0 - 204.188.255.255
        208.98.0.0 - 208.98.63.255
    ));
    return $self;
}

sub name {
    return 'Sharktech';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Sharktech - identify Sharktech (AS46844) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Sharktech;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Sharktech identifies Sharktech (AS46844) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Sharktech object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
