#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::OVH
#     ABSTRACT:  identify OVH (AS16276) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Tue Nov 11 10:29:26 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::OVH;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known OVH (AS16276) IP blocks as of Nov 2014
    $self->ips(qw(
        5.39.0.0 - 5.39.127.255
        5.135.0.0 - 5.135.255.255
        5.196.0.0 - 5.196.255.255
        37.59.0.0 - 37.59.255.255
        37.187.0.0 - 37.187.255.255
        46.105.0.0 - 46.105.255.255
        87.98.128.0 - 87.98.191.255
        91.121.0.0 - 91.121.255.255
        92.222.0.0 - 92.222.255.255
        94.23.0.0 - 94.23.255.255
        109.190.0.0 - 109.190.255.255
        142.4.192.0 - 142.4.223.255
        167.114.0.0 - 167.114.255.255
        176.31.0.0 - 176.31.255.255
        178.32.0.0 - 178.33.255.255
        188.165.0.0 - 188.165.255.255
        192.95.0.0 - 192.95.63.255
        192.99.0.0 - 192.99.255.255
        198.27.64.0 - 198.27.127.255
        198.50.128.0 - 198.50.255.255
        198.100.144.0 - 198.100.159.255
        198.245.48.0 - 198.245.63.255
        213.186.32.0 - 213.186.32.255
        213.186.50.128 - 213.186.50.159
        213.186.61.0 - 213.186.61.255
        213.186.62.0 - 213.186.62.255
        213.251.128.0 - 213.251.191.255
    ));
    return $self;
}

sub name {
    return 'OVH';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::OVH - identify OVH (AS16276) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::OVH;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::OVH identifies OVH (AS16276) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::OVH object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
