#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::FDCServers
#     ABSTRACT:  identify FDCServers (AS30058) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Thu Nov  6 09:57:17 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::FDCServers;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known FDCServers (AS30058) IP blocks as of Nov 2014
    $self->ips(qw(
        23.237.0.0 - 23.237.255.255
        50.7.0.0 - 50.7.255.255
        66.90.64.0 - 66.90.127.255
        67.159.0.0 - 67.159.63.255
        74.63.64.0 - 74.63.127.255
        76.73.0.0 - 76.73.127.255
        107.176.0.0 - 107.177.255.255
        108.179.64.0 - 108.179.127.255
        192.240.96.0 - 192.240.127.255
        198.16.64.0 - 198.16.127.255
        198.255.0.0 - 198.255.127.255
        204.45.0.0 - 204.45.255.255
        208.53.128.0 - 208.53.191.255
        216.227.128.0 - 216.227.191.255
    ));
    return $self;
}

sub name {
    return 'FDCServers';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::FDCServers - identify FDCServers (AS30058) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::FDCServers;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::FDCServers identifies FDCServers (AS30058) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::FDCServers object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
