#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Amazon
#     ABSTRACT:  identify Amazon owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Nov 16 17:18:54 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Amazon;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known Amazon  IP blocks as of Nov 2014
    # AS9059 AS8987 AS7224 AS58588 AS39111 AS38895 AS17493 AS16509 AS14618 AS10124
    $self->ips(qw(
        8.18.144.0 - 8.18.144.255
        8.18.145.0 - 8.18.145.255
        23.20.0.0 - 23.23.255.255
        27.0.0.0 - 27.0.3.255
        46.51.128.0 - 46.51.255.255
        46.137.0.0 - 46.137.255.255
        50.16.0.0 - 50.19.255.255
        50.112.0.0 - 50.112.255.255
        54.64.0.0 - 54.71.255.255
        54.72.0.0 - 54.95.255.255
        54.144.0.0 - 54.159.255.255
        54.160.0.0 - 54.175.255.255
        54.176.0.0 - 54.191.255.255
        54.192.0.0 - 54.207.255.255
        54.208.0.0 - 54.221.255.255
        54.224.0.0 - 54.239.255.255
        54.240.0.0 - 54.255.255.255
        67.202.0.0 - 67.202.63.255
        72.21.192.0 - 72.21.223.255
        72.44.32.0 - 72.44.63.255
        75.101.128.0 - 75.101.255.255
        79.125.0.0 - 79.125.127.255
        87.238.80.0 - 87.238.87.255
        96.127.0.0 - 96.127.127.255
        103.246.148.0 - 103.246.151.255
        107.20.0.0 - 107.23.255.255
        122.248.192.0 - 122.248.255.255
        174.129.0.0 - 174.129.255.255
        176.32.64.0 - 176.32.127.255
        176.34.0.0 - 176.34.255.255
        178.236.0.0 - 178.236.15.255
        184.72.0.0 - 184.73.255.255
        184.169.128.0 - 184.169.255.255
        185.48.120.0 - 185.48.123.255
        199.127.232.0 - 199.127.235.255
        199.255.192.0 - 199.255.195.255
        203.83.220.0 - 203.83.223.255
        204.236.128.0 - 204.236.255.255
        204.246.160.0 - 204.246.191.255
        205.251.192.0 - 205.251.255.255
        207.171.160.0 - 207.171.191.255
        216.137.32.0 - 216.137.63.255
        216.182.224.0 - 216.182.239.255
        2400:6500::/32
        2403:B300::/32
        2406:da00::/32
        2620:107:3000:: - 2620:107:300F:FFFF:FFFF:FFFF:FFFF:FFFF
        2620:108:7000:: - 2620:108:700F:FFFF:FFFF:FFFF:FFFF:FFFF
    ));
    return $self;
}

sub name {
    return 'Amazon';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Amazon - identify Amazon owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Amazon;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Amazon identifies Amazon (AS9059 AS8987
AS7224 AS58588 AS39111 AS38895 AS17493 AS16509 AS14618 AS10124) host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Amazon object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
