#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::Akamai
#     ABSTRACT:  identify Akamai owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Thu Nov  6 11:03:41 PST 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::Akamai;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of of of known Akamai IP blocks as of Nov 2014
    # AS12222 AS16625 AS16702 AS17334 AS18680 AS18717 AS20189 AS20940
    # AS21342 AS21357 AS21399 AS22207 AS23454 AS23455 AS23903 AS24319
    # AS30675 AS31107 AS31108 AS31109 AS31110 AS31377 AS33905 AS34164
    # AS34850 AS35204 AS35993 AS35994 AS36183 AS39836 AS43639 AS45700
    # AS48163 AS55770 AS393560
    $self->ips(qw(
        23.0.0.0 - 23.15.255.255
        23.32.0.0 - 23.67.255.255
        23.72.0.0 - 23.79.255.255
        23.192.0.0 - 23.223.255.255
        42.99.255.0 - 42.99.255.255
        46.33.64.0 - 46.33.77.255
        58.27.86.0 - 58.27.86.255
        58.27.87.0 - 58.27.87.255
        59.144.52.0 - 59.144.52.255
        59.144.56.0 - 59.144.56.255
        59.144.115.0 - 59.144.115.255
        59.151.128.0 - 59.151.191.255
        60.254.128.0 - 60.254.191.255
        62.154.232.0 - 62.154.232.255
        62.156.209.0 - 62.156.209.255
        62.159.74.0 - 62.159.74.255
        63.84.59.0 - 63.84.59.255
        63.85.36.0 - 63.85.36.255
        63.141.192.0 - 63.141.193.255
        63.141.195.0 - 63.141.195.255
        63.141.200.0 - 63.141.201.255
        63.144.176.0 - 63.144.176.255
        63.150.131.0 - 63.150.131.255
        63.162.234.0 - 63.162.234.255
        63.168.61.0 - 63.168.61.255
        63.208.195.0 - 63.208.195.255
        63.243.206.0 - 63.243.207.255
        63.243.241.0 - 63.243.241.255
        63.243.242.0 - 63.243.242.255
        64.86.133.0 - 64.86.133.255
        64.86.201.0 - 64.86.201.255
        64.145.68.0 - 64.145.71.255
        64.145.75.0 - 64.145.75.255
        64.145.84.0 - 64.145.84.255
        64.145.87.0 - 64.145.87.255
        64.145.88.0 - 64.145.88.255
        64.145.89.0 - 64.145.89.255
        64.145.95.0 - 64.145.95.255
        65.121.210.0 - 65.121.211.255
        65.122.93.0 - 65.122.93.255
        65.163.176.0 - 65.163.176.255
        65.171.167.0 - 65.171.167.255
        65.173.24.0 - 65.173.24.255
        65.197.197.0 - 65.197.197.255
        65.197.244.0 - 65.197.244.255
        66.171.224.0 - 66.171.225.255
        66.171.227.0 - 66.171.227.255
        66.171.230.0 - 66.171.230.255
        66.171.231.0 - 66.171.231.255
        66.171.234.0 - 66.171.235.255
        66.198.8.0 - 66.198.8.255
        67.131.232.0 - 67.131.232.255
        69.22.154.0 - 69.22.155.255
        69.31.20.0 - 69.31.20.255
        69.31.57.0 - 69.31.57.255
        69.31.72.0 - 69.31.73.255
        69.31.74.0 - 69.31.75.255
        69.31.76.0 - 69.31.77.255
        69.31.89.0 - 69.31.89.255
        69.31.97.0 - 69.31.97.255
        69.31.106.0 - 69.31.107.255
        69.31.116.0 - 69.31.117.255
        69.31.132.0 - 69.31.133.255
        69.31.138.0 - 69.31.138.255
        69.192.0.0 - 69.192.255.255
        70.39.163.0 - 70.39.163.255
        70.39.178.0 - 70.39.179.255
        72.246.0.0 - 72.247.255.255
        80.12.192.0 - 80.12.192.255
        80.67.64.0 - 80.67.95.255
        80.146.174.0 - 80.146.174.255
        80.231.241.0 - 80.231.241.255
        81.52.133.0 - 81.52.134.63
        81.52.201.0 - 81.52.201.255
        82.96.58.0 - 82.96.58.255
        84.53.128.0 - 84.53.191.255
        88.221.0.0 - 88.221.255.255
        92.122.0.0 - 92.123.255.255
        93.92.66.0 - 93.92.66.255
        93.123.37.0 - 93.123.37.255
        93.158.110.0 - 93.158.111.255
        95.100.0.0 - 95.101.255.255
        96.6.0.0 - 96.7.255.255
        96.16.0.0 - 96.17.255.255
        98.124.141.0 - 98.124.141.255
        103.238.148.0 - 103.238.151.255
        104.64.0.0 - 104.127.255.255
        111.92.162.0 - 111.92.162.255
        114.141.72.0 - 114.141.79.255
        115.124.93.0 - 115.124.93.255
        118.214.0.0 - 118.215.255.255
        122.252.32.0 - 122.252.63.255
        122.252.128.0 - 122.252.143.255
        125.56.128.0 - 125.56.255.255
        125.252.192.0 - 125.252.255.255
        172.224.0.0 - 172.239.255.255
        173.205.78.0 - 173.205.79.255
        173.222.0.0 - 173.223.255.255
        173.245.192.0 - 173.245.193.255
        173.245.196.0 - 173.245.196.255
        173.245.197.0 - 173.245.197.255
        173.245.198.0 - 173.245.198.255
        173.245.212.0 - 173.245.213.255
        173.245.214.0 - 173.245.214.255
        184.24.0.0 - 184.31.255.255
        184.50.0.0 - 184.51.255.255
        184.84.0.0 - 184.87.255.255
        189.125.84/24
        189.125.85/24
        190.90.221/24
        190.90.222/24
        190.90.223/24
        190.210.32/24
        193.108.88.0 - 193.108.95.255
        193.108.152.0 - 193.108.155.255
        193.247.166.0 - 193.247.166.255
        193.247.167.0 - 193.247.167.255
        194.224.66.0 - 194.224.66.255
        195.49.93.0 - 195.49.93.255
        195.57.81.0 - 195.57.81.255
        195.57.152.0 - 195.57.153.255
        195.59.122.0 - 195.59.122.255
        195.95.192.0 - 195.95.193.255
        195.175.68.0 - 195.175.71.255
        195.245.124.0 - 195.245.125.255
        195.245.126.0 - 195.245.127.255
        196.41.99.0 - 196.41.99.255
        198.47.108.0 - 198.47.108.255
        198.144.96.0 - 198.144.96.255
        198.144.98.0 - 198.144.98.255
        198.144.99.0 - 198.144.99.255
        198.144.100.0 - 198.144.100.255
        198.144.112.0 - 198.144.112.255
        198.144.115.0 - 198.144.115.255
        198.144.119.0 - 198.144.119.255
        201.220.10/24
        202.74.62.0 - 202.74.63.255
        202.125.100.0 - 202.125.101.255
        203.101.53.0 - 203.101.53.255
        203.146.247.0 -  203.146.247.255
        204.8.48.0 - 204.8.51.255
        204.10.28.0 - 204.10.31.255
        204.93.32.0 - 204.93.32.255
        204.93.34.0 - 204.93.34.255
        204.93.36.0 - 204.93.36.255
        204.93.37.0 - 204.93.37.255
        204.93.38.0 - 204.93.39.255
        204.93.40.0 - 204.93.40.255
        204.93.42.0 - 204.93.43.255
        204.93.44.0 - 204.93.44.255
        204.93.46.0 - 204.93.47.255
        204.93.48.0 - 204.93.48.255
        204.93.62.0 - 204.93.63.255
        204.95.24.0 - 204.95.25.255
        205.161.113.0 - 205.161.113.255
        205.185.204.0 - 205.185.205.255
        205.234.218.0 - 205.234.218.255
        205.234.225.0 - 205.234.225.255
        205.246.30.0 - 205.246.31.255
        208.34.250.0 - 208.34.250.255
        209.95.152.0 - 209.95.152.255
        209.107.202.0 - 209.107.202.255
        209.107.203.0 - 209.107.203.255
        209.107.205.0 - 209.107.205.255
        209.107.206.0 - 209.107.206.255
        209.107.207.0 - 209.107.207.255
        209.107.209.0 - 209.107.209.255
        209.107.213.0 - 209.107.213.255
        209.107.215.0 - 209.107.215.255
        209.107.220.0 - 209.107.220.255
        209.107.221.0 - 209.107.221.255
        209.107.222.0 - 209.107.222.255
        209.107.223.0 - 209.107.223.255
        209.136.40.0 - 209.136.40.255
        209.170.90.0 - 209.170.90.255
        209.170.94.0 - 209.170.94.255
        209.170.97.0 - 209.170.97.255
        209.170.113.0 - 209.170.113.255
        209.170.115.0 - 209.170.115.255
        209.170.116.0 - 209.170.116.255
        209.170.117.0 - 209.170.117.255
        209.170.118.0 - 209.170.118.255
        209.234.250.0 - 209.234.250.255
        209.234.252.0 - 209.234.252.255
        210.16.40.0 - 210.16.40.255
        213.254.17.0 - 213.254.17.255
        216.151.176.0 - 216.151.176.255
        216.151.187.0 - 216.151.187.255
        216.206.30.0 - 216.206.30.255
        216.246.75.0 - 216.246.75.255
        216.246.87.0 - 216.246.87.255
        216.246.93.0 - 216.246.93.255
        216.246.122.0 - 216.246.122.255
        217.89.107.0 - 217.89.107.255
        2001:218:3003::/48
        2001:428:1802:300:: - 2001:428:1802:3FF:FFFF:FFFF:FFFF:FFFF
        2001:428:2002:: - 2001:428:2002:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:428:4C02:200:: - 2001:428:4C02:2FF:FFFF:FFFF:FFFF:FFFF
        2001:428:7006:: - 2001:428:7006:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:1:: - 2001:590:1:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:1009:: - 2001:590:1009:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:100A:: - 2001:590:100A:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:100B:: - 2001:590:100B:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:140A:: - 2001:590:140A:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:140B:: - 2001:590:140B:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:140C:: - 2001:590:140C:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:1807:: - 2001:590:1807:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:1808:: - 2001:590:1808:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:1C09:: - 2001:590:1C09:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:1C0A:: - 2001:590:1C0A:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:1C0B:: - 2001:590:1C0B:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:2009:: - 2001:590:2009:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:200A:: - 2001:590:200A:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:200B:: - 2001:590:200B:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:2406:: - 2001:590:2406:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:2407:: - 2001:590:2407:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:2408:: - 2001:590:2408:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:2807:: - 2001:590:2807:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:2809:: - 2001:590:2809:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:280A:: - 2001:590:280A:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:590:4803:: - 2001:590:4803:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:5A0:3B00:: - 2001:5A0:3B00:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:5A0:3B01:: - 2001:5A0:3B01:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:5A0:3C00:: - 2001:5A0:3C00:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:5A0:3D00:: - 2001:5A0:3D00:FFFF:FFFF:FFFF:FFFF:FFFF
        2001:4878:: - 2001:4878:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
        2404:4e00::/32
        2600:2:D80:3:: - 2600:2:D80:3:FFFF:FFFF:FFFF:FFFF
        2600:3:500:4:: - 2600:3:500:4:FFFF:FFFF:FFFF:FFFF
        2600:3:500:6:: - 2600:3:500:6:FFFF:FFFF:FFFF:FFFF
        2600:5:3D40:3:: - 2600:5:3D40:3:FFFF:FFFF:FFFF:FFFF
        2600:1400:: - 2600:141F:FFFF:FFFF:FFFF:FFFF:FFFF:FFFF
    ));
    return $self;
}

sub name {
    return 'Akamai';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::Akamai - identify Akamai owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::Akamai;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::Akamai identifies Akamai host IPs.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::Akamai object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
