#===============================================================================
#      PODNAME:  Net::IP::Identifier::Plugin::1and1
#     ABSTRACT:  identify 1and1 (AS8560) owned IP addresses
#
#       AUTHOR:  Reid Augustin (REID)
#        EMAIL:  reid@hellosix.com
#      CREATED:  Sun Oct 12 19:32:46 PDT 2014
#===============================================================================

use 5.008;
use strict;
use warnings;

package Net::IP::Identifier::Plugin::1and1;

use Role::Tiny::With;
with qw( Net::IP::Identifier_Role );

our $VERSION = '0.086'; # VERSION

sub new {
    my ($class, %opts) = @_;

    my $self = {};
    bless $self, (ref $class || $class);

    # List of known 1and1 (AS8560) IP blocks as of Oct 2014
    $self->ips(qw(
        50.21.176.0 - 50.21.191.255
        70.35.192.0 - 70.35.207.255
        74.208.0.0 - 74.208.255.255
        82.165.0.0 - 82.165.255.255
        87.106.0.0 - 87.106.255.255
        104.192.4.0 - 104.192.7.255
        104.219.40.0 - 104.219.43.255
        108.175.0.0 - 108.175.15.255
        162.222.200.0 - 162.222.207.255
        162.252.156.0 - 162.252.159.255
        162.255.84.0 - 162.255.87.255
        195.20.224.0 - 195.20.255.255
        198.71.48.0 - 198.71.63.255
        198.251.64.0 - 198.251.79.255
        212.227.0.0 - 212.227.255.255
        213.165.64.0 - 213.165.95.255
        216.250.112.0 - 216.250.127.255
        217.72.192.0 - 217.72.207.255
        217.160.0.0 - 217.160.255.255
    ));
    return $self;
}

sub name {
    return '1and1';
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Net::IP::Identifier::Plugin::1and1 - identify 1and1 (AS8560) owned IP addresses

=head1 VERSION

version 0.086

=head1 SYNOPSIS

 use Net::IP::Identifier::Plugin::1and1;

=head1 DESCRIPTION

Net::IP::Identifier::Plugin::1and1 identifies 1and1 (AS8560) host IPs.

Note: United Internet (of Germany) owns both 1and1 and Fasthosts.  Only 1and1
netblocks are included in this module.

=head2 Methods

=over

=item new

Creates a new Net::IP::Identifier::Plugin::1and1 object.

=back

=head1 SEE ALSO

=over

=item IP::Net

=item IP::Net::Identifier

=item IP::Net::Identifier_Role

=back

=head1 AUTHOR

Reid Augustin <reid@hellosix.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2014 by Reid Augustin.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
