#!/usr/bin/perl
package Config::Reader;

use warnings;

sub rconf {
    our %UserPreferences;
    my ($File) = @_;
    open (CONFIG, "<", $File) or die "Couldn't open file. $!";


    while (<CONFIG>) {
        chomp;                  # no newline
        s/#.*//;                # no comments
        s/^\s+//;               # no leading white
        s/\s+$//;               # no trailing white
        next unless length;     # anything left?
        my ($Var, $Value) = split(/\s*=\s*/, $_, 2);
        $ConfigReader{$Var} = $Value;
    }
    return %ConfigReader
}
1;

=head1 NAME

Config::Reader - Very simple config reader

=head1 SYNOPSIS

        use Config::Reader;
        my %Config = Config::Reader::rconf($File);


=head1 DESCRIPTION

C<readConf> Parses a simple configuration files and store its data in the C<%Config::Reader::rconf> return value

        #This is a comment.
        Variabale=Value
        Variable2=Value2
        Variable3=Value3

Then, to get the "Variable3" value

        print $Config{Variable3};

=head1 AUTHOR

qorg11 <qorg@vxempire.xyz>

=head1 LICENSE

Public Domain
