package Statocles::Plugin;
# ABSTRACT: Base role for Statocles plugins
$Statocles::Plugin::VERSION = '0.064';

use Statocles::Base 'Role';


requires 'register';

1;

__END__

=pod

=head1 NAME

Statocles::Plugin - Base role for Statocles plugins

=head1 VERSION

version 0.064

=head1 SYNOPSIS

    # lib/My/Plugin.pm
    package My::Plugin;
    use Moo; # or Moose
    with 'Statocles::Plugin';

    sub register {
        my ( $self, $site ) = @_;
        # Register things like event handlers and theme helpers
    }

    1;

    # site.yml
    site:
        args:
            plugins:
                name:
                    $class: My::Plugin

=head1 DESCRIPTION

Statocles Plugins are attached to sites and add features such as template helpers
and event handlers.

This is the base role that all plugins should consume.

=head1 METHODS

=head2 register

    $plugin->register( $site );

Register this plugin with the given L<Statocles::Site
object|Statocles::Site>. This is called automatically when the site is
created.

=head1 BUNDLED PLUGINS

These plugins come with Statocles. L<More plugins may be available from
CPAN|http://metacpan.org>.

=over 4

=item L<Statocles::Plugin::Highlight>

Syntax highlighting for code and configuration

=back

=head1 AUTHOR

Doug Bell <preaction@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Doug Bell.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
