/*
 * $Id: bcg_logger.h 26630 2008-03-29 20:42:36Z chromatic $
 * Copyright (C) 2006-2008, The Perl Foundation.
 */

#ifndef PARROT_BCG_LOGGER_H_GUARD
#define PARROT_BCG_LOGGER_H_GUARD

#include "bcg.h"

#define MAX_MESSAGE_SIZE 1024
#define BCG_THROW(bcg, excp)   longjmp((bcg)->jump_location, (excp));

void bcg_throw_exception(BCG_info * bcg_info, const int code,
                         const char *format, ...);

#ifdef WIN32
#  if !defined(vsnprintf)
#    define vsnprintf _vsnprintf
#  endif /* defined(vsnprintf) */
#endif /* WIN32 */

#endif /* PARROT_BCG_LOGGER_H_GUARD */

/*
 * Local variables:
 *   c-file-style: "parrot"
 * End:
 * vim: expandtab shiftwidth=4:
 */
