package Alien::LibYAML;

use strict;
use warnings;
use 5.008001;
use parent qw(Alien::Base);

our $VERSION = 'v0.1.5'; # VERSION
# ABSTRACT: Build and install libyaml, a C-based YAML parser and emitter

1;
=encoding utf8

=head1 NAME

Alien::LibYAML - Build and install libyaml, a C-based YAML parser and emitter

=head1 SYNOPSIS

In your C<Build.PL>:

    use Alien::LibYAML;
    use Module::Build;
    
    Module::Build->new(
      ...
      extra_compiler_flags => Alien::LibYAML->cflags,
      extra_linker_flags   => Alien::LibYAML->libs,
      ...
    )->create_build_script;

=head1 DESCRIPTION

This distribution provides an alien wrapper for libyaml. It requires a C
compiler. That's all!

=head1 SEE ALSO

=over

=item L<YAML::XS>

Perl bindings for libyaml (library bundled with distribution).

=back

=head1 AUTHOR

Original Author:

Richard Simões C<< <rsimoes AT cpan DOT org> >>

Current Maintainer:

Graham Ollis C<< <plicease AT cpan DOT org> >>

=head1 COPYRIGHT AND LICENSE

Copyright © 2014 Richard Simões. libyaml written and copyrighted by Kirill
Simonov. Both libyaml and this distribution are released under the terms of the
B<MIT License> and may be modified and/or redistributed under the same or any
compatible license.
