#!/usr/bin/perl

###
# This is mostly a demo test script for using the action queue for testing
###

use strict;
use warnings;

# The real test...
package main;
use Test::More;

#use Test::NoWarnings;
use File::Temp ();
use File::Spec();

plan skip_all => 'DISPLAY not set'
 unless  $ENV{DISPLAY} or ($^O eq 'MSWin32');

my $devpl;
# Search for dev.pl
for ('.','blib/lib','lib') {
 if ($^O eq 'MSWin32') {
  next if ! -e File::Spec->catfile($_,'dev.pl');
 } else {
  next if ! -x File::Spec->catfile($_,'dev.pl');
 }
 $devpl = File::Spec->catfile($_,'dev.pl');
 last;
}

use_ok('Padre::Perl');

my $cmd;
if ($^O eq 'MSWin32') {
 # Look for Perl on Windows
 $cmd = Padre::Perl::cperl();
 plan skip_all => 'Need some Perl for this test' unless defined($cmd);
 $cmd .= ' ';
}

#plan( tests => scalar( keys %TEST ) * 2 + 20 );

# Create temp dir
my $dir = File::Temp->newdir;
$ENV{PADRE_HOME} = $dir->dirname;

# Complete the dev.pl - command
$cmd .= $devpl . ' --invisible -- --home=' . $dir->dirname;
$cmd .= ' ' . File::Spec->catfile($dir->dirname,'newfile.txt');
$cmd .= ' --actionqueue=internal.dump_padre,file.quit';

system $cmd;

my $dump_fn = File::Spec->catfile($dir->dirname,'padre.dump');

ok(-e $dump_fn,'Dump file exists');

our $VAR1;
# Read dump file into $VAR1
require_ok($dump_fn);

# Run the action checks...
for my $action (sort(keys(%{$VAR1->{actions}}))) {

 if ($action =~ /^run\./) {
  # All run actions need a open editor window and a saved file
  if ($action !~ /^run\.(stop|run_command)/) {
   ok($VAR1->{actions}->{$action}->{need_editor},$action.' requires a editor');
   ok($VAR1->{actions}->{$action}->{need_file},$action.' requires a filename');
  }
 }

 if ($action =~ /^perl\./) {
  # All perl actions need a open editor window
  ok($VAR1->{actions}->{$action}->{need_editor},$action.' requires a editor');
 }

}

done_testing();
