" Vim syntax file
" Language:    Bigtop (a language for describing database backed web apps)
" Maintaner:   Phil Crow <crow.phil@gmail.com>
" Last Change: Thu Mar 29 11:02:07 2007
" Filenames:   *.bigtop
"
" Note that this file was generated by skip/vimsyntax in the bigtop CPAN
" distribution.

if version < 600
    syntax clear
else
    if exists("b:current_syntax")
        finish
    endif
endif

syn case match

syn match  bigtopComment /^#.*/
syn region bigtopString start=+`+ end=+`+

syn keyword bigtopBlocks         block config app literal table field controller method sequence

syn keyword bigtopEngines        MP13 MP20 TT

syn keyword bigtopBackendTypes   Init SQL Conf CGI HttpdConf Control Model SiteLook

syn keyword bigtopBackends       Std SQLite MySQL Postgres General Gantry GantryDBIxClass GantryCDBI GantryDefault

syn keyword bigtopValues         no_gen no_accessor fast_cgi instance conffile with_server server_port gen_root flex_db full_use skip_config dbix model_base_class gantry_wrapper

syn keyword bigtopFieldValues    text textarea select display

syn keyword bigtopSQLKeywords    int4 varchar text boolean int primary_key assign_by_sequence auto

syn keyword bigtopAppKeywords authors contact_us copyright_holder email license_text location no_gen uses

syn keyword bigtopAppLiteralKeywords Conf GantryLocation HttpdConf Location PerlBlock PerlTop SQL

syn keyword bigtopConfigKeywords app_dir base_dir engine plugins template_engine

syn keyword bigtopControllerKeywords autocrud_helper controls_table gen_uses location namespace_base no_gen page_link_label rel_location skip_test soap_name stub_uses text_description uses

syn keyword bigtopControllerLiteralKeywords GantryLocation Location

syn keyword bigtopFieldKeywords date_select_text html_form_class html_form_cols html_form_constraint html_form_default_value html_form_display_size html_form_foreign html_form_hint html_form_onchange html_form_optional html_form_options html_form_raw_html html_form_rows html_form_type is label no_gen non_essential not_for on_delete on_update refers_to searchable

syn keyword bigtopJoinTableKeywords data joins names

syn keyword bigtopMethodKeywords all_fields_but col_labels cols expects extra_args extra_keys fields form_name header_options html_template limit_by livesearch no_gen order_by paged_conf returns row_options rows title

syn keyword bigtopTableKeywords data foreign_display model_base_class no_gen not_for refered_to_by sequence

hi def link bigtopComment                           Comment
hi def link bigtopString                            String

hi def link bigtopBlocks                            Keyword
hi def link bigtopEngines                           Constant
hi def link bigtopBackendTypes                      Keyword
hi def link bigtopBackends                          Identifier
hi def link bigtopLiteralTypes                      Identifier
hi def link bigtopMethodTypes                       Keyword

hi def link bigtopValues                            Identifier
hi def link bigtopFieldValues                       Identifier
hi def link bigtopSQLKeywords                       Identifier

hi def link bigtopAppKeywords                       Identifier
hi def link bigtopAppLiteralKeywords                Identifier
hi def link bigtopConfigKeywords                    Identifier
hi def link bigtopControllerKeywords                Identifier
hi def link bigtopControllerLiteralKeywords         Identifier
hi def link bigtopFieldKeywords                     Identifier
hi def link bigtopJoinTableKeywords                 Identifier
hi def link bigtopMethodKeywords                    Identifier
hi def link bigtopTableKeywords                     Identifier

if exists("bigtop_fold")
    syn region blockFold start="{" end ="}" transparent fold
    syn sync fromstart
    set foldmethod=syntax
endif
