package Contact::Model;
use strict; use warnings;

use base 'DBIx::Class::Schema';

use Gantry::Utils::ModelHelper qw( db_Main );

__PACKAGE__->load_classes( qw/
    number
    bday
/ );

# DBIx::Class wants a code reference which returns the dbh.  Give
# the people what they want.
sub gen_db_Main {
    my $class = shift;
    return sub {
        return $class->db_Main();
    };
}

sub get_db_options {
    return { AutoCommit => 1 };
}

1;

=head1 NAME

Contact::Model - schema class for Contact

=head1 SYNOPSIS

In your base module:

    use Contact::Model;
    sub schema_base_class { return 'Contact::Model'; }
    use Gantry::Plugins::DBIxClassConn qw( get_schema );
    use Contact::Model::number qw( $NUMBER );
    use Contact::Model::bday qw( $BDAY );

=head1 DESCRIPTION

This module was generated by Bigtop.  But, feel free to edit it.  You
might even want to update these docs.

=over 4

=item gen_db_Main

=item get_db_options

The generated version sets AutoCommit to 1, this assumes that you will
do all transaction work via the DBIx::Class API.

=back

=head1 DEPENDENCIES

    Gantry::Utils::DBIxClass

=head1 AUTHOR

Phil Crow, E<lt>philcrow2000@yahoo.comE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
