#!/usr/bin/perl -w

use strict;
use CORBA::IDL::parser24;
use CORBA::IDL::symbtab;
# visitors
use CORBA::IDL::repos_id;
use CORBA::C::literal;
use CORBA::C::name;
use CORBA::C::include;

my $parser = new Parser;
$parser->YYData->{IDL_version} = '2.4';		# '2.0', '2.1', '2.2', '2.3', '2.4'
$parser->YYData->{verbose_error} = 1;		# 0, 1
$parser->YYData->{verbose_warning} = 1;		# 0, 1
$parser->YYData->{verbose_info} = 1;		# 0, 1
$parser->YYData->{verbose_deprecated} = 1;	# 0, 1 (concerns only version '2.4')
$parser->YYData->{symbtab} = new Symbtab($parser);
if ($^O eq 'MSWin32') {
	$parser->YYData->{preprocessor} = 'cpp -C -D__idl2c';
#	$parser->YYData->{preprocessor} = 'CL /E /C /nologo /D__idl2c';	# Microsoft VC
} else {
	$parser->YYData->{preprocessor} = 'cpp -C -D__idl2c';
}
$parser->Run(@ARGV);
$parser->YYData->{symbtab}->CheckForward();

if (exists $parser->YYData->{nb_error}) {
	my $nb = $parser->YYData->{nb_error};
	print "$nb error(s).\n"
}
if (exists $parser->YYData->{nb_warning}) {
	my $nb = $parser->YYData->{nb_warning};
	print "$nb warning(s).\n"
}

if (		exists $parser->YYData->{root}
		and ! exists $parser->YYData->{nb_error} ) {
	$parser->YYData->{root}->visitName(new repositoryIdVisitor($parser));
	$parser->YYData->{root}->visitName(new CnameVisitor($parser));
	$parser->YYData->{root}->visitName(new CliteralVisitor($parser));
	$parser->YYData->{root}->visitName(new ClengthVisitor($parser));
	$parser->YYData->{root}->visitName(new CtypeVisitor($parser));
	$parser->YYData->{root}->visit(new CincludeVisitor($parser));
}

__END__

=head1 NAME

idl2c - IDL compiler to language C mapping

=head1 SYNOPSYS

idl2c [options] I<spec>.idl

=head1 OPTIONS

All options are forwarded to C preprocessor.

With the GNU C Compatible Compiler Processor, useful options are :

=over 8

=item B<-D> I<name>

=item B<-D> I<name>=I<definition>

=item B<-I> I<directory>

=item B<-I->

=item B<-nostdinc>

=back

=head1 DESCRIPTION

B<idl2c> parses the given input file (IDL) and generates
a include file following the language C mapping rules.

B<idl2c> is a Perl OO application what uses the visitor design pattern.
The parser is generated by Parse::Yapp.

B<idl2c> needs Math::BigInt and Math::BigFloat modules.

B<idl2c> needs a B<cpp> executable.

CORBA Specifications, including IDL (Interface Language Definition) and
C Language Mapping are available on E<lt>http://www.omg.org/E<gt>.

=head1 SEE ALSO

cpp

=head1 COPYRIGHT

(c) 2001-2002 Francois PERRAD, France. All rights reserved.

This program and all CORBA::C modules are distributed
under the terms of the Artistic Licence.

=head1 AUTHOR

Francois PERRAD, francois.perrad@gadz.org

=cut

