package Dist::Zilla::Plugin::InsertBlock::FromModule;

our $DATE = '2015-06-18'; # DATE
our $VERSION = '0.05'; # VERSION

use 5.010001;
use strict;
use warnings;

use Module::Path::More qw(module_path);

use parent qw(Dist::Zilla::Plugin::InsertBlock);

sub _insert_block {
    my($self, $module, $name, $target) = @_;

    my $file = module_path(module=>$module) or
        $self->log_fatal(["can't find path for module %s", $module]);

    $self->SUPER::_insert_block($file, $name, $target);
}

__PACKAGE__->meta->make_immutable;
1;
# ABSTRACT: Insert a block of text from another module

__END__

=pod

=encoding UTF-8

=head1 NAME

Dist::Zilla::Plugin::InsertBlock::FromModule - Insert a block of text from another module

=head1 VERSION

This document describes version 0.05 of Dist::Zilla::Plugin::InsertBlock::FromModule (from Perl distribution Dist-Zilla-Plugin-InsertBlock), released on 2015-06-18.

=head1 SYNOPSIS

In dist.ini:

 [InsertBlock::FromModule]

In lib/Foo/Bar.pm:

 ...

 =head1 ATTRIBUTES

 # INSERT_BLOCK: Foo::Base base_attributes

 =head2 attr3

 ...

=head1 DESCRIPTION

This plugin is just like L<Dist::Zilla::Plugin::InsertBlock>, but instead of
filename in the first argument, you specify module name. Module name will then
be converted into path using L<Module::Path::More>. Die when module path is not
found.

=for Pod::Coverage .+

=head1 SEE ALSO

L<Dist::Zilla::Plugin::InsertBlock>

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Dist-Zilla-Plugin-InsertBlock>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Dist-Zilla-Plugin-InsertBlock>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Dist-Zilla-Plugin-InsertBlock>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
