package DateTime::Format::Alami::EN;

our $DATE = '2016-05-05'; # DATE
our $VERSION = '0.09'; # VERSION

use 5.010001;
use strict 'subs', 'vars';
use warnings;
use parent qw(DateTime::Format::Alami);

our $RE   = qr(\b((?P<p_date_ymd>(?: (?P<o_dayint>(?:[12][0-9]|3[01]|0?[1-9])) \s* ?(?P<o_monthname>(?:january|jan|february|feb|march|mar|april|apr|may|june|jun|july|jul|august|aug|september|sept|sep|october|oct|november|nov|december|dec)) | (?P<o_monthname>(?:january|jan|february|feb|march|mar|april|apr|may|june|jun|july|jul|august|aug|september|sept|sep|october|oct|november|nov|december|dec)) \s* (?P<o_dayint>(?:[12][0-9]|3[01]|0?[1-9]))\b|(?P<o_monthint>(?:0?[1-9]|1[012]))[ /-](?P<o_dayint>(?:[12][0-9]|3[01]|0?[1-9]))\b )(?: \s*[,/-]?\s* (?P<o_yearint>(?:[0-9]{4}|[0-9]{2})))?)|(?P<p_dur_later>(?P<o_dur>(?:((?:[+-]?(?:(?:\d{1,3}(?:[,]\d{3})+|\d+)(?:[.]\d*)?|[.]\d+)(?:[Ee][+-]?\d+)?)\s*(?:year|years|y|month|months|mon|week|weeks|wk|wks|day|days|d|hour|hours|h|minute|minutes|min|mins|second|seconds|sec|secs|s)\s*)+)) \s+ (?:later))|(?P<p_dur_ago>(?P<o_dur>(?:((?:[+-]?(?:(?:\d{1,3}(?:[,]\d{3})+|\d+)(?:[.]\d*)?|[.]\d+)(?:[Ee][+-]?\d+)?)\s*(?:year|years|y|month|months|mon|week|weeks|wk|wks|day|days|d|hour|hours|h|minute|minutes|min|mins|second|seconds|sec|secs|s)\s*)+)) \s+ (?:ago))|(?P<p_now>(?:(?:(?:right|just) \s+ )?now|immediately))|(?P<p_today>(?:today|this \s+ day))|(?P<p_yesterday>(?:yesterday|yest))|(?P<p_tomorrow>(?:tomorrow|tom)))\b)ix; # PRECOMPUTED FROM: do { DateTime::Format::Alami::EN->new; $DateTime::Format::Alami::EN::RE   }
our $MAPS = {months=>{apr=>4,april=>4,aug=>8,august=>8,dec=>12,december=>12,feb=>2,february=>2,jan=>1,january=>1,jul=>7,july=>7,jun=>6,june=>6,mar=>3,march=>3,may=>5,nov=>11,november=>11,oct=>10,october=>10,sep=>9,sept=>9,september=>9}}; # PRECOMPUTED FROM: do { DateTime::Format::Alami::EN->new; $DateTime::Format::Alami::EN::MAPS }

use Parse::Number::EN qw(parse_number_en);

sub o_num       { $Parse::Number::EN::Pat }
sub _parse_num  { parse_number_en(text => $_[1]) }
sub w_year      { ["year", "years", "y"] }
sub w_month     { ["month", "months", "mon"] }
sub w_week      { ["week", "weeks", "wk", "wks"] }
sub w_day       { ["day", "days", "d"] }
sub w_hour      { ["hour", "hours", "h"] }
sub w_minute    { ["minute", "minutes", "min", "mins"] }
sub w_second    { ["second", "seconds", "sec", "secs", "s"] }

sub w_jan       { ["january", "jan"] }
sub w_feb       { ["february", "feb"] }
sub w_mar       { ["march", "mar"] }
sub w_apr       { ["april", "apr"] }
sub w_may       { ["may"] }
sub w_jun       { ["june", "jun"] }
sub w_jul       { ["july", "jul"] }
sub w_aug       { ["august", "aug"] }
sub w_sep       { ["september", "sept", "sep"] }
sub w_oct       { ["october", "oct"] }
sub w_nov       { ["november", "nov"] }
sub w_dec       { ["december", "dec"] }

sub p_now          { "(?:(?:(?:right|just) \\s+ )?now|immediately)" }
sub p_today        { "(?:today|this \\s+ day)" }
sub p_tomorrow     { "(?:tomorrow|tom)" }
sub p_yesterday    { "(?:yesterday|yest)" }
# XXX support cardinal
sub p_date_ymd     { join(
    "",
    '(?: <o_dayint> \\s* ?<o_monthname> | <o_monthname> \\s* <o_dayint>\\b|<o_monthint>[ /-]<o_dayint>\\b )',
    '(?: \\s*[,/-]?\\s* <o_yearint>)?'
)}
sub p_dur_ago      { "<o_dur> \\s+ (?:ago)" }
sub p_dur_later    { "<o_dur> \\s+ (?:later)" }

1;
# ABSTRACT: Parse human date/time expression (English)

__END__

=pod

=encoding UTF-8

=head1 NAME

DateTime::Format::Alami::EN - Parse human date/time expression (English)

=head1 VERSION

This document describes version 0.09 of DateTime::Format::Alami::EN (from Perl distribution DateTime-Format-Alami), released on 2016-05-05.

=head1 DESCRIPTION

List of known date/time expressions:

 (just|right)? now

 today|this day
 tommorow
 yesterday

 1 year 2 months 3 weeks 4 days 5 hours 6 minutes 7 seconds (ago|later)

 may 28
 5/28

 28 may 2016
 may 28, 2016
 5/28/2016
 5-28-16

List of recognized duration expressions:

=for Pod::Coverage ^([aopw]_.+)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/DateTime-Format-Alami>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-DateTime-Format-Alami>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=DateTime-Format-Alami>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 SEE ALSO

L<DateTime::Format::Natural>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
