package Bencher::Scenario::TreeObject::descendants;

our $DATE = '2016-03-30'; # DATE
our $VERSION = '0.02'; # VERSION

use 5.010001;
use strict;
use warnings;

use Bencher::ScenarioUtil::TreeObject;
use Tree::Create::Size;

my $classes = \%Bencher::ScenarioUtil::TreeObject::classes;

our $scenario = {
    summary => 'Benchmark descendants()',
    participants => [
        map {
            my $spec = $classes->{$_};
            +{
                module => $_,
                code_template => "state \$tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => '".($spec->{use_my_class} ? "My::$_":$_)."'); my \@res = \$tree->descendants; scalar(\@res)",
            }
        } sort keys %$classes,
    ],
    datasets => \@Bencher::ScenarioUtil::TreeObject::trees_datasets,
};

1;
# ABSTRACT: Benchmark descendants()

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::TreeObject::descendants - Benchmark descendants()

=head1 VERSION

This document describes version 0.02 of Bencher::Scenario::TreeObject::descendants (from Perl distribution Bencher-Scenarios-TreeObject), released on 2016-03-30.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m TreeObject::descendants

To run module startup overhead benchmark:

 % bencher --module-startup -m TreeObject::descendants

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Tree::Object::Array> 0.06

L<Tree::Object::Array::Glob> 0.06

L<Tree::Object::Hash> 0.06

L<Tree::Object::Hash::ChildrenAsList> 0.06

L<Tree::ObjectXS::Array> 0.02

L<Tree::ObjectXS::Hash> 0.02

=head1 BENCHMARK PARTICIPANTS

=over

=item * Tree::Object::Array (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'My::Tree::Object::Array'); my @res = $tree->descendants; scalar(@res)



=item * Tree::Object::Array::Glob (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'My::Tree::Object::Array::Glob'); my @res = $tree->descendants; scalar(@res)



=item * Tree::Object::Hash (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'Tree::Object::Hash'); my @res = $tree->descendants; scalar(@res)



=item * Tree::Object::Hash::ChildrenAsList (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'Tree::Object::Hash::ChildrenAsList'); my @res = $tree->descendants; scalar(@res)



=item * Tree::ObjectXS::Array (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'My::Tree::ObjectXS::Array'); my @res = $tree->descendants; scalar(@res)



=item * Tree::ObjectXS::Hash (perl_code)

Code template:

 state $tree = Tree::Create::Size::create_tree(height => <height>, num_children => <num_children>, class => 'Tree::ObjectXS::Hash'); my @res = $tree->descendants; scalar(@res)



=back

=head1 BENCHMARK DATASETS

=over

=item * small1 (31 nodes)

A tree with height=4 and 2 children per non-leaf nodes, nodes=1 + 2 + 4 + 8 + 16 = 31

=item * small2 (364 nodes)

A tree with height=5 and 3 children per non-leaf nodes, nodes=1 + 3 + 9 + 27 + 81 + 243 = 364

=item * small3 (1365 nodes)

A tree with height=5 and 4 children per non-leaf nodes, nodes=1 + 4 + 16 + 64 + 256 + 1024 = 1365

=item * medium1 (19531 nodes)

A tree with height=6 and 5 children per non-leaf nodes, nodes=1 + 5 + 25 + 125 + 625 + 3125 + 15625 = 19531

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.0 >>, CPU: I<< Intel(R) Core(TM) i5-2400 CPU @ 3.10GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with C<< bencher -m TreeObject::descendants --include-datasets 'small1 (31 nodes)' >>:

 +------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                        | rate (/s) | time (μs) | vs_slowest | errors  | samples |
 +------------------------------------+-----------+-----------+------------+---------+---------+
 | Tree::Object::Array::Glob          | 7.1e+03   | 1.4e+02   | 1          | 1.6e-07 | 20      |
 | Tree::Object::Hash                 | 8.7e+03   | 1.2e+02   | 1.2        | 1.9e-07 | 25      |
 | Tree::Object::Array                | 9130.32   | 109.525   | 1.29226    | 9.2e-11 | 25      |
 | Tree::Object::Hash::ChildrenAsList | 1.03e+04  | 97.1      | 1.46       | 2.2e-08 | 30      |
 | Tree::ObjectXS::Hash               | 1e+04     | 96        | 1.5        | 1e-07   | 33      |
 | Tree::ObjectXS::Array              | 1.07e+04  | 93.1      | 1.52       | 2.1e-08 | 32      |
 +------------------------------------+-----------+-----------+------------+---------+---------+


Benchmark with C<< bencher -m TreeObject::descendants --include-datasets 'medium1 (19531 nodes)' >>:

 +------------------------------------+-----------+-----------+------------+---------+---------+
 | participant                        | rate (/s) | time (ms) | vs_slowest | errors  | samples |
 +------------------------------------+-----------+-----------+------------+---------+---------+
 | Tree::Object::Array::Glob          | 24        | 42        | 1          | 6.7e-05 | 21      |
 | Tree::Object::Hash                 | 28        | 36        | 1.2        | 7.4e-05 | 20      |
 | Tree::Object::Hash::ChildrenAsList | 32        | 31        | 1.3        | 3.5e-05 | 20      |
 | Tree::Object::Array                | 32        | 31        | 1.3        | 4.5e-05 | 20      |
 | Tree::ObjectXS::Hash               | 35.6      | 28.1      | 1.48       | 1.8e-05 | 20      |
 | Tree::ObjectXS::Array              | 36        | 28        | 1.5        | 3.2e-05 | 21      |
 +------------------------------------+-----------+-----------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenarios-TreeObject>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenarios-TreeObject>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenarios-TreeObject>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
