package Bencher::Scenario::ModuleInstalledTiny;

our $DATE = '2016-08-07'; # DATE
our $VERSION = '0.001'; # VERSION

use 5.010001;
use strict;
use warnings;

our $scenario = {
    summary => 'Benchmark Module::Installed::Tiny',
    participants => [
        {
            fcall_template => 'Module::Installed::Tiny::module_installed(<module>)',
        },
        {
            fcall_template => 'Module::Path::More::module_path(module => <module>)',
        },
        {
            fcall_template => 'Module::Load::Conditional::check_install(module => <module>)',
        },
        {
            name => 'require',
            code_template => 'eval { (my $pm = <module> . ".pm") =~ s!::!/!g; require $pm; 1 } ? 1:0',
        },
    ],
    datasets => [
        {args=>{module=>'strict'}},
        #{args=>{module=>'App::Cpan'}}, # an example of a relatively heavy core module to load
        {args=>{module=>'Foo::Bar'}},
    ],
};

1;
# ABSTRACT: Benchmark Module::Installed::Tiny

__END__

=pod

=encoding UTF-8

=head1 NAME

Bencher::Scenario::ModuleInstalledTiny - Benchmark Module::Installed::Tiny

=head1 VERSION

This document describes version 0.001 of Bencher::Scenario::ModuleInstalledTiny (from Perl distribution Bencher-Scenario-ModuleInstalledTiny), released on 2016-08-07.

=head1 SYNOPSIS

To run benchmark with default option:

 % bencher -m ModuleInstalledTiny

To run module startup overhead benchmark:

 % bencher --module-startup -m ModuleInstalledTiny

For more options (dump scenario, list/include/exclude/add participants, list/include/exclude/add datasets, etc), see L<bencher> or run C<bencher --help>.

=head1 BENCHMARKED MODULES

Version numbers shown below are the versions used when running the sample benchmark.

L<Module::Installed::Tiny> 0.003

L<Module::Path::More> 0.31

L<Module::Load::Conditional> 0.64

=head1 BENCHMARK PARTICIPANTS

=over

=item * Module::Installed::Tiny::module_installed (perl_code)

Function call template:

 Module::Installed::Tiny::module_installed(<module>)



=item * Module::Path::More::module_path (perl_code)

Function call template:

 Module::Path::More::module_path(module => <module>)



=item * Module::Load::Conditional::check_install (perl_code)

Function call template:

 Module::Load::Conditional::check_install(module => <module>)



=item * require (perl_code)

Code template:

 eval { (my $pm = <module> . ".pm") =~ s!::!/!g; require $pm; 1 } ? 1:0



=back

=head1 BENCHMARK DATASETS

=over

=item * strict

=item * Foo::Bar

=back

=head1 SAMPLE BENCHMARK RESULTS

Run on: perl: I<< v5.22.2 >>, CPU: I<< Intel(R) Core(TM) i7-4770 CPU @ 3.40GHz (4 cores) >>, OS: I<< GNU/Linux Debian version 8.0 >>, OS kernel: I<< Linux version 3.16.0-4-amd64 >>.

Benchmark with default options (C<< bencher -m ModuleInstalledTiny >>):

 #table1#
 +-------------------------------------------+----------+-----------+-----------+------------+---------+---------+
 | participant                               | dataset  | rate (/s) | time (μs) | vs_slowest |  errors | samples |
 +-------------------------------------------+----------+-----------+-----------+------------+---------+---------+
 | Module::Load::Conditional::check_install  | strict   |      3000 |   400     |        1   |   4e-06 |      20 |
 | Module::Load::Conditional::check_install  | Foo::Bar |     44000 |    23     |       16   | 3.1e-08 |      23 |
 | Module::Path::More::module_path           | Foo::Bar |     63400 |    15.8   |       22.8 | 5.4e-09 |      30 |
 | Module::Path::More::module_path           | strict   |     67500 |    14.8   |       24.2 |   6e-09 |      25 |
 | require                                   | Foo::Bar |     80000 |    12     |       29   | 1.3e-08 |      20 |
 | Module::Installed::Tiny::module_installed | Foo::Bar |     81400 |    12.3   |       29.3 | 2.8e-09 |      28 |
 | Module::Installed::Tiny::module_installed | strict   |   2250000 |     0.444 |      809   | 2.1e-10 |      20 |
 | require                                   | strict   |   4810000 |     0.208 |     1730   | 1.1e-10 |      21 |
 +-------------------------------------------+----------+-----------+-----------+------------+---------+---------+


Benchmark module startup overhead (C<< bencher -m ModuleInstalledTiny --module-startup >>):

 #table2#
 +---------------------------+-----------+------------------------+------------+---------+---------+
 | participant               | time (ms) | mod_overhead_time (ms) | vs_slowest |  errors | samples |
 +---------------------------+-----------+------------------------+------------+---------+---------+
 | Module::Load::Conditional |      22   |                   19.7 |        1   | 4.6e-05 |      20 |
 | Module::Installed::Tiny   |       4.6 |                    2.3 |        4.8 | 9.9e-06 |      20 |
 | Module::Path::More        |       4.6 |                    2.3 |        4.9 |   2e-05 |      20 |
 | perl -e1 (baseline)       |       2.3 |                    0   |        9.7 | 3.1e-06 |      20 |
 +---------------------------+-----------+------------------------+------------+---------+---------+

=head1 DESCRIPTION

Packaging a benchmark script as a Bencher scenario makes it convenient to include/exclude/add participants/datasets (either via CLI or Perl code), send the result to a central repository, among others . See L<Bencher> and L<bencher> (CLI) for more details.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Bencher-Scenario-ModuleInstalledTiny>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Bencher-Scenario-ModuleInstalledTiny>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Bencher-Scenario-ModuleInstalledTiny>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
