package App::BenchPermuteNamedModules;

our $DATE = '2015-10-03'; # DATE
our $VERSION = '0.01'; # VERSION

use 5.010001;
use strict;
use warnings;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT_OK = qw(@participants @datasets);

our @participants = (
    {
        module => "PERLANCAR::Permute::Named",
        code => sub {
            my @res = PERLANCAR::Permute::Named::permute_named(@_);
        },
    },
    {
        module => "Permute::Named",
        code => sub {
            my @res = Permute::Named::permute_named(@_);
        },
    },
    {
        module => "Permute::Named::Iter",
        code => sub {
            my $iter = Permute::Named::Iter::permute_named_iter(@_);
            my @res;
            while (my $h = $iter->()) { push @res, $h }
        },
    },
);

our @datasets = (
    {args=>[a=>[1,2], b=>[1,2,3]], name=>'small (2x3=6)'},
    {args=>[a=>[1,2], b=>[1..50]], name=>'long (2x50=100)'},
    {args=>[a=>[1,2], a=>[1,2], c=>[1,2], d=>[1,2], e=>[1,2], f=>[1,2], g=>[1,2], h=>[1,2], i=>[1,2], j=>[1,2]], name=>'wide (2**10=1k)'},
    {args=>[a=>[1..10], b=>[1..10], c=>[1..10], d=>[1..2], e=>[1..2], f=>[1..3]], name=>'large (10x10x10x2x2x3=12ki)'},
);

# ABSTRACT: Benchmark various modules doing permutation of multiple-valued key-value pairs

__END__

=pod

=encoding UTF-8

=head1 NAME

App::BenchPermuteNamedModules - Benchmark various modules doing permutation of multiple-valued key-value pairs

=head1 VERSION

This document describes version 0.01 of App::BenchPermuteNamedModules (from Perl distribution App-BenchPermuteNamedModules), released on 2015-10-03.

=head1 DESCRIPTION

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/App-BenchPermuteNamedModules>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-App-BenchPermuteNamedModules>.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=App-BenchPermuteNamedModules>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by perlancar@cpan.org.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
