#
# $Id: Makefile.PL 1304 2015-01-26 07:50:36Z willem $
#


warn <<AMEN if $] < 5.008;

Net::DNS::SEC has been tested with Perl 5.8

The author is confident that this package will work with version 5.6
but not confident that it will work with any earlier version.

The latest version of perl can always be found at:
	http://www.cpan.org/src/latest.tar.gz
AMEN

use ExtUtils::MakeMaker;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

my %prerequisite = (
	Net::DNS		=> 0.69,
	Crypt::OpenSSL::Bignum	=> 0.04,
	Crypt::OpenSSL::DSA	=> 0.10,
	Crypt::OpenSSL::RSA	=> 0.19,
	Digest::SHA		=> 5.23,
	File::Spec		=> 0.0,
	MIME::Base32		=> 0.0,
	MIME::Base64		=> 0.0,
	Time::Local		=> 0.0,
	Test::More		=> 0.47,
	);

my %optional = (
	Crypt::OpenSSL::EC	=> 0.6,
	Crypt::OpenSSL::ECDSA	=> 0.05,
	Crypt::OpenSSL::Random	=> 0.06,
	Digest::BubbleBabble	=> 0.01,
	Digest::GOST		=> 0.06,
	);


foreach my $module ( keys %optional ) {
	delete $optional{$module} unless eval("require $module");
}


WriteMakefile(
	NAME		 => 'Net::DNS::SEC',
	VERSION_FROM	 => 'SEC.pm',
	ABSTRACT	 => 'DNSSEC extensions to Net::DNS',
	AUTHOR		 => 'Olaf M. Kolkman <olaf@net-dns.org>',
	LICENSE		 => 'mit',
	MIN_PERL_VERSION => 5.006,
	PREREQ_PM	 => {%prerequisite, %optional},

	PM => { 'SEC.pm'	   => '$(INST_LIBDIR)/SEC.pm',
		'SEC/DSA.pm'	   => '$(INST_LIBDIR)/SEC/DSA.pm',
		'SEC/ECDSA.pm'	   => '$(INST_LIBDIR)/SEC/ECDSA.pm',
		'SEC/ECCGOST.pm'   => '$(INST_LIBDIR)/SEC/ECCGOST.pm',
		'SEC/RSA.pm'	   => '$(INST_LIBDIR)/SEC/RSA.pm',
		'SEC/Keyset.pm'	   => '$(INST_LIBDIR)/SEC/Keyset.pm',
		'SEC/Private.pm'   => '$(INST_LIBDIR)/SEC/Private.pm',
		'RR/CDNSKEY.pm'	   => '$(INST_LIBDIR)/RR/CDNSKEY.pm',
		'RR/CDS.pm'	   => '$(INST_LIBDIR)/RR/CDS.pm',
		'RR/DLV.pm'	   => '$(INST_LIBDIR)/RR/DLV.pm',
		'RR/DNSKEY.pm'	   => '$(INST_LIBDIR)/RR/DNSKEY.pm',
		'RR/DS.pm'	   => '$(INST_LIBDIR)/RR/DS.pm',
		'RR/KEY.pm'	   => '$(INST_LIBDIR)/RR/KEY.pm',
		'RR/NSEC.pm'	   => '$(INST_LIBDIR)/RR/NSEC.pm',
		'RR/NSEC3.pm'	   => '$(INST_LIBDIR)/RR/NSEC3.pm',
		'RR/NSEC3PARAM.pm' => '$(INST_LIBDIR)/RR/NSEC3PARAM.pm',
		'RR/RRSIG.pm'	   => '$(INST_LIBDIR)/RR/RRSIG.pm',
		'RR/SIG.pm'	   => '$(INST_LIBDIR)/RR/SIG.pm',
		'KeysetStub.pm'	   => '$(INST_LIBDIR)/Keyset.pm',
		},

	clean => {FILES => "*~"}

	);


sub MY::libscan {
	my $path = $_[1];
	return '' if $path =~ /\B\.svn\b/;
	return $path;
}
