#!/usr/bin/perl -w

=head1 NAME

list.pl - Geo::Integer simple example

=cut

use strict;
use Geo::Integer;
my $gint=Geo::Integer->new;

foreach my $dlat (35 .. 45) {
  foreach my $dlon (-120 .. -70) {
    foreach my $mlat (0 .. 59) {
      foreach my $mlon (0 .. 59) {
        my $lat=$dlat + $mlat / 60;
        my $lon=$dlon + $mlon / 60;
        my $int=$gint->integer($lat, $lon);
        printf "%f,%f,%u\n", $lat, $lon, $int;
      }
    }
  }
}

__END__

=head2 SEE ALSO

http://search.cpan.org/src/MRDVT/Geo-Integer-0.02/scripts/list.png

=head2 SAMPLE OUTPUT

  35.266667,-119.516667,1301152840
  35.266667,-119.500000,1301152866
  35.266667,-119.483333,1301152960
  35.266667,-119.466667,1301152970
  35.266667,-119.450000,1301153000
  35.266667,-119.433333,1301153346
  35.266667,-119.416667,1301153376
  35.266667,-119.400000,1301153386
  35.266667,-119.383333,1301153480
  35.266667,-119.366667,1301153506
  35.266667,-119.350000,1301154880
  35.266667,-119.333333,1301154912
  35.266667,-119.316667,1301154922
  35.266667,-119.300000,1301155016
  35.266667,-119.283333,1301155042
  35.266667,-119.266667,1301155392
  35.266667,-119.250000,1301155402
  35.266667,-119.233333,1301155432
  35.266667,-119.216667,1301155522
  35.266667,-119.200000,1301155552
  35.266667,-119.183333,1301155562
  35.266667,-119.166667,1301161032

=cut
