/* -*- Mode: C -*- */

/*
 *
 * Copyright (c) 2002, Bryan Jurish.  All rights reserved.
 *
 * This package is free software.  You may redistribute it
 * and/or modify it under the same terms as Perl itself.
 *
 */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "rsynth.h"

#//---------------- defines & globals

typedef char *CharPtr;

//#define RSXS_DEBUG_SV2C 1
#undef RSXS_DEBUG_SV2C

#define RSXS_DEBUG_CONFIGURE 1
//#undef RSXS_DEBUG_CONFIGURE

//#define RSXS_DEBUG_FILE 1
#undef RSXS_DEBUG_FILE

//#define RSXS_DEBUG_STRING 1
#undef RSXS_DEBUG_STRING

#define RSXS_DEBUG 1
//#indef RSXS_DEBUG

char * program = "rsynth-xs";



#//---------------- constant stuff, generated by h2xs
static int
not_here(char *s)
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static double
constant_N(char *name, int len, int arg)
{
    switch (name[1 + 0]) {
    case 'A':
	if (strEQ(name + 1, "ATURAL")) {	/* N removed */
#ifdef NATURAL
	    return NATURAL;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 1, "PAR")) {	/* N removed */
#ifdef NPAR
	    return NPAR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_R(char *name, int len, int arg)
{
    if (1 + 3 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[1 + 3]) {
    case 'R':
	if (strEQ(name + 1, "SY_RUNNING")) {	/* R removed */
#ifdef RSY_RUNNING
	    return RSY_RUNNING;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 1, "SY_USEAUDIO")) {	/* R removed */
#ifdef RSY_USEAUDIO
	    return RSY_USEAUDIO;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_SUN_L(char *name, int len, int arg)
{
    if (5 + 3 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[5 + 3]) {
    case '1':
	if (strEQ(name + 5, "IN_16")) {	/* SUN_L removed */
#ifdef SUN_LIN_16
	    return SUN_LIN_16;
#else
	    goto not_there;
#endif
	}
    case '8':
	if (strEQ(name + 5, "IN_8")) {	/* SUN_L removed */
#ifdef SUN_LIN_8
	    return SUN_LIN_8;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_SUN_U(char *name, int len, int arg)
{
    switch (name[5 + 0]) {
    case 'L':
	if (strEQ(name + 5, "LAW")) {	/* SUN_U removed */
#ifdef SUN_ULAW
	    return SUN_ULAW;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 5, "NSPEC")) {	/* SUN_U removed */
#ifdef SUN_UNSPEC
	    return SUN_UNSPEC;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_S(char *name, int len, int arg)
{
    if (1 + 3 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[1 + 3]) {
    case 'H':
	if (strEQ(name + 1, "UN_HDRSIZE")) {	/* S removed */
#ifdef SUN_HDRSIZE
	    return SUN_HDRSIZE;
#else
	    goto not_there;
#endif
	}
    case 'L':
	if (!strnEQ(name + 1,"UN_", 3))
	    break;
	return constant_SUN_L(name, len, arg);
    case 'M':
	if (strEQ(name + 1, "UN_MAGIC")) {	/* S removed */
#ifdef SUN_MAGIC
	    return SUN_MAGIC;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (!strnEQ(name + 1,"UN_", 3))
	    break;
	return constant_SUN_U(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant(char *name, int len, int arg)
{
    errno = 0;
    switch (name[0 + 0]) {
    case 'A':
	if (strEQ(name + 0, "ALL_PARALLEL")) {	/*  removed */
#ifdef ALL_PARALLEL
	    return ALL_PARALLEL;
#else
	    goto not_there;
#endif
	}
    case 'C':
	if (strEQ(name + 0, "CASCADE_PARALLEL")) {	/*  removed */
#ifdef CASCADE_PARALLEL
	    return CASCADE_PARALLEL;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 0, "IMPULSIVE")) {	/*  removed */
#ifdef IMPULSIVE
	    return IMPULSIVE;
#else
	    goto not_there;
#endif
	}
    case 'N':
	return constant_N(name, len, arg);
    case 'P':
	if (strEQ(name + 0, "PI")) {	/*  removed */
#ifdef PI
	    return PI;
#else
	    goto not_there;
#endif
	}
    case 'R':
	return constant_R(name, len, arg);
    case 'S':
	return constant_S(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}




MODULE = Speech::Rsynth		PACKAGE = Speech::Rsynth    PREFIX = rsxs_

#//---------------- h2xs-generated constant stuff

double
constant(sv,arg)
    PREINIT:
	STRLEN		len;
    INPUT:
	SV *		sv
	char *		s = SvPV(sv, len);
	int		arg
    CODE:
	RETVAL = constant(s,len,arg);
    OUTPUT:
	RETVAL


#//---------------- Extra bootstrap code
BOOT:
#ifdef RSXS_DEBUG
   printf("Perl librsynth interface bootstrapping.\n");
#endif


#//---------------- Constructor
rsynth_synth_ptr
rsxs_New(CLASS)
        char *CLASS
    CODE:
    {
      /*RETVAL = (rsynth_synth_ptr)rsynth_new();*/
      RETVAL = (rsynth_synth_ptr)safemalloc(sizeof(rsynth_synth));
        if( RETVAL == NULL ){
	  warn("unable to malloc rsynth_synth");
	  XSRETURN_UNDEF;
        } else {
	  rsynth_initialize(RETVAL);
	}
    }
    OUTPUT:
        RETVAL

#//---------------- Destructor
void
rsxs_DESTROY(synth)
        rsynth_synth_ptr synth
    CODE:
    {
#ifdef RSXS_DEBUG
      printf("# destroying object %s\n", SvPV(ST(0),PL_na) );
#endif
      // call rsynth pre-destructor
      rsynth_clear(synth);

      // call native perl free
      safefree((rsynth_synth *)synth);
    };


#//---------------- start the synth
int
rsxs_Start(synth)
     rsynth_synth_ptr synth
     CODE:
       RETVAL = rsynth_start(synth);
     OUTPUT:
       RETVAL

#//--------------- stop the synth
int
rsxs_Stop(synth)
     rsynth_synth_ptr synth
     CODE:
       RETVAL = rsynth_stop(synth);
     OUTPUT:
       RETVAL

#//--------------- sync the synth
int
rsxs_Sync(synth)
     rsynth_synth_ptr synth
     CODE:
       RETVAL = rsynth_sync(synth);
     OUTPUT:
       RETVAL


#//--------------- Configure the synth (dummy)
int
rsxs_Configure_Dummy(synth)
     rsynth_synth_ptr synth
     CODE:
       RETVAL = rsynth_configure(synth,0,NULL);
     OUTPUT:
       RETVAL

#//---------------- speak to me!
void
rsxs_Say_String(synth,val)
       rsynth_synth_ptr synth
       char * val
     CODE:
#     ifdef RSXS_DEBUG_STRING
       printf("Say_String: got string '%s'\n", val);
#     endif
       say_string(synth,val);
#     ifdef RSXS_DEBUG_STRING
       printf("Say_String: done.\n", val);
#     endif


#//---------------- speak to me streamingly
void
rsxs_Say_File(synth,file)
       rsynth_synth_ptr synth
       FILE *file
     CODE:
#     ifdef RSXS_DEBUG_FILE
       printf("Saying file: %d (stdin=%d)\n", fileno(file),fileno(stdin));
#     endif
       say_file(synth,file);
#     ifdef RSXS_DEBUG_FILE
       printf("said file: %d\n", fileno(file));
#     endif



#/*--------------------------------------------------------------
# * Accessors / Manipulators get autgenerated below here!
# *--------------------------------------------------------------*/

int
rsxs_get_flags ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->flags;
	 OUTPUT:
	   RETVAL

int
rsxs_set_flags ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->flags = (int)val;
	   RETVAL = (int)synth->flags;
	 OUTPUT:
	   RETVAL

int
rsxs_get_verbose ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->verbose;
	 OUTPUT:
	   RETVAL

int
rsxs_set_verbose ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->verbose = (int)val;
	   RETVAL = (int)synth->verbose;
	 OUTPUT:
	   RETVAL

int
rsxs_get_help_only ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->help_only;
	 OUTPUT:
	   RETVAL

int
rsxs_set_help_only ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->help_only = (int)val;
	   RETVAL = (int)synth->help_only;
	 OUTPUT:
	   RETVAL

int
rsxs_get_samp_rate ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->samp_rate;
	 OUTPUT:
	   RETVAL

int
rsxs_set_samp_rate ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->samp_rate = (int)val;
	   RETVAL = (int)synth->samp_rate;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_get_dev_filename ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (CharPtr)synth->dev_filename;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_set_dev_filename ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   CharPtr val
	 CODE:
	   if (synth->dev_filename) { Safefree(synth->dev_filename); synth->dev_filename = NULL; }
	   if (val) { synth->dev_filename = savepv(val); }
	   RETVAL = (CharPtr)synth->dev_filename;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_get_linear_filename ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (CharPtr)synth->linear_filename;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_set_linear_filename ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   CharPtr val
	 CODE:
	   if (synth->linear_filename) { Safefree(synth->linear_filename); synth->linear_filename = NULL; }
	   if (val) { synth->linear_filename = savepv(val); }
	   RETVAL = (CharPtr)synth->linear_filename;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_get_au_filename ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (CharPtr)synth->au_filename;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_set_au_filename ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   CharPtr val
	 CODE:
	   if (synth->au_filename) { Safefree(synth->au_filename); synth->au_filename = NULL; }
	   if (val) { synth->au_filename = savepv(val); }
	   RETVAL = (CharPtr)synth->au_filename;
	 OUTPUT:
	   RETVAL

int
rsxs_get_dev_fd ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->dev_fd;
	 OUTPUT:
	   RETVAL

int
rsxs_set_dev_fd ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->dev_fd = (int)val;
	   RETVAL = (int)synth->dev_fd;
	 OUTPUT:
	   RETVAL

int
rsxs_get_linear_fd ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->linear_fd;
	 OUTPUT:
	   RETVAL

int
rsxs_set_linear_fd ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->linear_fd = (int)val;
	   RETVAL = (int)synth->linear_fd;
	 OUTPUT:
	   RETVAL

int
rsxs_get_au_fd ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->au_fd;
	 OUTPUT:
	   RETVAL

int
rsxs_set_au_fd ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->au_fd = (int)val;
	   RETVAL = (int)synth->au_fd;
	 OUTPUT:
	   RETVAL

int
rsxs_get_mSec_per_frame ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->mSec_per_frame;
	 OUTPUT:
	   RETVAL

int
rsxs_set_mSec_per_frame ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->mSec_per_frame = (int)val;
	   RETVAL = (int)synth->mSec_per_frame;
	 OUTPUT:
	   RETVAL

int
rsxs_get_impulse ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->impulse;
	 OUTPUT:
	   RETVAL

int
rsxs_set_impulse ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->impulse = (int)val;
	   RETVAL = (int)synth->impulse;
	 OUTPUT:
	   RETVAL

int
rsxs_get_casc ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->casc;
	 OUTPUT:
	   RETVAL

int
rsxs_set_casc ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->casc = (int)val;
	   RETVAL = (int)synth->casc;
	 OUTPUT:
	   RETVAL

int
rsxs_get_klatt_f0_flutter ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->klatt_global.f0_flutter;
	 OUTPUT:
	   RETVAL

int
rsxs_set_klatt_f0_flutter ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->klatt_global.f0_flutter = (int)val;
	   RETVAL = (int)synth->klatt_global.f0_flutter;
	 OUTPUT:
	   RETVAL

int
rsxs_get_klatt_tilt_db ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->def_pars.TLTdb;
	 OUTPUT:
	   RETVAL

int
rsxs_set_klatt_tilt_db ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->def_pars.TLTdb = (int)val;
	   RETVAL = (int)synth->def_pars.TLTdb;
	 OUTPUT:
	   RETVAL

int
rsxs_get_klatt_f0_hz ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->def_pars.F0hz10;
	 OUTPUT:
	   RETVAL

int
rsxs_set_klatt_f0_hz ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->def_pars.F0hz10 = (int)val;
	   RETVAL = (int)synth->def_pars.F0hz10;
	 OUTPUT:
	   RETVAL

int
rsxs_get_speed ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (int)synth->speed;
	 OUTPUT:
	   RETVAL

int
rsxs_set_speed ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   int val
	 CODE:
	   synth->speed = (int)val;
	   RETVAL = (int)synth->speed;
	 OUTPUT:
	   RETVAL

double
rsxs_get_frac ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (double)synth->frac;
	 OUTPUT:
	   RETVAL

double
rsxs_set_frac ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   double val
	 CODE:
	   synth->frac = (double)val;
	   RETVAL = (double)synth->frac;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_get_par_name ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (CharPtr)synth->par_name;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_set_par_name ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   CharPtr val
	 CODE:
	   if (synth->par_name) { Safefree(synth->par_name); synth->par_name = NULL; }
	   if (val) { synth->par_name = savepv(val); }
	   RETVAL = (CharPtr)synth->par_name;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_get_jsru_name ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (CharPtr)synth->jsru_name;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_set_jsru_name ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   CharPtr val
	 CODE:
	   if (synth->jsru_name) { Safefree(synth->jsru_name); synth->jsru_name = NULL; }
	   if (val) { synth->jsru_name = savepv(val); }
	   RETVAL = (CharPtr)synth->jsru_name;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_get_dict_path ( synth )
	 INPUT:
	   rsynth_synth_ptr synth
	 CODE:
	   RETVAL = (CharPtr)synth->rsdict.dict_path;
	 OUTPUT:
	   RETVAL

CharPtr
rsxs_set_dict_path ( synth, val )
	 INPUT:
	   rsynth_synth_ptr synth
	   CharPtr val
	 CODE:
	   if (synth->rsdict.dict_path) { Safefree(synth->rsdict.dict_path); synth->rsdict.dict_path = NULL; }
	   if (val) { synth->rsdict.dict_path = savepv(val); }
	   RETVAL = (CharPtr)synth->rsdict.dict_path;
	 OUTPUT:
	   RETVAL


