=head1 NAME

Convert::BER::XS - I<very> low level BER decoding

=head1 SYNOPSIS

 use Convert::BER::XS ':all';

 my $ber = ber_decode $buf
    or die "unable to decode SNMP v1/v2c Message";

 my $msg = ber_is_seq $ber
    or die "SNMP message does not start with a sequence";

 ber_is $msg->[0], ASN_UNIVERSAL, ASN_INTEGER32, 0
    or die "SNMP message does not start with snmp version\n";

 if ($msg->[0][BER_DATA] == 0 || $msg->[0][BER_DATA] == 1) {
    # message is SNMP v1 or v2c

    if (ber_is $msg->[2], ASN_CONTEXT, 4, 1) {
       # message is v1 trap
       my $trap = $msg->[2][BER_DATA];

       # check whether trap is a cisco mac notification mac changed message
       if (
          (ber_is_oid $trap->[0], "1.3.6.1.4.1.9.9.215.2") # cmnInterfaceObjects
          and (ber_is_i32 $trap->[2], 6)
          and (ber_is_i32 $trap->[3], 1) # mac changed msg
       ) {
          ... and so on

=head1 DESCRIPTION

This module implements a I<very> low level BER/DER decoder, and in the
future, probably also an encoder (tell me if you want an encoder, this
might speed up the process of getting one).

If is tuned for low memory and high speed, while still maintaining some
level of user-friendlyness.

Currently, not much is documented, as this is an initial release to
reserve CPAN namespace, stay tuned for a few days.

=cut

package Convert::BER::XS;

use common::sense;

use XSLoader ();
use Exporter qw(import);

our $VERSION = '0.0';

XSLoader::load __PACKAGE__, $VERSION;

our %EXPORT_TAGS = (
   all => [qw(
      ber_decode
      ber_is ber_is_seq ber_is_i32 ber_is_oid
      BER_CLASS BER_TAG BER_CONSTRUCTED BER_DATA
      ASN_BOOLEAN ASN_INTEGER32 ASN_BIT_STRING ASN_OCTET_STRING ASN_NULL ASN_OBJECT_IDENTIFIER ASN_TAG_BER ASN_TAG_MASK
      ASN_CONSTRUCTED ASN_UNIVERSAL ASN_APPLICATION ASN_CONTEXT ASN_PRIVATE ASN_CLASS_MASK ASN_CLASS_SHIFT
      ASN_SEQUENCE ASN_IPADDRESS ASN_COUNTER32 ASN_UNSIGNED32 ASN_TIMETICKS ASN_OPAQUE ASN_COUNTER64
   )],
);

our @EXPORT_OK = map @$_, values %EXPORT_TAGS;

1;

=head1 AUTHOR

 Marc Lehmann <schmorp@schmorp.de>
 http://software.schmorp.de/pkg/Convert-BER-XS

=cut

